/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadlessContextPresentationEngine
implements IPresentationEngine {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IContributionFactory contributionFactory;
    private EventHandler childHandler;
    private EventHandler activeChildHandler;
    private EventHandler toBeRenderedHandler;
    private boolean createContributions = true;

    private static IEclipseContext getParentContext(MUIElement element) {
        MElementContainer parent = element.getParent();
        IEclipseContext context = null;
        while (parent != null) {
            if (parent instanceof MContext) {
                return ((MContext)parent).getContext();
            }
            parent = parent.getParent();
        }
        return context;
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            context.set(intf.getName(), (Object)contextModel);
            HeadlessContextPresentationEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    @PostConstruct
    void postConstruct() {
        this.childHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element;
                if ("ADD".equals(event.getProperty("EventType")) && (element = event.getProperty("NewValue")) instanceof MUIElement) {
                    MPartStack stack;
                    List children;
                    Object parent = event.getProperty("ChangedElement");
                    HeadlessContextPresentationEngine.this.createGui((MUIElement)element, parent);
                    if (parent instanceof MPartStack && (children = (stack = (MPartStack)parent).getChildren()).size() == 1) {
                        stack.setSelectedElement((MUIElement)((MPart)element));
                    }
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childHandler);
        this.activeChildHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object element = event.getProperty("NewValue");
                if (element instanceof MUIElement) {
                    Object parent = event.getProperty("ChangedElement");
                    HeadlessContextPresentationEngine.this.createGui((MUIElement)element, parent);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.activeChildHandler);
        this.toBeRenderedHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                Boolean value = (Boolean)event.getProperty("NewValue");
                if (value.booleanValue()) {
                    HeadlessContextPresentationEngine.this.createGui(element, element.getParent());
                } else {
                    HeadlessContextPresentationEngine.this.removeGui(element);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
    }

    public void setCreateContributions(boolean createContributions) {
        this.createContributions = createContributions;
    }

    public Object createGui(MUIElement element, Object parent) {
        block10: {
            block8: {
                MPartStack container;
                block9: {
                    if (!element.isToBeRendered()) {
                        return null;
                    }
                    if (element instanceof MContext) {
                        MContribution contribution;
                        String uri;
                        MContext mcontext = (MContext)element;
                        if (mcontext.getContext() != null) {
                            return null;
                        }
                        String contextName = String.valueOf(element.getClass().getInterfaces()[0].getName()) + " eclipse context";
                        IEclipseContext parentContext = HeadlessContextPresentationEngine.getParentContext(element);
                        IEclipseContext createdContext = parentContext != null ? parentContext.createChild(contextName) : EclipseContextFactory.create((String)contextName);
                        HeadlessContextPresentationEngine.populateModelInterfaces(mcontext, createdContext, element.getClass().getInterfaces());
                        for (String variable : mcontext.getVariables()) {
                            createdContext.declareModifiable(variable);
                        }
                        mcontext.setContext(createdContext);
                        if (element instanceof MContribution && this.createContributions && (uri = (contribution = (MContribution)element).getContributionURI()) != null) {
                            Object clientObject = this.contributionFactory.create(uri, createdContext);
                            contribution.setObject(clientObject);
                        }
                        if (parentContext != null && parentContext.getLocal("activeChildContext") == null) {
                            parentContext.set("activeChildContext", (Object)createdContext);
                        }
                    }
                    if (!(element instanceof MPartStack)) break block8;
                    container = (MPartStack)element;
                    MPart active = (MPart)container.getSelectedElement();
                    if (active == null) break block9;
                    this.createGui((MUIElement)active, container);
                    break block10;
                }
                List children = container.getChildren();
                if (children.isEmpty()) break block10;
                container.setSelectedElement((MUIElement)((MStackElement)children.get(0)));
                break block10;
            }
            if (element instanceof MElementContainer) {
                for (Object child : ((MElementContainer)element).getChildren()) {
                    if (!(child instanceof MUIElement)) continue;
                    this.createGui((MUIElement)child, element);
                    if (!(child instanceof MContext)) continue;
                    IEclipseContext childContext = ((MContext)child).getContext();
                    IEclipseContext parentContext = HeadlessContextPresentationEngine.getParentContext((MUIElement)child);
                    if (parentContext.getLocal("activeChildContext") != null) continue;
                    parentContext.set("activeChildContext", (Object)childContext);
                }
            }
        }
        return null;
    }

    public Object createGui(MUIElement element) {
        return this.createGui(element, null);
    }

    public void removeGui(MUIElement element) {
        if (element instanceof MElementContainer) {
            for (Object child : ((MElementContainer)element).getChildren()) {
                if (!(child instanceof MUIElement)) continue;
                this.removeGui((MUIElement)child);
            }
        }
        if (element instanceof MContext) {
            MContext mcontext = (MContext)element;
            IEclipseContext context = mcontext.getContext();
            mcontext.setContext(null);
            if (context instanceof IDisposable) {
                context.dispose();
            }
        }
    }

    public Object run(MApplicationElement uiRoot, IEclipseContext appContext) {
        return 0;
    }

    public void stop() {
    }
}

