/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import org.eclipse.e4.ui.internal.workbench.ExtensionPointProxy;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenuItem;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderedMenuItemRenderer
extends SWTPartRenderer {
    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MRenderedMenuItem) || !(parent instanceof Menu)) {
            return null;
        }
        MRenderedMenuItem menuModel = (MRenderedMenuItem)element;
        Object contribution = menuModel.getContributionItem();
        if (contribution instanceof ExtensionPointProxy) {
            ExtensionPointProxy proxy = (ExtensionPointProxy)contribution;
            Object delegate = proxy.createDelegate((MApplicationElement)menuModel);
            if (delegate != null) {
                proxy.setField("dirty", (Object)Boolean.TRUE);
                return this.fill((IContributionItem)delegate, (Menu)parent);
            }
        } else if (contribution instanceof IContributionItem) {
            return this.fill((IContributionItem)contribution, (Menu)parent);
        }
        return null;
    }

    private Object fill(IContributionItem item, Menu menu) {
        int index = menu.getItemCount();
        item.fill(menu, index);
        if (index == menu.getItemCount()) {
            return null;
        }
        return menu.getItem(index);
    }

    @Override
    public Object unbindWidget(MUIElement me) {
        MRenderedMenuItem item = (MRenderedMenuItem)me;
        Object contributionItem = item.getContributionItem();
        if (contributionItem instanceof ExtensionPointProxy) {
            ExtensionPointProxy proxy = (ExtensionPointProxy)contributionItem;
            Object delegate = proxy.getDelegate();
            if (delegate instanceof IContributionItem) {
                ((IContributionItem)delegate).dispose();
            }
        } else if (contributionItem instanceof IContributionItem) {
            ((IContributionItem)contributionItem).dispose();
        }
        return super.unbindWidget(me);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    public Object getUIContainer(MUIElement element) {
        if (!(element instanceof MMenuElement)) {
            return null;
        }
        if (element.getParent().getWidget() instanceof MenuItem) {
            MenuItem mi = (MenuItem)element.getParent().getWidget();
            if (mi.getMenu() == null) {
                mi.setMenu(new Menu(mi));
            }
            return mi.getMenu();
        }
        return super.getUIContainer(element);
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
    }
}

