/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.css.core.util.impl.resources.OSGiResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.E4Testable;
import org.eclipse.e4.ui.internal.workbench.swt.ResourceUtility;
import org.eclipse.e4.ui.internal.workbench.swt.ShellActivationListener;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.e4.ui.workbench.swt.modeling.MenuServiceFilter;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.testing.TestableObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartRenderingEngine
implements IPresentationEngine {
    public static final String engineURI = "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine";
    private static final String defaultFactoryUrl = "platform:/plugin/org.eclipse.e4.ui.workbench.renderers.swt/org.eclipse.e4.ui.workbench.renderers.swt.WorkbenchRendererFactory";
    private String factoryUrl;
    IRendererFactory curFactory = null;
    MenuServiceFilter menuServiceFilter;
    Listener keyListener;
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            MElementContainer parent = changedElement.getParent();
            if (parent == null && changedElement instanceof MWindow) {
                parent = (MElementContainer)((EObjectImpl)changedElement).eContainer();
            }
            if (parent == null || parent.getWidget() == null) {
                return;
            }
            if (changedElement.isToBeRendered()) {
                Activator.trace((String)"/trace/renderer", (String)"visible -> true", null);
                PartRenderingEngine.this.createGui(changedElement);
            } else {
                Activator.trace((String)"/trace/renderer", (String)"visible -> false", null);
                PartRenderingEngine.this.removeGui(changedElement);
            }
        }
    };
    private EventHandler trimHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement added;
            Object changedObj = event.getProperty("ChangedElement");
            if (!(changedObj instanceof MTrimmedWindow)) {
                return;
            }
            MTrimmedWindow window = (MTrimmedWindow)changedObj;
            if (window.getWidget() == null) {
                return;
            }
            String eventType = (String)event.getProperty("EventType");
            if ("ADD".equals(eventType) && (added = (MUIElement)event.getProperty("NewValue")).isToBeRendered()) {
                PartRenderingEngine.this.createGui(added, window.getWidget());
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            if (!(changedObj instanceof MElementContainer)) {
                return;
            }
            MElementContainer changedElement = (MElementContainer)changedObj;
            boolean isApplication = changedObj instanceof MApplication;
            AbstractPartRenderer renderer = PartRenderingEngine.this.getRendererFor((MUIElement)changedElement);
            if (!isApplication && renderer == null) {
                return;
            }
            String eventType = (String)event.getProperty("EventType");
            if ("ADD".equals(eventType)) {
                boolean renderIt;
                Activator.trace((String)"/trace/renderer", (String)"Child Added", null);
                MUIElement added = (MUIElement)event.getProperty("NewValue");
                boolean isStack = changedObj instanceof MGenericStack;
                boolean hasWidget = added.getWidget() != null;
                boolean isSelected = added == changedElement.getSelectedElement();
                boolean bl = renderIt = !isStack || hasWidget || isSelected;
                if (renderIt) {
                    Widget w = (Widget)PartRenderingEngine.this.createGui(added);
                    if (w instanceof Control && !(w instanceof Shell)) {
                        ((Control)w).getShell().layout(new Control[]{(Control)w}, 4);
                    }
                } else if (renderer != null) {
                    renderer.childRendered((MElementContainer<MUIElement>)changedElement, added);
                }
            } else if ("REMOVE".equals(eventType)) {
                Activator.trace((String)"/trace/renderer", (String)"Child Removed", null);
                MUIElement removed = (MUIElement)event.getProperty("OldValue");
                if (!removed.isToBeRendered()) {
                    return;
                }
                if (removed.getWidget() instanceof Control) {
                    Control ctrl = (Control)removed.getWidget();
                    ctrl.setLayoutData(null);
                    ctrl.getParent().layout(new Control[]{ctrl}, 6);
                }
                if (renderer != null) {
                    renderer.hideChild((MElementContainer<MUIElement>)changedElement, removed);
                }
            }
        }
    };
    private IEclipseContext appContext;
    protected Shell testShell;
    protected MApplication theApp;
    @Inject
    @Optional
    protected IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    protected Logger logger;
    private Shell limbo;

    @Inject
    public PartRenderingEngine(@Named(value="rendererFactoryUri") @Optional String factoryUrl) {
        if (factoryUrl == null) {
            factoryUrl = defaultFactoryUrl;
        }
        this.factoryUrl = factoryUrl;
    }

    @PostConstruct
    void initialize(IEclipseContext context) {
        this.appContext = context;
        KeyFormatterFactory.setDefault((IKeyFormatter)SWTKeySupport.getKeyFormatterForPlatform());
        context.set(IPresentationEngine.class.getName(), (Object)this);
        IRendererFactory factory = null;
        IContributionFactory contribFactory = (IContributionFactory)context.get(IContributionFactory.class);
        try {
            factory = (IRendererFactory)contribFactory.create(this.factoryUrl, context);
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Could not create rendering factory");
        }
        if (factory == null) {
            try {
                factory = (IRendererFactory)contribFactory.create(defaultFactoryUrl, context);
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "Could not create default rendering factory");
            }
        }
        if (factory == null) {
            throw new IllegalStateException("Could not create any rendering factory. Aborting ...");
        }
        this.curFactory = factory;
        if (this.eventBroker != null) {
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childrenHandler);
            this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/basic/TrimmedWindow", (String)"trimBars"), this.trimHandler);
        }
    }

    @PreDestroy
    void contextDisposed() {
        if (this.eventBroker == null) {
            return;
        }
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.trimHandler);
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            context.set(intf.getName(), (Object)contextModel);
            PartRenderingEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    private String getContextName(MUIElement element) {
        StringBuilder builder = new StringBuilder(element.getClass().getSimpleName());
        String elementId = element.getElementId();
        if (elementId != null && elementId.length() != 0) {
            builder.append(" (").append(elementId).append(") ");
        }
        builder.append("Context");
        return builder.toString();
    }

    public Object createGui(MUIElement element, Object parent) {
        MContext ctxt;
        Object newWidget;
        IEclipseContext lclContext;
        MContext ctxt2;
        if (!element.isToBeRendered()) {
            return null;
        }
        if (element.getWidget() != null) {
            Control ctrl;
            if (element.getWidget() instanceof Control && parent instanceof Composite && (ctrl = (Control)element.getWidget()).getParent() != parent) {
                ctrl.setParent((Composite)parent);
            }
            return element.getWidget();
        }
        if (element instanceof MContext && (ctxt2 = (MContext)element).getContext() == null) {
            IEclipseContext parentContext = null;
            if (element.getCurSharedRef() != null) {
                MPlaceholder ph = element.getCurSharedRef();
                parentContext = this.getContext((MElementContainer<MUIElement>)ph.getParent());
            } else if (parentContext == null && element.getParent() != null) {
                parentContext = this.getContext((MElementContainer<MUIElement>)element.getParent());
            } else if (parentContext == null && element.getParent() == null) {
                this.getContext((MElementContainer<MUIElement>)((MElementContainer)((EObjectImpl)element).eContainer()));
            }
            if (parentContext == null) {
                parentContext = this.appContext;
            }
            lclContext = parentContext.createChild(this.getContextName(element));
            PartRenderingEngine.populateModelInterfaces(ctxt2, lclContext, element.getClass().getInterfaces());
            ctxt2.setContext(lclContext);
            for (String variable : ctxt2.getVariables()) {
                lclContext.declareModifiable(variable);
            }
            Map props = ctxt2.getProperties();
            for (String key : props.keySet()) {
                lclContext.set(key, props.get(key));
            }
            E4Workbench.processHierarchy((Object)element);
        }
        if ((newWidget = this.createWidget(element, parent)) != null) {
            MElementContainer parentElement;
            AbstractPartRenderer parentRenderer;
            AbstractPartRenderer renderer = this.getRendererFor(element);
            renderer.hookControllerLogic(element);
            if (element instanceof MElementContainer) {
                renderer.processContents((MElementContainer<MUIElement>)((MElementContainer)element));
            }
            renderer.postProcess(element);
            if (element.getParent() instanceof MUIElement && (parentRenderer = this.getRendererFor((MUIElement)(parentElement = element.getParent()))) != null) {
                parentRenderer.childRendered((MElementContainer<MUIElement>)parentElement, element);
            }
        } else if (element instanceof MContext && (lclContext = (ctxt = (MContext)element).getContext()) instanceof IDisposable) {
            lclContext.dispose();
        }
        return newWidget;
    }

    private IEclipseContext getContext(MElementContainer<MUIElement> parent) {
        if (parent instanceof MContext) {
            return ((MContext)parent).getContext();
        }
        return this.modelService.getContainingContext(parent);
    }

    public Object createGui(MUIElement element) {
        AbstractPartRenderer renderer;
        Object parent = null;
        MElementContainer parentME = element.getParent();
        if (parentME == null) {
            parentME = (MUIElement)((EObjectImpl)element).eContainer();
        }
        if (parentME != null && (renderer = this.getRendererFor((MUIElement)parentME)) != null) {
            parent = !element.isVisible() ? this.getLimboShell() : renderer.getUIContainer(element);
        }
        return this.createGui(element, parent);
    }

    private Shell getLimboShell() {
        if (this.limbo == null) {
            this.limbo = new Shell(Display.getCurrent(), 0);
        }
        return this.limbo;
    }

    public void removeGui(MUIElement element) {
        AbstractPartRenderer renderer;
        AbstractPartRenderer parentRenderer;
        MWindow win = this.modelService.getTopLevelWindowFor(element);
        if (win != element) {
            this.unhookReferences(element, win.getContext());
        } else {
            List seList = win.getSharedElements();
            for (MUIElement se : seList) {
                if (!(se.getWidget() instanceof Control)) continue;
                Control ctrl = (Control)se.getWidget();
                ctrl.dispose();
            }
        }
        MElementContainer parent = element.getParent();
        AbstractPartRenderer abstractPartRenderer = parentRenderer = parent != null ? this.getRendererFor((MUIElement)parent) : null;
        if (parentRenderer != null) {
            parentRenderer.hideChild((MElementContainer<MUIElement>)element.getParent(), element);
        }
        if ((renderer = this.getRendererFor(element)) != null) {
            renderer.disposeWidget(element);
        }
        if (element instanceof MContribution) {
            ((MContribution)element).setObject(null);
        }
        if (element instanceof MContext) {
            this.clearContext((MContext)element);
        }
    }

    private void unhookReferences(MUIElement element, IEclipseContext newContext) {
        List phList = this.modelService.findElements(element, null, MPlaceholder.class, null);
        for (MPlaceholder ph : phList) {
            IEclipseContext lclContext;
            Control refCtrl;
            MUIElement ref = ph.getRef();
            if (ref.getCurSharedRef() != ph) continue;
            if (ref.getWidget() instanceof Control && !(refCtrl = (Control)ref.getWidget()).isDisposed()) {
                refCtrl.setParent((Composite)this.getLimboShell());
            }
            if (ref instanceof MContext && (lclContext = ((MContext)ref).getContext()) != null) {
                IEclipseContext parentContext = lclContext.getParent();
                Object child = parentContext.get("activeChildContext");
                if (child == lclContext) {
                    parentContext.set("activeChildContext", null);
                }
                lclContext.setParent(newContext);
            }
            ref.setCurSharedRef(null);
        }
    }

    private void clearContext(MContext contextME) {
        MContext ctxt = contextME;
        IEclipseContext lclContext = ctxt.getContext();
        if (lclContext != null) {
            IEclipseContext parentContext = lclContext.getParent();
            Object child = parentContext.get("activeChildContext");
            if (child == lclContext) {
                parentContext.set("activeChildContext", null);
            }
            ctxt.setContext(null);
            if (lclContext instanceof IDisposable) {
                lclContext.dispose();
            }
        }
    }

    protected Object createWidget(MUIElement element, Object parent) {
        Object newWidget;
        AbstractPartRenderer renderer = this.getRenderer(element, parent);
        if (renderer != null && (newWidget = renderer.createWidget(element, parent)) != null) {
            renderer.bindWidget(element, newWidget);
            return newWidget;
        }
        return null;
    }

    private AbstractPartRenderer getRenderer(MUIElement uiElement, Object parent) {
        return this.curFactory.getRenderer(uiElement, parent);
    }

    protected AbstractPartRenderer getRendererFor(MUIElement element) {
        return (AbstractPartRenderer)element.getRenderer();
    }

    public Object run(final MApplicationElement uiRoot, final IEclipseContext runContext) {
        final Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                TestableObject testableObject;
                PartRenderingEngine.initializeStyling(display, runContext);
                runContext.set(IResourceUtilities.class.getName(), (Object)new ResourceUtility());
                KeyBindingDispatcher dispatcher = (KeyBindingDispatcher)ContextInjectionFactory.make(KeyBindingDispatcher.class, (IEclipseContext)runContext);
                runContext.set(KeyBindingDispatcher.class.getName(), (Object)dispatcher);
                PartRenderingEngine.this.keyListener = dispatcher.getKeyDownFilter();
                display.addFilter(1, PartRenderingEngine.this.keyListener);
                display.addFilter(31, PartRenderingEngine.this.keyListener);
                PartRenderingEngine.this.menuServiceFilter = (MenuServiceFilter)ContextInjectionFactory.make(MenuServiceFilter.class, (IEclipseContext)runContext);
                display.addFilter(22, (Listener)PartRenderingEngine.this.menuServiceFilter);
                display.addFilter(23, (Listener)PartRenderingEngine.this.menuServiceFilter);
                display.addFilter(12, (Listener)PartRenderingEngine.this.menuServiceFilter);
                runContext.set(MenuServiceFilter.class, (Object)PartRenderingEngine.this.menuServiceFilter);
                PartRenderingEngine.this.testShell = null;
                PartRenderingEngine.this.theApp = null;
                boolean spinOnce = true;
                if (uiRoot instanceof MApplication) {
                    ShellActivationListener shellDialogListener = new ShellActivationListener((MApplication)uiRoot);
                    display.addFilter(26, (Listener)shellDialogListener);
                    display.addFilter(27, (Listener)shellDialogListener);
                    spinOnce = false;
                    PartRenderingEngine.this.theApp = (MApplication)uiRoot;
                    for (MWindow window : PartRenderingEngine.this.theApp.getChildren()) {
                        PartRenderingEngine.this.createGui((MUIElement)window);
                    }
                    IApplicationContext ac = (IApplicationContext)PartRenderingEngine.this.appContext.get(IApplicationContext.class);
                    if (ac != null) {
                        ac.applicationRunning();
                    }
                } else if (uiRoot instanceof MUIElement) {
                    if (uiRoot instanceof MWindow) {
                        PartRenderingEngine.this.testShell = (Shell)PartRenderingEngine.this.createGui((MUIElement)uiRoot);
                    } else {
                        PartRenderingEngine.this.testShell = new Shell(display, 1264);
                        PartRenderingEngine.this.createGui((MUIElement)uiRoot, PartRenderingEngine.this.testShell);
                    }
                }
                if ((testableObject = (TestableObject)runContext.get(TestableObject.class.getName())) instanceof E4Testable) {
                    ((E4Testable)testableObject).init(display, (IWorkbench)runContext.get(IWorkbench.class.getName()));
                }
                while ((PartRenderingEngine.this.testShell != null && !PartRenderingEngine.this.testShell.isDisposed() || !PartRenderingEngine.this.theApp.getChildren().isEmpty() && PartRenderingEngine.this.someAreVisible(PartRenderingEngine.this.theApp.getChildren())) && !display.isDisposed()) {
                    try {
                        if (display.readAndDispatch()) continue;
                        runContext.processWaiting();
                        if (spinOnce) {
                            return;
                        }
                        display.sleep();
                    }
                    catch (ThreadDeath th) {
                        throw th;
                    }
                    catch (Exception ex) {
                        this.handle(ex, runContext);
                    }
                    catch (Error err) {
                        this.handle(err, runContext);
                    }
                }
                if (!spinOnce) {
                    PartRenderingEngine.this.cleanUp();
                }
            }

            private void handle(Throwable ex, IEclipseContext appContext) {
                StatusReporter statusReporter = (StatusReporter)appContext.get(StatusReporter.class.getName());
                if (statusReporter != null) {
                    statusReporter.show(4, "Internal Error", ex, new Object[0]);
                } else if (PartRenderingEngine.this.logger != null) {
                    PartRenderingEngine.this.logger.error(ex);
                }
            }
        });
        return IApplication.EXIT_OK;
    }

    protected boolean someAreVisible(List<MWindow> windows) {
        for (MWindow win : windows) {
            if (!win.isToBeRendered() || !win.isVisible() || win.getWidget() == null) continue;
            return true;
        }
        return false;
    }

    public void stop() {
        this.cleanUp();
        if (this.theApp != null) {
            for (MWindow window : this.theApp.getChildren()) {
                if (window.getWidget() == null) continue;
                ((Shell)window.getWidget()).close();
            }
        } else if (this.testShell != null && !this.testShell.isDisposed()) {
            this.testShell.close();
        }
    }

    private void cleanUp() {
        Display display;
        if (this.menuServiceFilter != null && !(display = Display.getDefault()).isDisposed()) {
            display.removeFilter(22, (Listener)this.menuServiceFilter);
            display.removeFilter(23, (Listener)this.menuServiceFilter);
            display.removeFilter(12, (Listener)this.menuServiceFilter);
            this.menuServiceFilter.dispose();
            this.menuServiceFilter = null;
            this.appContext.remove(MenuServiceFilter.class);
        }
        if (this.keyListener != null && !(display = Display.getDefault()).isDisposed()) {
            display.removeFilter(1, this.keyListener);
            display.removeFilter(31, this.keyListener);
            this.keyListener = null;
        }
    }

    public static void initializeStyling(Display display, IEclipseContext appContext) {
        String cssTheme = (String)appContext.get("cssTheme");
        String cssURI = (String)appContext.get("applicationCSS");
        if (cssTheme != null) {
            String cssResourcesURI = (String)appContext.get("applicationCSSResources");
            Bundle bundle = WorkbenchSWTActivator.getDefault().getBundle();
            BundleContext context = bundle.getBundleContext();
            ServiceReference ref = context.getServiceReference(IThemeManager.class.getName());
            IThemeManager mgr = (IThemeManager)context.getService(ref);
            final IThemeEngine engine2 = mgr.getEngineForDisplay(display);
            IContributionFactory contribution = (IContributionFactory)appContext.get(IContributionFactory.class.getName());
            IEclipseContext cssContext = EclipseContextFactory.create();
            cssContext.set(IContributionFactory.class.getName(), (Object)contribution);
            display.setData("org.eclipse.e4.ui.css.context", (Object)cssContext);
            if (cssResourcesURI != null) {
                engine2.registerResourceLocator((IResourceLocator)new OSGiResourceLocator(cssResourcesURI), new String[0]);
            }
            engine2.restore(cssTheme);
            appContext.set(IThemeEngine.class.getName(), (Object)engine2);
            appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

                public void setClassname(Object widget, String classname) {
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.CssClassName", (Object)classname);
                    engine2.applyStyles((Widget)widget, true);
                }

                public void setId(Object widget, String id) {
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.id", (Object)id);
                    engine2.applyStyles((Widget)widget, true);
                }

                public void style(Object widget) {
                    engine2.applyStyles((Widget)widget, true);
                }

                public CSSStyleDeclaration getStyle(Object widget) {
                    return engine2.getStyle((Widget)widget);
                }
            });
        } else if (cssURI != null) {
            Shell[] shells;
            CSSSWTEngineImpl engine;
            block27: {
                String cssResourcesURI = (String)appContext.get("applicationCSSResources");
                engine = new CSSSWTEngineImpl(display, true);
                if (cssResourcesURI != null) {
                    engine.getResourcesLocatorManager().registerResourceLocator((IResourceLocator)new OSGiResourceLocator(cssResourcesURI.toString()));
                }
                display.setData("org.eclipse.e4.ui.css.context", (Object)appContext);
                appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

                    public void setClassname(Object widget, String classname) {
                        ((Widget)widget).setData("org.eclipse.e4.ui.css.CssClassName", (Object)classname);
                        engine.applyStyles((Object)((Widget)widget), true);
                    }

                    public void setId(Object widget, String id) {
                        ((Widget)widget).setData("org.eclipse.e4.ui.css.id", (Object)id);
                        engine.applyStyles((Object)((Widget)widget), true);
                    }

                    public void style(Object widget) {
                        engine.applyStyles((Object)((Widget)widget), true);
                    }

                    public CSSStyleDeclaration getStyle(Object widget) {
                        Element e = engine.getCSSElementContext(widget).getElement();
                        if (e == null) {
                            return null;
                        }
                        return engine.getViewCSS().getComputedStyle(e, null);
                    }
                });
                InputStream stream = null;
                try {
                    URL url = FileLocator.resolve((URL)new URL(cssURI));
                    stream = url.openStream();
                    engine.parseStyleSheet(stream);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block27;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        break block27;
                    }
                    catch (Throwable engine2) {
                        throw engine2;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                }
                if (stream == null) break block27;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Shell[] shellArray = shells = display.getShells();
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                block29: {
                    Shell s = shellArray[n2];
                    try {
                        try {
                            s.setRedraw(false);
                            s.reskin(1);
                            engine.applyStyles((Object)s, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            s.setRedraw(true);
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        s.setRedraw(true);
                        throw throwable;
                    }
                    s.setRedraw(true);
                }
                ++n2;
            }
        }
    }
}

