/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import org.eclipse.core.resources.semantic.spi.DefaultSemanticResourceRuleFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;

public abstract class ContentProvider
implements ISemanticContentProvider {
    private static final QualifiedName ATTRIBUTE_URI = new QualifiedName("org.eclipse.core.resources.semantic", "URIString");
    private static final QualifiedName CONTENT_TYPE_KEY = new QualifiedName("org.eclipse.core.resources.semantic", "ContentType");
    private static final QualifiedName ATTRIBUTE_READONLY = new QualifiedName("org.eclipse.core.resources.semantic", "readonly");
    private static final String TRUE = "true";
    private ISemanticFileStore rootStore;

    public final void setRootStore(ISemanticFileStore rootStore) {
        this.rootStore = rootStore;
    }

    public ISemanticFileStore getRootStore() {
        return this.rootStore;
    }

    @Deprecated
    public String getURIStringInternal(ISemanticFileStore childStore) throws CoreException {
        String uriString = childStore.getPersistentProperty(ATTRIBUTE_URI);
        if (uriString == null) {
            uriString = childStore.getRemoteURIString();
        }
        return uriString;
    }

    @Deprecated
    public void setURIStringInternal(ISemanticFileStore childStore, String uriString) throws CoreException {
        childStore.setPersistentProperty(ATTRIBUTE_URI, null);
        childStore.setRemoteURIString(uriString);
    }

    public String getContentTypeInternal(ISemanticFileStore childStore) throws CoreException {
        return childStore.getPersistentProperty(CONTENT_TYPE_KEY);
    }

    public void setContentTypeInternal(ISemanticFileStore childStore, String contentType) throws CoreException {
        childStore.setPersistentProperty(CONTENT_TYPE_KEY, contentType);
    }

    public boolean isReadOnlyInternal(ISemanticFileStore semanticFileStore) throws CoreException {
        return semanticFileStore.getPersistentProperty(ATTRIBUTE_READONLY) != null;
    }

    public void setReadOnlyInternal(ISemanticFileStore childStore, boolean readonly) throws CoreException {
        if (readonly) {
            childStore.setPersistentProperty(ATTRIBUTE_READONLY, TRUE);
        } else {
            childStore.setPersistentProperty(ATTRIBUTE_READONLY, null);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void onImplicitStoreCreate(ISemanticFileStore newStore) {
    }

    public ISemanticResourceRuleFactory getRuleFactory() {
        return new DefaultSemanticResourceRuleFactory(this.rootStore);
    }

    public IStatus validateRemove(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        return new Status(0, "org.eclipse.core.resources.semantic", "");
    }
}

