/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;

public class ComponentLabelProvider
extends StyledCellLabelProvider {
    private Image modelComponentsImage;
    private Image modelComonentImage;
    private Image partsImage;
    private Image menusImage;
    private Image partImage;
    private Image partDescriptorImage;
    private ModelEditor editor;
    private static StyledString.Styler NOT_RENDERED_STYLER = new StyledString.Styler(){
        {
            JFaceResources.getColorRegistry().put("NOT_RENDERED_STYLER", new RGB(200, 200, 200));
        }

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceResources.getColorRegistry().get("NOT_RENDERED_STYLER");
        }
    };

    public ComponentLabelProvider(ModelEditor editor) {
        this.editor = editor;
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof EObject) {
            EObject o = (EObject)cell.getElement();
            AbstractComponentEditor elementEditor = this.editor.getEditor(o.eClass());
            if (elementEditor != null) {
                String label = elementEditor.getLabel(o);
                String detailText = elementEditor.getDetailLabel(o);
                StyledString.Styler styler = null;
                if (o instanceof MUIElement) {
                    if (!((MUIElement)o).isVisible()) {
                        label = String.valueOf(label) + "<invisible>";
                        styler = NOT_RENDERED_STYLER;
                    } else if (!((MUIElement)o).isToBeRendered()) {
                        label = String.valueOf(label) + "<not rendered>";
                        styler = NOT_RENDERED_STYLER;
                    }
                }
                if (detailText == null) {
                    StyledString styledString = new StyledString(label, styler);
                    cell.setText(styledString.getString());
                    cell.setStyleRanges(styledString.getStyleRanges());
                } else {
                    StyledString styledString = new StyledString(label, styler);
                    styledString.append(" - " + detailText, StyledString.DECORATIONS_STYLER);
                    cell.setText(styledString.getString());
                    cell.setStyleRanges(styledString.getStyleRanges());
                }
                cell.setImage(elementEditor.getImage(o, cell.getControl().getDisplay()));
            } else {
                cell.setText(cell.getElement().toString());
            }
        } else if (cell.getElement() instanceof VirtualEntry) {
            String s = cell.getElement().toString();
            cell.setText(s);
        } else {
            cell.setText(cell.getElement().toString());
        }
    }

    public void dispose() {
        if (this.modelComponentsImage != null) {
            this.modelComponentsImage.dispose();
            this.modelComponentsImage = null;
        }
        if (this.modelComonentImage != null) {
            this.modelComonentImage.dispose();
            this.modelComonentImage = null;
        }
        if (this.partsImage != null) {
            this.partsImage.dispose();
            this.partsImage = null;
        }
        if (this.menusImage != null) {
            this.menusImage.dispose();
            this.menusImage = null;
        }
        if (this.partImage != null) {
            this.partImage.dispose();
            this.partImage = null;
        }
        if (this.partDescriptorImage != null) {
            this.partDescriptorImage.dispose();
            this.partDescriptorImage = null;
        }
        super.dispose();
    }
}

