/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenu;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderedMenuRenderer
extends SWTPartRenderer {
    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MRenderedMenu)) {
            return null;
        }
        MRenderedMenu menuModel = (MRenderedMenu)element;
        Object contributionManager = menuModel.getContributionManager();
        if (contributionManager instanceof MenuManager) {
            Menu newMenu = null;
            MenuManager mm = (MenuManager)contributionManager;
            MUIElement container = (MUIElement)((EObject)menuModel).eContainer();
            newMenu = parent instanceof Decorations && container instanceof MWindow ? mm.createMenuBar((Decorations)parent) : mm.createContextMenu((Control)parent);
            mm.update(true);
            return newMenu;
        }
        if (contributionManager instanceof IMenuCreator) {
            IMenuCreator creator = (IMenuCreator)contributionManager;
            if (parent instanceof Control) {
                Control control = (Control)parent;
                return creator.getMenu(control);
            }
            if (parent instanceof Menu) {
                int addIndex = this.calcVisibleIndex((MUIElement)menuModel);
                MenuItem newItem = new MenuItem((Menu)parent, 64, addIndex);
                this.setItemText((MMenu)menuModel, newItem);
                newItem.setImage(this.getImage((MUILabel)menuModel));
                newItem.setEnabled(menuModel.isEnabled());
                Menu menu = (Menu)parent;
                newItem.setMenu(creator.getMenu(menu));
                return newItem;
            }
        }
        return null;
    }

    private void setItemText(MMenu model, MenuItem item) {
        String text = model.getLabel();
        if (text == null) {
            text = "";
        }
        item.setText(text);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    @Override
    public Object unbindWidget(MUIElement me) {
        MRenderedMenu menuModel = (MRenderedMenu)me;
        Object contributionManager = menuModel.getContributionManager();
        if (contributionManager instanceof IMenuManager) {
            ((IMenuManager)contributionManager).dispose();
        }
        return super.unbindWidget(me);
    }

    public Object getUIContainer(MUIElement element) {
        if (!(element instanceof MMenuElement)) {
            return null;
        }
        if (element.getParent().getWidget() instanceof MenuItem) {
            MenuItem mi = (MenuItem)element.getParent().getWidget();
            if (mi.getMenu() == null) {
                mi.setMenu(new Menu(mi));
            }
            return mi.getMenu();
        }
        return super.getUIContainer(element);
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
    }
}

