/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Parameter;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MBindingTableContainer;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class E4CommandProcessor {
    public static void processCategories(IEclipseContext context, List<MCategory> categories) {
        Activator.trace("/trace/commands", "Initialize contexts from model", null);
        ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        for (MCategory category : categories) {
            E4CommandProcessor.createCategory(cs, category);
        }
    }

    public static void processCommands(IEclipseContext context, List<MCommand> commands) {
        Activator.trace("/trace/commands", "Initialize commands from model", null);
        ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        Category undefinedCategory = cs.defineCategory(MApplication.class.getName(), "Application Category", null);
        for (MCommand cmd : commands) {
            E4CommandProcessor.createCommand(cs, undefinedCategory, cmd);
        }
    }

    private static void createCategory(ECommandService cs, MCategory category) {
        if (category.getElementId() != null && category.getName() != null) {
            cs.defineCategory(category.getElementId(), category.getName(), category.getDescription());
        }
    }

    private static void createCommand(ECommandService cs, Category undefinedCategory, MCommand cmd) {
        IParameter[] parms = null;
        String id = cmd.getElementId();
        String name = cmd.getCommandName();
        List modelParms = cmd.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            ArrayList<Parameter> parmList = new ArrayList<Parameter>();
            for (MCommandParameter cmdParm : modelParms) {
                parmList.add(new Parameter(cmdParm.getElementId(), cmdParm.getName(), null, null, cmdParm.isOptional()));
            }
            parms = parmList.toArray(new Parameter[parmList.size()]);
        }
        Category cat = undefinedCategory;
        if (cmd.getCategory() != null) {
            cat = cs.getCategory(cmd.getCategory().getElementId());
        }
        cs.defineCommand(id, name, null, cat, parms);
    }

    public static void watchForCommandChanges(IEclipseContext context) {
        final MApplication application = (MApplication)context.get(MApplication.class);
        final ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        final Category undefinedCategory = cs.getCategory(MApplication.class.getName());
        IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
        EventHandler handler = new EventHandler(){

            public void handleEvent(Event event) {
                if (application == event.getProperty("ChangedElement") && "ADD".equals(event.getProperty("EventType"))) {
                    Object obj = event.getProperty("NewValue");
                    if (obj instanceof MCommand) {
                        E4CommandProcessor.createCommand(cs, undefinedCategory, (MCommand)obj);
                    } else if (obj instanceof MCategory) {
                        E4CommandProcessor.createCategory(cs, (MCategory)obj);
                    }
                }
            }
        };
        broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/application/Application", "commands"), handler);
        broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/application/Application", "categories"), handler);
    }

    public static void processBindings(IEclipseContext context, MBindingTableContainer bindingContainer) {
        Activator.trace("/trace/commands", "Initialize binding tables from model", null);
        BindingTableManager bindingTables = (BindingTableManager)ContextInjectionFactory.make(BindingTableManager.class, (IEclipseContext)context);
        context.set(BindingTableManager.class.getName(), (Object)bindingTables);
        MBindingContext root = bindingContainer.getRootContext();
        if (root == null) {
            return;
        }
        ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
        if (cs == null) {
            Activator.log(4, "cannot run without ECommandService in defineBindingTable");
            return;
        }
        if (bs == null) {
            Activator.log(4, "cannot run without EBindingService in defineBindingTable");
            return;
        }
        ContextManager manager = (ContextManager)context.get(ContextManager.class.getName());
        E4CommandProcessor.defineContexts(null, root, manager);
        for (MBindingTable bt : bindingContainer.getBindingTables()) {
            Context bindingContext = manager.getContext(bt.getBindingContextId());
            BindingTable table = new BindingTable(bindingContext);
            bindingTables.addTable(table);
            List bindings = bt.getBindings();
            for (MKeyBinding binding : bindings) {
                Binding keyBinding = E4CommandProcessor.createBinding(bindingContext, cs, bs, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
                if (keyBinding == null) continue;
                table.addBinding(keyBinding);
            }
        }
    }

    public static void watchForBindingChanges(IEclipseContext context) {
        final ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        final EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
        final ContextManager manager = (ContextManager)context.get(ContextManager.class.getName());
        final BindingTableManager bindingTables = (BindingTableManager)context.get(BindingTableManager.class);
        IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
        EventHandler handler = new EventHandler(){

            public void handleEvent(Event event) {
                Object elementObj = event.getProperty("ChangedElement");
                if (elementObj instanceof MApplication) {
                    Object newObj = event.getProperty("NewValue");
                    if ("ADD".equals(event.getProperty("EventType")) && newObj instanceof MBindingTable) {
                        MBindingTable bt = (MBindingTable)newObj;
                        Context bindingContext = manager.getContext(bt.getBindingContextId());
                        BindingTable table = new BindingTable(bindingContext);
                        bindingTables.addTable(table);
                        List bindings = bt.getBindings();
                        for (MKeyBinding binding : bindings) {
                            Binding keyBinding = E4CommandProcessor.createBinding(bindingContext, cs, bs, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
                            if (keyBinding == null) continue;
                            table.addBinding(keyBinding);
                        }
                    }
                } else if (elementObj instanceof MBindingTable) {
                    Object newObj = event.getProperty("NewValue");
                    Object oldObj = event.getProperty("OldValue");
                    if ("ADD".equals(event.getProperty("EventType")) && newObj instanceof MKeyBinding) {
                        MKeyBinding binding = (MKeyBinding)newObj;
                        E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, binding, true);
                    } else if ("REMOVE".equals(event.getProperty("EventType")) && oldObj instanceof MKeyBinding) {
                        MKeyBinding binding = (MKeyBinding)oldObj;
                        E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, binding, false);
                    }
                } else if (elementObj instanceof MKeyBinding) {
                    MKeyBinding binding = (MKeyBinding)elementObj;
                    String attrName = (String)event.getProperty("AttName");
                    if ("SET".equals(event.getProperty("EventType"))) {
                        Object oldObj = event.getProperty("OldValue");
                        if ("command".equals(attrName)) {
                            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                            oldBinding.setCommand((MCommand)oldObj);
                            E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, oldBinding, false);
                            E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, binding, true);
                        } else if ("keySequence".equals(attrName)) {
                            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                            oldBinding.setKeySequence((String)oldObj);
                            E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, oldBinding, false);
                            E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, binding, true);
                        }
                    } else if ("parameters".equals(attrName)) {
                        if ("ADD".equals(event.getProperty("EventType"))) {
                            Object newObj = event.getProperty("NewValue");
                            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                            oldBinding.getParameters().remove(newObj);
                            E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, oldBinding, false);
                            E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, binding, true);
                        } else if ("REMOVE".equals(event.getProperty("EventType"))) {
                            Object oldObj = event.getProperty("OldValue");
                            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                            oldBinding.getParameters().add((MParameter)oldObj);
                            E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, oldBinding, false);
                            E4CommandProcessor.updateBinding(cs, bs, manager, bindingTables, binding, true);
                        }
                    }
                }
            }
        };
        broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/commands/BindingTableContainer", "bindingTables"), handler);
        broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/commands/BindingTable", "bindings"), handler);
        broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/commands/KeyBinding", "command"), handler);
        broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/commands/KeyBinding", "parameters"), handler);
        broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/commands/KeySequence", "keySequence"), handler);
    }

    private static Binding createBinding(Context bindingContext, ECommandService cs, EBindingService bs, MCommand cmdModel, List<MParameter> modelParms, String keySequence, MKeyBinding binding) {
        if (cmdModel == null) {
            Activator.log(4, "binding with no command: " + binding);
            return null;
        }
        HashMap<String, String> parameters = null;
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = cs.createCommand(cmdModel.getElementId(), parameters);
        TriggerSequence sequence = null;
        try {
            sequence = bs.createSequence(keySequence);
        }
        catch (IllegalArgumentException ex) {
            Activator.trace("/trace/menus", "failed to create: " + binding, ex);
            return null;
        }
        Binding keyBinding = null;
        if (cmd == null || sequence == null) {
            System.err.println("Failed to handle binding: " + binding);
        } else {
            keyBinding = bs.createBinding(sequence, cmd, "org.eclipse.ui.defaultAcceleratorConfiguration", bindingContext.getId());
        }
        return keyBinding;
    }

    private static void defineContexts(MBindingContext parent, MBindingContext current, ContextManager manager) {
        Context context = manager.getContext(current.getElementId());
        if (!context.isDefined()) {
            context.define(current.getName(), current.getDescription(), parent == null ? null : parent.getElementId());
        }
        for (MBindingContext child : current.getChildren()) {
            E4CommandProcessor.defineContexts(current, child, manager);
        }
    }

    static void updateBinding(ECommandService cs, EBindingService bs, ContextManager manager, BindingTableManager bindingTables, MKeyBinding binding, boolean add) {
        EObject parentObj = ((EObject)binding).eContainer();
        if (!(parentObj instanceof MBindingTable)) {
            return;
        }
        MBindingTable bt = (MBindingTable)parentObj;
        Context bindingContext = manager.getContext(bt.getBindingContextId());
        BindingTable table = bindingTables.getTable(bindingContext.getId());
        if (table == null) {
            Activator.log(4, "Trying to create '" + binding + "' without binding table " + bindingContext.getId());
            return;
        }
        Binding keyBinding = E4CommandProcessor.createBinding(bindingContext, cs, bs, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
        if (keyBinding != null) {
            if (add) {
                table.addBinding(keyBinding);
            } else {
                table.removeBinding(keyBinding);
            }
        }
    }
}

