/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class SemanticResourcePropertyPage
extends PropertyPage {
    protected Control createContents(Composite parent) {
        Tree propsTree = new Tree(parent, 0);
        TreeColumn key = new TreeColumn(propsTree, 0);
        key.setWidth(220);
        key.setText(Messages.SemanticResourcePropertyPage_Key_XGRP);
        TreeColumn value = new TreeColumn(propsTree, 0);
        value.setWidth(300);
        value.setText(Messages.SemanticResourcePropertyPage_Value_XGRP);
        ISemanticResource node = (ISemanticResource)this.getElement().getAdapter(ISemanticResource.class);
        IProject project = node.getAdaptedResource().getProject();
        TreeItem infoRoot = new TreeItem(propsTree, 0);
        try {
            infoRoot.setText(0, Messages.SemanticResourcePropertyPage_SFSAttr_XFLD);
            ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)node.getAdaptedResource().getLocationURI());
            TreeItem childItem = new TreeItem(infoRoot, 0);
            childItem.setText(new String[]{Messages.SemanticResourcePropertyPage_EffContentProv_XFLD, sfs.getEffectiveContentProvider().getClass().getName()});
        }
        catch (Exception exception) {
            infoRoot.setText(1, Messages.SemanticResourcePropertyPage_Exception_XMSG);
        }
        this.addResourceInfo(node, propsTree);
        if (!(node instanceof ISemanticProject)) {
            IPath path;
            TreeItem it;
            if (node instanceof ISemanticFolder) {
                TreeItem folderRoot = new TreeItem(propsTree, 0);
                folderRoot.setText(0, Messages.SemanticResourcePropertyPage_SFolderAttr_XFLD);
                it = new TreeItem(folderRoot, 0);
                it.setText(new String[]{Messages.SemanticResourcePropertyPage_Project_XFLD, project.getName()});
                path = node.getAdaptedResource().getProjectRelativePath();
                it = new TreeItem(folderRoot, 0);
                it.setText(new String[]{Messages.SemanticResourcePropertyPage_Path_XFLD, path.toPortableString()});
                ISemanticFolder folder = (ISemanticFolder)node;
                it = new TreeItem(folderRoot, 0);
                try {
                    it.setText(new String[]{Messages.SemanticResourcePropertyPage_ContentProviderId_XFLD, folder.getContentProviderID()});
                }
                catch (CoreException coreException) {
                    it.setText(new String[]{Messages.SemanticResourcePropertyPage_ContentProviderId_XFLD, Messages.SemanticResourcePropertyPage_Exception_XMSG});
                }
            } else if (node instanceof ISemanticFile) {
                TreeItem fileRoot = new TreeItem(propsTree, 0);
                fileRoot.setText(0, Messages.SemanticResourcePropertyPage_SFileAttributes_XFLD);
                it = new TreeItem(fileRoot, 0);
                it.setText(new String[]{Messages.SemanticResourcePropertyPage_Project_XFLD, project.getName()});
                path = node.getAdaptedResource().getProjectRelativePath();
                it = new TreeItem(fileRoot, 0);
                it.setText(new String[]{Messages.SemanticResourcePropertyPage_Path_XFLD, path.toPortableString()});
            }
        }
        propsTree.setLinesVisible(true);
        propsTree.setHeaderVisible(true);
        TreeItem[] treeItemArray = propsTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setExpanded(true);
            ++n2;
        }
        return propsTree;
    }

    private void addResourceInfo(ISemanticResource resource, Tree propsTable) {
        Map transientAtts;
        TreeItem childItem;
        Map persistent;
        TreeItem infoRoot = new TreeItem(propsTable, 0);
        try {
            infoRoot.setText(0, Messages.SemanticResourcePropertyPage_SRInfo_XFLD);
            int options = 26;
            ISemanticResourceInfo info = resource.fetchResourceInfo(options, null);
            TreeItem childItem2 = new TreeItem(infoRoot, 0);
            childItem2.setText(new String[]{Messages.SemanticResourcePropertyPage_ReadOnly_XFLD, "" + info.isReadOnly()});
            if (resource instanceof ISemanticFile) {
                childItem2 = new TreeItem(infoRoot, 0);
                childItem2.setText(new String[]{Messages.SemanticResourcePropertyPage_LocalOnly_XFLD, "" + info.isLocalOnly()});
            }
            childItem2 = new TreeItem(infoRoot, 0);
            childItem2.setText(new String[]{Messages.SemanticResourcePropertyPage_Locked_XFLD, "" + info.isLocked()});
            infoRoot.setExpanded(true);
        }
        catch (Exception exception) {
            infoRoot.setText(1, Messages.SemanticResourcePropertyPage_Exception_XMSG);
        }
        TreeItem storeRoot = new TreeItem(propsTable, 0);
        storeRoot.setText(0, Messages.SemanticResourcePropertyPage_SemResAttr_XFLD);
        try {
            TreeItem childItem3 = new TreeItem(storeRoot, 0);
            String typeText = null;
            if (resource instanceof ISemanticFile) {
                typeText = Messages.SemanticResourcePropertyPage_File_XFLD;
            }
            if (resource instanceof ISemanticFolder) {
                typeText = Messages.SemanticResourcePropertyPage_Folder_XFLD;
            }
            if (resource instanceof ISemanticProject) {
                typeText = Messages.SemanticResourcePropertyPage_Project_XFLD;
            }
            if (typeText == null) {
                typeText = "";
            }
            childItem3.setText(new String[]{Messages.SemanticResourcePropertyPage_Type_XFLD, typeText});
        }
        catch (Exception exception) {
            storeRoot.setText(1, Messages.SemanticResourcePropertyPage_Exception_XMSG);
            return;
        }
        TreeItem persistentRoot = new TreeItem(storeRoot, 0);
        persistentRoot.setText(0, Messages.SemanticResourcePropertyPage_PersistentProps_XFLD);
        try {
            persistent = resource.getPersistentProperties();
        }
        catch (CoreException coreException) {
            persistentRoot.setText(1, Messages.SemanticResourcePropertyPage_Exception_XMSG);
            persistent = null;
        }
        if (persistent != null) {
            if (!persistent.isEmpty()) {
                for (Map.Entry entry : persistent.entrySet()) {
                    childItem = new TreeItem(persistentRoot, 0);
                    childItem.setText(new String[]{((QualifiedName)entry.getKey()).toString(), (String)entry.getValue()});
                }
                persistentRoot.setExpanded(true);
            } else {
                persistentRoot.setText(1, Messages.SemanticResourcePropertyPage_NoEntries_XMSG);
            }
        }
        TreeItem transientRoot = new TreeItem(storeRoot, 0);
        transientRoot.setText(0, Messages.SemanticResourcePropertyPage_SessionProp_XFLD);
        try {
            transientAtts = resource.getSessionProperties();
        }
        catch (CoreException coreException) {
            transientRoot.setText(1, Messages.SemanticResourcePropertyPage_Exception_XMSG);
            transientAtts = null;
        }
        if (transientAtts != null) {
            if (!transientAtts.isEmpty()) {
                for (Map.Entry entry : transientAtts.entrySet()) {
                    childItem = new TreeItem(transientRoot, 0);
                    childItem.setText(new String[]{((QualifiedName)entry.getKey()).toString(), String.valueOf(entry.getValue())});
                }
                transientRoot.setExpanded(true);
            } else {
                transientRoot.setText(1, Messages.SemanticResourcePropertyPage_NoEntries_XMSG);
            }
        }
    }
}

