/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.pde.internal.webui;

import java.util.Hashtable;
import javax.servlet.Servlet;
import org.eclipse.e4.pde.internal.webui.BundleEntryHttpContext;
import org.eclipse.e4.pde.internal.webui.PDEServlet;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private ServiceTracker httpServiceTracker;
    protected static volatile BundleContext bundleContext;
    static boolean DEBUG;
    public static Object PORT;

    public Activator() {
        String debug = System.getProperty("org.eclipse.e4.pde.webui.debug");
        if (debug != null && !"false".equals(debug.toLowerCase())) {
            DEBUG = true;
        }
    }

    public void start(BundleContext context) throws Exception {
        Hashtable<String, Object> settings = new Hashtable<String, Object>();
        if (DEBUG) {
            settings.put("http.host", "127.0.0.1");
        } else {
            settings.put("http.host", "0.0.0.0");
        }
        settings.put("http.port", 0);
        settings.put("other.info", "e4.pde.webui");
        JettyConfigurator.startServer((String)"e4.pde.webui", settings);
        bundleContext = context;
        Filter filter = context.createFilter("(&(objectClass=" + HttpService.class.getName() + ")(other.info=e4.pde.webui))");
        this.httpServiceTracker = new HttpServiceTracker(context, filter);
        this.httpServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.httpServiceTracker.close();
        this.httpServiceTracker = null;
        bundleContext = null;
        JettyConfigurator.stopServer((String)"e4.pde.webui");
    }

    private class HttpServiceTracker
    extends ServiceTracker {
        public HttpServiceTracker(BundleContext context, Filter filter) {
            super(context, filter, null);
        }

        public Object addingService(ServiceReference reference) {
            HttpService httpService = (HttpService)super.addingService(reference);
            PORT = reference.getProperty("http.port");
            if (DEBUG) {
                System.out.println("listening on: " + PORT);
            }
            if (httpService == null) {
                return null;
            }
            BundleEntryHttpContext httpContext = new BundleEntryHttpContext(this.context.getBundle());
            Bundle dojoBundle = this.getDojoBundle();
            BundleEntryHttpContext dojoHttpContext = new BundleEntryHttpContext(dojoBundle);
            try {
                httpService.registerResources("/org.dojotoolkit", "/", (HttpContext)dojoHttpContext);
                httpService.registerResources("/", "/static", (HttpContext)httpContext);
                httpService.registerServlet("/pde", (Servlet)new PDEServlet(), null, (HttpContext)httpContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return httpService;
        }

        private Bundle getDojoBundle() {
            Bundle[] bundles = this.context.getBundles();
            int i = 0;
            while (i < bundles.length) {
                if (bundles[i].getSymbolicName().equals("org.dojotoolkit")) {
                    return bundles[i];
                }
                ++i;
            }
            throw new IllegalStateException("Couldn't find the 'org.dojotoolkit' bundle.");
        }

        public void removedService(ServiceReference reference, Object service) {
            HttpService httpService = (HttpService)service;
            httpService.unregister("/org.dojotoolkit");
            httpService.unregister("/");
            super.removedService(reference, service);
        }
    }
}

