/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.internal.workbench.ModelAssembler;
import org.eclipse.e4.ui.internal.workbench.ModelReconcilingService;
import org.eclipse.e4.ui.internal.workbench.XMLModelReconciler;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.workbench.IModelResourceHandler;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class ResourceHandler
implements IModelResourceHandler {
    private File workbenchData;
    private ResourceSetImpl resourceSetImpl;
    private URI restoreLocation;
    private Resource resource;
    private ModelReconciler reconciler;
    @Inject
    private Logger logger;
    @Inject
    private IEclipseContext context;
    @Inject
    @Named(value="initialWorkbenchModelURI")
    private URI applicationDefinitionInstance;
    @Inject
    @Named(value="instanceLocation")
    private Location instanceLocation;
    private boolean saveAndRestore;
    private boolean clearPersistedState;
    private boolean deltaRestore = true;

    @Inject
    public ResourceHandler(@Named(value="persistState") boolean saveAndRestore, @Named(value="clearPersistedState") boolean clearPersistedState, @Named(value="deltaRestore") boolean deltaRestore) {
        this.saveAndRestore = saveAndRestore;
        this.clearPersistedState = clearPersistedState;
        this.deltaRestore = deltaRestore;
    }

    @PostConstruct
    void init() {
        this.resourceSetImpl = new ResourceSetImpl();
        this.resourceSetImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new E4XMIResourceFactory());
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application", (Object)ApplicationPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/commands", (Object)CommandsPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui", (Object)UiPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/menu", (Object)MenuPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/basic", (Object)org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/ui/advanced", (Object)AdvancedPackageImpl.eINSTANCE);
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2010/UIModel/application/descriptor/basic", (Object)BasicPackageImpl.eINSTANCE);
        try {
            this.workbenchData = new File(URIUtil.toURI((URL)this.instanceLocation.getURL()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.workbenchData = new File(this.workbenchData, ".metadata");
        this.workbenchData = new File(this.workbenchData, ".plugins");
        this.workbenchData = new File(this.workbenchData, "org.eclipse.e4.workbench");
        this.workbenchData = this.deltaRestore ? new File(this.workbenchData, "deltas.xml") : new File(this.workbenchData, "workbench.xmi");
        if (this.workbenchData != null && this.clearPersistedState && this.workbenchData.exists()) {
            this.workbenchData.delete();
        }
        if (this.workbenchData != null && this.saveAndRestore) {
            this.restoreLocation = URI.createFileURI((String)this.workbenchData.getAbsolutePath());
        }
    }

    public long getLastStoreDatetime() {
        long restoreLastModified = this.restoreLocation == null ? 0L : new File(this.restoreLocation.toFileString()).lastModified();
        return restoreLastModified;
    }

    public Resource loadRestoredModel() {
        Activator.trace("/trace/workbench", "Restoring workbench: " + this.restoreLocation, null);
        this.resource = this.loadResource(this.restoreLocation);
        return this.resource;
    }

    public Resource loadBaseModel() {
        Activator.trace("/trace/workbench", "Initializing workbench: " + this.applicationDefinitionInstance, null);
        if (this.deltaRestore) {
            this.resource = this.loadResource(this.applicationDefinitionInstance);
        } else {
            this.resource = new E4XMIResource();
            MApplication theApp = this.loadDefaultModel(this.applicationDefinitionInstance);
            this.resource.getContents().add((Object)((EObject)theApp));
            this.resource.setURI(this.restoreLocation);
        }
        return this.resource;
    }

    private MApplication loadDefaultModel(URI defaultModelPath) {
        Resource resource = this.loadResource(defaultModelPath);
        MApplication app = (MApplication)resource.getContents().get(0);
        return app;
    }

    private Resource loadResource(URI uri) {
        Resource resource;
        try {
            resource = this.resourceSetImpl.getResource(uri, true);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            resource = this.resourceSetImpl.getResource(uri, false);
        }
        return resource;
    }

    public void save() throws IOException {
        if (this.deltaRestore && this.reconciler != null) {
            try {
                Document document = (Document)this.reconciler.serialize();
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                DOMSource source = new DOMSource(document);
                File f = new File(this.restoreLocation.toFileString());
                f.getParentFile().mkdirs();
                StreamResult result = new StreamResult(f);
                transformer.transform(source, result);
            }
            catch (Exception e) {
                if (this.logger != null) {
                    this.logger.error((Throwable)e);
                }
            }
        } else {
            this.resource.save(null);
        }
    }

    public Resource loadMostRecentModel() {
        long lastApplicationModification;
        if (this.deltaRestore) {
            block4: {
                try {
                    Resource resource = this.loadBaseModel();
                    MApplication appElement = (MApplication)resource.getContents().get(0);
                    this.context.set(MApplication.class, (Object)appElement);
                    ModelAssembler contribProcessor = (ModelAssembler)ContextInjectionFactory.make(ModelAssembler.class, (IEclipseContext)this.context);
                    contribProcessor.processModel();
                    File file = new File(this.restoreLocation.toFileString());
                    this.reconciler = new XMLModelReconciler();
                    this.reconciler.recordChanges(appElement);
                    if (file.exists()) {
                        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                        ModelReconcilingService modelReconcilingService = new ModelReconcilingService();
                        ModelReconciler modelReconciler = modelReconcilingService.createModelReconciler();
                        document.normalizeDocument();
                        Collection<ModelDelta> deltas = modelReconciler.constructDeltas(resource.getContents().get(0), document);
                        modelReconcilingService.applyDeltas(deltas);
                    }
                }
                catch (Exception e) {
                    if (this.logger == null) break block4;
                    this.logger.error((Throwable)e);
                }
            }
            return this.resource;
        }
        long restoreLastModified = this.getLastStoreDatetime();
        boolean restore = restoreLastModified > (lastApplicationModification = this.getLastApplicationModification());
        Resource resource = restore ? this.loadRestoredModel() : this.loadBaseModel();
        MApplication appElement = (MApplication)resource.getContents().get(0);
        this.context.set(MApplication.class, (Object)appElement);
        ModelAssembler contribProcessor = (ModelAssembler)ContextInjectionFactory.make(ModelAssembler.class, (IEclipseContext)this.context);
        contribProcessor.processModel();
        return resource;
    }

    public long getLastApplicationModification() {
        long appLastModified = 0L;
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Map attributes = resourceSetImpl.getURIConverter().getAttributes(this.applicationDefinitionInstance, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")));
        Object timestamp = attributes.get("timeStamp");
        if (timestamp instanceof Long) {
            appLastModified = (Long)timestamp;
        } else if (this.applicationDefinitionInstance.isPlatformPlugin()) {
            try {
                URL url = new URL(this.applicationDefinitionInstance.toString());
                Object[] obj = PlatformURLPluginConnection.parse((String)url.getFile().trim(), (URL)url);
                Bundle b = (Bundle)obj[0];
                URLConnection openConnection = b.getResource((String)obj[1]).openConnection();
                appLastModified = openConnection.getLastModified();
            }
            catch (Exception exception) {}
        }
        return appLastModified;
    }
}

