/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.annotations.GroupUpdates;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.InjectorImpl;

public abstract class Requestor
implements IRequestor {
    private final WeakReference<Object> objectRef;
    private final boolean track;
    private final boolean groupUpdates;
    private final boolean isOptional;
    private final IInjector injector;
    private final PrimaryObjectSupplier primarySupplier;
    private PrimaryObjectSupplier tempSupplier;
    protected Object[] actualArgs;
    private IObjectDescriptor[] objectDescriptors;

    protected abstract IObjectDescriptor[] calcDependentObjects();

    public Requestor(AccessibleObject reflectionObject, IInjector injector, PrimaryObjectSupplier primarySupplier, PrimaryObjectSupplier tempSupplier, Object requestingObject, boolean track) {
        this.injector = injector;
        this.primarySupplier = primarySupplier;
        this.tempSupplier = tempSupplier;
        this.objectRef = requestingObject != null ? new WeakReference<Object>(requestingObject) : null;
        this.track = track;
        this.groupUpdates = reflectionObject == null ? false : reflectionObject.isAnnotationPresent(GroupUpdates.class);
        this.isOptional = reflectionObject == null ? false : reflectionObject.isAnnotationPresent(Optional.class);
    }

    public IInjector getInjector() {
        return this.injector;
    }

    public PrimaryObjectSupplier getPrimarySupplier() {
        return this.primarySupplier;
    }

    public PrimaryObjectSupplier getTempSupplier() {
        return this.tempSupplier;
    }

    public void clearTempSupplier() {
        this.tempSupplier = null;
    }

    public Object getRequestingObject() {
        if (this.objectRef == null) {
            return null;
        }
        return this.objectRef.get();
    }

    public boolean shouldTrack() {
        return this.track;
    }

    public boolean shouldGroupUpdates() {
        return this.groupUpdates;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isResolved() {
        return this.actualArgs != null;
    }

    public void setResolvedArgs(Object[] actualArgs) {
        this.actualArgs = actualArgs;
    }

    public boolean isValid() {
        return this.getRequestingObject() != null;
    }

    public void resolveArguments() {
        ((InjectorImpl)this.injector).resolveArguments(this);
    }

    public void disposed(PrimaryObjectSupplier objectSupplier) {
        ((InjectorImpl)this.injector).disposed(objectSupplier);
    }

    public boolean uninject(Object object, PrimaryObjectSupplier objectSupplier) {
        Object originatingObject = this.getRequestingObject();
        if (originatingObject == null) {
            return false;
        }
        if (originatingObject != object) {
            return true;
        }
        this.injector.uninject(object, objectSupplier);
        return false;
    }

    public IObjectDescriptor[] getDependentObjects() {
        if (this.objectDescriptors == null) {
            this.objectDescriptors = this.calcDependentObjects();
        }
        return this.objectDescriptors;
    }
}

