/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui;

import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.e4.tm.ui.AbstractTmSelectionView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ScriptSourceView
extends AbstractTmSelectionView {
    private Text scriptTextControl;

    public void dispose() {
        this.disposeTextControl(this.scriptTextControl);
        super.dispose();
    }

    protected void selectionChanged(ISelection selection) {
        this.commitScriptText();
        String scriptText = null;
        super.selectionChanged(selection);
        if (this.getSelectedEObject() != null) {
            scriptText = this.getScriptText();
        }
        this.setScriptControlText(scriptText);
    }

    private String getScriptControlText() {
        return this.scriptTextControl.getText();
    }

    private void setScriptControlText(String scriptText) {
        this.scriptTextControl.setText(scriptText != null ? scriptText : "");
    }

    protected boolean isValidSelection(Object o) {
        return o instanceof EObject;
    }

    private String getScriptText() {
        Object value;
        EAttribute scriptAttr = JavascriptSupport.getScriptSourceAttribute((EObject)this.getSelectedEObject(), (String)"js");
        if (scriptAttr != null && (value = this.getSelectedEObject().eGet((EStructuralFeature)scriptAttr)) != null) {
            return value.toString().trim();
        }
        return "";
    }

    private EObject getSelectedEObject() {
        return (EObject)this.selection;
    }

    private void commitScriptText() {
        EAttribute scriptAttr;
        if (this.editingDomainProvider != null && this.selection != null && (scriptAttr = JavascriptSupport.getScriptSourceAttribute((EObject)this.getSelectedEObject(), (String)"js")) != null) {
            SetCommand command;
            EditingDomain editingDomain = this.editingDomainProvider.getEditingDomain();
            String scriptText = this.getScriptControlText();
            if (!scriptText.equals(this.getScriptText()) && (command = new SetCommand(editingDomain, this.getSelectedEObject(), (EStructuralFeature)scriptAttr, (Object)this.scriptTextControl.getText().trim())).canExecute()) {
                editingDomain.getCommandStack().execute((Command)command);
            }
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.scriptTextControl = this.createTextControl(parent, 578);
        this.scriptTextControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ScriptSourceView.this.commitScriptText();
            }
        });
    }

    public void setFocus() {
        this.scriptTextControl.setFocus();
    }
}

