/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.snippet019.array;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class Bean {
    PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    static Bean[] EMPTY = new Bean[0];
    private String text;
    private Bean[] list;

    public Bean(String text) {
        this.text = text;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
        this.changeSupport.firePropertyChange("text", this.text, this.text);
    }

    public Bean[] getList() {
        if (this.list == null) {
            return EMPTY;
        }
        return this.list;
    }

    public void setList(Bean[] list) {
        if (list != null) {
            list = this.copy(list);
        }
        this.list = list;
        this.changeSupport.firePropertyChange("list", this.list, list);
    }

    protected Bean[] copy(Bean[] beans) {
        Bean[] copy = new Bean[beans.length];
        System.arraycopy(beans, 0, copy, 0, beans.length);
        return copy;
    }

    public boolean hasListeners(String propertyName) {
        return this.changeSupport.hasListeners(propertyName);
    }
}

