/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.e4.xwt.internal.xml.Attribute;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;
import org.eclipse.e4.xwt.internal.xml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentObjectSorter {
    public static List<DocumentObject> sortWithAttr(DocumentObject[] sourceArray, String attrName) {
        return DocumentObjectSorter.sortWithAttr(sourceArray, new AttrComparator(attrName), attrName);
    }

    public static List<DocumentObject> sortWithAttr(DocumentObject[] sourceArray, Comparator<Element> comparator, String attrName) {
        Object columnElement;
        LinkedList<DocumentObject> columnsList = new LinkedList<DocumentObject>();
        DocumentObject[] documentObjectArray = sourceArray;
        int n = sourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentObject column = documentObjectArray[n2];
            columnElement = (Element)column;
            Attribute indexAttr = ((Element)columnElement).getAttribute(attrName);
            if (indexAttr == null) {
                columnsList.add(column);
            }
            ++n2;
        }
        LinkedList<Element> tempList = new LinkedList<Element>();
        columnElement = sourceArray;
        int n3 = sourceArray.length;
        n = 0;
        while (n < n3) {
            Object column = columnElement[n];
            Element columnElement2 = (Element)column;
            Attribute indexAttr = columnElement2.getAttribute(attrName);
            if (indexAttr != null) {
                tempList.add(columnElement2);
            }
            ++n;
        }
        if (comparator == null) {
            comparator = new AttrComparator(attrName);
        }
        Collections.sort(tempList, comparator);
        for (Element columnElement3 : tempList) {
            Attribute indexAttr = columnElement3.getAttribute(attrName);
            try {
                int index = Integer.parseInt(indexAttr.getContent());
                columnsList.add(index, columnElement3);
            }
            catch (Exception exception) {
                columnsList.add(columnsList.size(), columnElement3);
            }
        }
        return columnsList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttrComparator
    implements Comparator<Element>,
    Serializable {
        private String attrName;

        public AttrComparator(String attrName) {
            this.attrName = attrName;
        }

        @Override
        public int compare(Element e1, Element e2) {
            Attribute attr1 = e1.getAttribute(this.attrName);
            Attribute attr2 = e2.getAttribute(this.attrName);
            String compare1 = attr1.getContent();
            String compare2 = attr2.getContent();
            if (compare1 == null || compare2 == null) {
                return 0;
            }
            try {
                int index1 = Integer.parseInt(compare1);
                int index2 = Integer.parseInt(compare2);
                return index1 > index2 ? 1 : -1;
            }
            catch (Exception exception) {
                return compare1.compareTo(compare2);
            }
        }
    }
}

