/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.webdav;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.eclipse.core.resources.semantic.examples.webdav.InputStreamWrapper;
import org.eclipse.core.resources.semantic.examples.webdav.MultistatusType;
import org.eclipse.core.resources.semantic.examples.webdav.PropType;
import org.eclipse.core.resources.semantic.examples.webdav.PropfindResponseReader;
import org.eclipse.core.resources.semantic.examples.webdav.PropstatType;
import org.eclipse.core.resources.semantic.examples.webdav.ResponseType;
import org.eclipse.core.resources.semantic.examples.webdav.UserCredentialsDialog;
import org.eclipse.core.resources.semantic.examples.webdav.WebDAVResourceNotFoundException;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;

public class WebDAVUtil {
    private static final String LOCK_TOKEN_HEADER = "Lock-Token";
    private static final String UTF_8 = "UTF-8";
    private static final String propfindRequestXML = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><DAV:propfind xmlns:DAV=\"DAV:\"><DAV:prop><DAV:displayname/><DAV:getcontenttype/><DAV:getlastmodified/><DAV:resourcetype/><DAV:getetag/><DAV:supportedlock/><DAV:lockdiscovery/></DAV:prop></DAV:propfind>";
    private static final byte[] buffer = new byte[8192];
    private static HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());

    public static void setGlobalCredentialsForTest(String userName, String password) {
        if (userName != null && password != null) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(userName, password);
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            httpClient.getParams().setAuthenticationPreemptive(true);
        } else {
            httpClient.getState().clearCredentials();
            httpClient.getParams().setAuthenticationPreemptive(false);
        }
    }

    public static void sendData(String remoteURI, final InputStreamProvider data, final IProgressMonitor monitor) throws IOException {
        PutMethod putMethod = new PutMethod(remoteURI);
        try {
            WebDAVUtil.installCredentialsProvider((HttpMethodBase)putMethod);
            RequestEntity requestEntity = new RequestEntity(){

                public void writeRequest(OutputStream out) throws IOException {
                    WebDAVUtil.transferStreams(data.getInputStream(), out, monitor);
                }

                public boolean isRepeatable() {
                    return true;
                }

                public String getContentType() {
                    return null;
                }

                public long getContentLength() {
                    return -1L;
                }
            };
            putMethod.setRequestEntity(requestEntity);
            int statusCode = httpClient.executeMethod((HttpMethod)putMethod);
            if (statusCode < 200 || statusCode > 205) {
                throw new IOException(putMethod.getStatusText());
            }
        }
        finally {
            putMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transferStreams(InputStream source, OutputStream destination, IProgressMonitor monitor) throws IOException {
        IProgressMonitor actMonitor = Util.monitorFor((IProgressMonitor)monitor);
        try {
            byte[] byArray = buffer;
            synchronized (buffer) {
                while (true) {
                    int bytesRead = -1;
                    bytesRead = source.read(buffer);
                    if (bytesRead == -1) break;
                    destination.write(buffer, 0, bytesRead);
                    actMonitor.worked(1);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        finally {
            Util.safeClose((InputStream)source);
        }
        {
            return;
        }
    }

    public static InputStream openInputStream(String remoteURI, IWebDAVCallback setter) throws IOException {
        InputStream is;
        GetMethod getMethod = new GetMethod(remoteURI);
        getMethod.setFollowRedirects(true);
        WebDAVUtil.installCredentialsProvider((HttpMethodBase)getMethod);
        boolean releaseConnectionOnException = true;
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                throw new IOException(getMethod.getStatusText());
            }
            if (setter != null) {
                Header eTagHeader;
                Header timestampHeader = getMethod.getResponseHeader("Last-Modified");
                if (timestampHeader != null) {
                    String timestampString = timestampHeader.getValue();
                    try {
                        setter.setTimestamp(WebDAVUtil.parseDateTime(timestampString));
                    }
                    catch (ParseException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                Header dateHeader = getMethod.getResponseHeader("Date");
                if (dateHeader != null) {
                    String dateString = dateHeader.getValue();
                    try {
                        setter.setTimestamp(WebDAVUtil.parseDateTime(dateString));
                    }
                    catch (ParseException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                Header contentTypeHeader = getMethod.getResponseHeader("Content-Type");
                if (contentTypeHeader != null) {
                    setter.setContentType(contentTypeHeader.getValue());
                }
                if ((eTagHeader = getMethod.getResponseHeader("ETag")) != null) {
                    setter.setETag(eTagHeader.getValue());
                }
            }
            is = getMethod.getResponseBodyAsStream();
            releaseConnectionOnException = false;
        }
        finally {
            if (releaseConnectionOnException) {
                getMethod.releaseConnection();
            }
        }
        return new InputStreamWrapper((HttpMethod)getMethod, is);
    }

    public static WebDAVNode retrieveRemoteState(URI rootURI, IProgressMonitor monitor) throws IOException {
        MultistatusType multistatus = WebDAVUtil.executePropfindRequest(rootURI.toString(), monitor);
        return WebDAVUtil.convertResponseToNodeTree(rootURI, multistatus, monitor);
    }

    public static MultistatusType executePropfindRequest(String uriString, IProgressMonitor monitor) throws IOException {
        PropfindMethod propfindMethod = new PropfindMethod(uriString);
        propfindMethod.setRequestEntity(new RequestEntity(){

            public void writeRequest(OutputStream out) throws IOException {
                out.write(WebDAVUtil.propfindRequestXML.getBytes(WebDAVUtil.UTF_8));
            }

            public boolean isRepeatable() {
                return true;
            }

            public String getContentType() {
                return "text/xml; charset=\"utf-8\"";
            }

            public long getContentLength() {
                try {
                    return WebDAVUtil.propfindRequestXML.getBytes(WebDAVUtil.UTF_8).length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return -1L;
                }
            }
        });
        WebDAVUtil.installCredentialsProvider((HttpMethodBase)propfindMethod);
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)propfindMethod);
            monitor.worked(1);
            if (statusCode == 404) {
                throw new WebDAVResourceNotFoundException(propfindMethod.getStatusLine().toString());
            }
            if (statusCode != 200 && statusCode != 207) {
                throw new IOException(propfindMethod.getStatusLine().toString());
            }
            MultistatusType multistatusType = new PropfindResponseReader().loadMultitatusTypeFromResponse(propfindMethod.getResponseBodyAsStream(), monitor);
            return multistatusType;
        }
        finally {
            propfindMethod.releaseConnection();
        }
    }

    public static void installCredentialsProvider(HttpMethodBase httpMethod) {
        HttpMethodParams params = new HttpMethodParams();
        params.setParameter("http.authentication.credential-provider", (Object)new CredentialsProvider(){

            public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
                class UIOperation
                implements Runnable {
                    public Credentials credentials;
                    private final /* synthetic */ AuthScheme val$scheme;
                    private final /* synthetic */ String val$host;
                    private final /* synthetic */ int val$port;

                    UIOperation(AuthScheme authScheme, String string, int n) {
                        this.val$scheme = authScheme;
                        this.val$host = string;
                        this.val$port = n;
                    }

                    public void run() {
                        String message = "";
                        if (this.val$scheme.getRealm() != null) {
                            message = this.val$scheme.getRealm();
                        }
                        this.credentials = UserCredentialsDialog.askForCredentials(String.valueOf(this.val$host) + ":" + this.val$port, message);
                    }
                }
                UIOperation uio = new UIOperation(scheme, host, port);
                if (Display.getCurrent() != null) {
                    uio.run();
                } else {
                    Display.getDefault().syncExec((Runnable)uio);
                }
                if (uio.credentials != null) {
                    return uio.credentials;
                }
                throw new CredentialsNotAvailableException();
            }
        });
        httpMethod.setParams(params);
    }

    public static IPath calculateRelativePath(URI rootURI, String href) throws URISyntaxException {
        String relativePath;
        URI webdavResourceURI = new URI(href);
        if (webdavResourceURI.isAbsolute()) {
            URI relativeURI = rootURI.relativize(webdavResourceURI);
            relativePath = relativeURI.toString();
        } else {
            String rootPath = rootURI.getPath();
            if (href.startsWith(rootPath)) {
                relativePath = href.substring(rootPath.length());
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
            } else {
                throw new URISyntaxException(href, "in not prefixed by root path");
            }
        }
        return new Path(relativePath);
    }

    public static WebDAVNode convertResponseToNodeTree(URI rootURI, MultistatusType multistatus, IProgressMonitor monitor) throws IOException {
        HashMap<IPath, WebDAVNode> nodes = new HashMap<IPath, WebDAVNode>();
        WebDAVNode rootNode = null;
        for (ResponseType response : multistatus.getResponse()) {
            try {
                WebDAVNode node = new WebDAVNode();
                node.path = WebDAVUtil.calculateRelativePath(rootURI, response.getHref());
                nodes.put(node.path, node);
                for (PropstatType propstat : response.getPropstat()) {
                    if (!propstat.getStatus().contains("200")) continue;
                    PropType prop = propstat.getProp();
                    if (prop.getLastmodified() != null) {
                        try {
                            node.lastModified = WebDAVUtil.parseDateTime(prop.getLastmodified());
                        }
                        catch (ParseException e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                    node.contentType = prop.getContentType();
                    node.isFolder = prop.getIsFolder();
                    node.etag = prop.getETag();
                    node.supportsLocking = prop.getSupportsLocking();
                    node.lockToken = prop.getLockToken();
                }
            }
            catch (URISyntaxException e) {
                throw new IOException(e.getMessage());
            }
        }
        for (WebDAVNode node : nodes.values()) {
            if (node.path.segmentCount() == 0) {
                rootNode = node;
                continue;
            }
            IPath parentPath = node.path.removeLastSegments(1);
            WebDAVNode parent = (WebDAVNode)nodes.get(parentPath);
            if (parent == null) continue;
            parent.children.add(node);
        }
        return rootNode;
    }

    private static long parseDateTime(String lastmodified) throws ParseException {
        NumberFormat nf = NumberFormat.getIntegerInstance(Locale.ENGLISH);
        lastmodified = lastmodified.substring(5);
        String[] parts = lastmodified.split(" ");
        int year = nf.parse(parts[2]).intValue();
        int month = WebDAVUtil.decodeMonths(parts[1]);
        int date = nf.parse(parts[0]).intValue();
        String[] timeparts = parts[3].split(":");
        int hourOfDay = nf.parse(timeparts[0]).intValue();
        int minute = nf.parse(timeparts[1]).intValue();
        int second = nf.parse(timeparts[2]).intValue();
        GregorianCalendar cal = new GregorianCalendar(year, month, date, hourOfDay, minute, second);
        return cal.getTimeInMillis();
    }

    private static int decodeMonths(String string) {
        if (string.equals("Jan")) {
            return 1;
        }
        if (string.equals("Feb")) {
            return 2;
        }
        if (string.equals("Mar")) {
            return 3;
        }
        if (string.equals("Apr")) {
            return 4;
        }
        if (string.equals("May")) {
            return 5;
        }
        if (string.equals("Jun")) {
            return 6;
        }
        if (string.equals("Jul")) {
            return 7;
        }
        if (string.equals("Aug")) {
            return 8;
        }
        if (string.equals("Sep")) {
            return 9;
        }
        if (string.equals("Oct")) {
            return 10;
        }
        if (string.equals("Nov")) {
            return 11;
        }
        if (string.equals("Dec")) {
            return 12;
        }
        return 0;
    }

    public static String sendLockRequest(String remoteURI, final IProgressMonitor monitor) throws IOException {
        LockMethod lockMethod = new LockMethod(remoteURI);
        try {
            String requestBody;
            WebDAVUtil.installCredentialsProvider((HttpMethodBase)lockMethod);
            final String finalRequestBody = requestBody = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:lockinfo xmlns:D='DAV:'><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockinfo>";
            final InputStreamProvider data = new InputStreamProvider(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(finalRequestBody.getBytes(WebDAVUtil.UTF_8));
                }
            };
            RequestEntity requestEntity = new RequestEntity(){

                public void writeRequest(OutputStream out) throws IOException {
                    WebDAVUtil.transferStreams(data.getInputStream(), out, monitor);
                }

                public boolean isRepeatable() {
                    return true;
                }

                public String getContentType() {
                    return null;
                }

                public long getContentLength() {
                    return -1L;
                }
            };
            lockMethod.setRequestEntity(requestEntity);
            int statusCode = httpClient.executeMethod((HttpMethod)lockMethod);
            if (statusCode != 200 && statusCode != 201) {
                throw new IOException(lockMethod.getStatusText());
            }
            Header header = lockMethod.getResponseHeader(LOCK_TOKEN_HEADER);
            if (header != null) {
                String string = header.getValue();
                return string;
            }
        }
        finally {
            lockMethod.releaseConnection();
        }
        return null;
    }

    public static void sendUnlockRequest(String remoteURI, String lockToken, IProgressMonitor monitor) throws IOException {
        UnlockMethod unlockMethod = new UnlockMethod(remoteURI);
        try {
            WebDAVUtil.installCredentialsProvider(unlockMethod);
            unlockMethod.addRequestHeader(LOCK_TOKEN_HEADER, lockToken);
            int statusCode = httpClient.executeMethod((HttpMethod)unlockMethod);
            if (statusCode != 204 && statusCode != 200 && statusCode != 409) {
                throw new IOException(unlockMethod.getStatusText());
            }
        }
        finally {
            unlockMethod.releaseConnection();
        }
    }

    public static interface IWebDAVCallback {
        public void setTimestamp(long var1);

        public void setContentType(String var1);

        public void setETag(String var1);
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }

    private static class LockMethod
    extends EntityEnclosingMethod {
        public LockMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return "LOCK";
        }
    }

    private static class PropfindMethod
    extends EntityEnclosingMethod {
        public PropfindMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return "PROPFIND";
        }
    }

    protected static class UnlockMethod
    extends HttpMethodBase {
        public UnlockMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return "UNLOCK";
        }
    }

    public static class WebDAVNode {
        public IPath path;
        public String contentType;
        public String etag;
        public long lastModified;
        public boolean isFolder;
        public boolean supportsLocking;
        public String lockToken;
        public final ArrayList<WebDAVNode> children = new ArrayList();
    }
}

