/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.snippet019.array;

import java.net.URL;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.tests.XWTTestCase;
import org.eclipse.e4.xwt.tests.snippet019.array.Bean;
import org.eclipse.e4.xwt.tests.snippet019.array.TreeViewerWithArrayFactory;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Button;

public class Snippet019Tests
extends XWTTestCase {
    public void testTreeViewerWithListFactory_AddRoot() throws Exception {
        URL url = Snippet019Tests.class.getResource(String.valueOf(TreeViewerWithArrayFactory.class.getSimpleName()) + ".xwt");
        this.runTest(url, TreeViewerWithArrayFactory.createBean("Root"), new Runnable(){

            public void run() {
                Object element = XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"TreeViewer");
                Snippet019Tests.assertTrue((boolean)(element instanceof TreeViewer));
                TreeViewer treeViewer = (TreeViewer)element;
                Object dataContext = XWT.getDataContext((Object)element);
                Snippet019Tests.assertTrue((boolean)(dataContext instanceof Bean));
                Object input = treeViewer.getInput();
                Snippet019Tests.assertTrue((boolean)(input instanceof Bean));
                Snippet019Tests.assertEquals((Object)input, (Object)dataContext);
                Button button = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addRootButton");
                Snippet019Tests.this.selectButton(button);
            }
        }, new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"TreeViewer");
                Snippet019Tests.assertTrue((boolean)(viewer instanceof TreeViewer));
                TreeViewer treeViewer = (TreeViewer)viewer;
                Object input = treeViewer.getInput();
                Snippet019Tests.assertTrue((boolean)(input instanceof Bean));
                Bean bean = (Bean)input;
                Snippet019Tests.assertEquals((int)bean.getList().length, (int)1);
            }
        });
    }

    public void testTreeViewerWithListFactory_AddChild1() throws Exception {
        URL url = Snippet019Tests.class.getResource(String.valueOf(TreeViewerWithArrayFactory.class.getSimpleName()) + ".xwt");
        this.runTest(url, TreeViewerWithArrayFactory.createBean("Root"), new Runnable(){

            public void run() {
                Object element = XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"TreeViewer");
                Snippet019Tests.assertTrue((boolean)(element instanceof TreeViewer));
                TreeViewer treeViewer = (TreeViewer)element;
                Object dataContext = XWT.getDataContext((Object)element);
                Snippet019Tests.assertTrue((boolean)(dataContext instanceof Bean));
                Object input = treeViewer.getInput();
                Snippet019Tests.assertTrue((boolean)(input instanceof Bean));
                Snippet019Tests.assertEquals((Object)input, (Object)dataContext);
                Button addChildButton = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addChildButton");
                Snippet019Tests.assertTrue((!addChildButton.getEnabled() ? 1 : 0) != 0);
                Button button = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addRootButton");
                Snippet019Tests.this.selectButton(button);
            }
        }, new Runnable(){

            public void run() {
                Button addChildbutton = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addChildButton");
                Snippet019Tests.assertTrue((boolean)addChildbutton.getEnabled());
            }
        });
    }

    public void testTreeViewerWithListFactory_AddChild2() throws Exception {
        URL url = Snippet019Tests.class.getResource(String.valueOf(TreeViewerWithArrayFactory.class.getSimpleName()) + ".xwt");
        this.runTest(url, TreeViewerWithArrayFactory.createBean("Root"), new Runnable(){

            public void run() {
                Object element = XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"TreeViewer");
                Snippet019Tests.assertTrue((boolean)(element instanceof TreeViewer));
                TreeViewer treeViewer = (TreeViewer)element;
                Object dataContext = XWT.getDataContext((Object)element);
                Snippet019Tests.assertTrue((boolean)(dataContext instanceof Bean));
                Object input = treeViewer.getInput();
                Snippet019Tests.assertTrue((boolean)(input instanceof Bean));
                Snippet019Tests.assertEquals((Object)input, (Object)dataContext);
                Button addChildButton = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addChildButton");
                Snippet019Tests.assertTrue((!addChildButton.getEnabled() ? 1 : 0) != 0);
                Button button = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addRootButton");
                Snippet019Tests.this.selectButton(button);
                Snippet019Tests.this.selectButton(addChildButton);
            }
        }, new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"TreeViewer");
                Snippet019Tests.assertTrue((boolean)(viewer instanceof TreeViewer));
                TreeViewer treeViewer = (TreeViewer)viewer;
                Object input = treeViewer.getInput();
                Snippet019Tests.assertTrue((boolean)(input instanceof Bean));
                Bean bean = (Bean)input;
                Snippet019Tests.assertEquals((int)bean.getList().length, (int)1);
                Bean child = bean.getList()[0];
                Snippet019Tests.assertEquals((int)child.getList().length, (int)1);
            }
        });
    }

    public void testTreeViewerWithListFactory_Remove() throws Exception {
        URL url = Snippet019Tests.class.getResource(String.valueOf(TreeViewerWithArrayFactory.class.getSimpleName()) + ".xwt");
        this.runTest(url, TreeViewerWithArrayFactory.createBean("Root"), new Runnable(){

            public void run() {
                Object element = XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"TreeViewer");
                Snippet019Tests.assertTrue((boolean)(element instanceof TreeViewer));
                TreeViewer treeViewer = (TreeViewer)element;
                Object dataContext = XWT.getDataContext((Object)element);
                Snippet019Tests.assertTrue((boolean)(dataContext instanceof Bean));
                Object input = treeViewer.getInput();
                Snippet019Tests.assertTrue((boolean)(input instanceof Bean));
                Snippet019Tests.assertEquals((Object)input, (Object)dataContext);
                Button addChildButton = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addChildButton");
                Snippet019Tests.assertTrue((!addChildButton.getEnabled() ? 1 : 0) != 0);
                Button button = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addRootButton");
                Snippet019Tests.this.selectButton(button);
                Snippet019Tests.this.selectButton(addChildButton);
                Button removeButton = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"removeButton");
                Snippet019Tests.this.selectButton(removeButton);
            }
        }, new Runnable(){

            public void run() {
                Object viewer = XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"TreeViewer");
                Snippet019Tests.assertTrue((boolean)(viewer instanceof TreeViewer));
                TreeViewer treeViewer = (TreeViewer)viewer;
                Object input = treeViewer.getInput();
                Snippet019Tests.assertTrue((boolean)(input instanceof Bean));
                Bean bean = (Bean)input;
                Snippet019Tests.assertEquals((int)bean.getList().length, (int)1);
                Bean child = bean.getList()[0];
                Snippet019Tests.assertEquals((int)child.getList().length, (int)0);
                Button removeButton = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addChildButton");
                Snippet019Tests.assertTrue((!removeButton.getEnabled() ? 1 : 0) != 0);
                Button addChildButton = (Button)XWT.findElementByName((Object)Snippet019Tests.this.root, (String)"addChildButton");
                Snippet019Tests.assertTrue((!addChildButton.getEnabled() ? 1 : 0) != 0);
            }
        });
    }
}

