/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.internal.resources.semantic.ui.SemanticResourcesView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BrowseSFSDialog
extends Dialog {
    private final SemanticResourcesView myView;

    public BrowseSFSDialog(Shell parentShell, String initialPath) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.myView = new SemanticResourcesView();
        if (initialPath.startsWith("semanticfs")) {
            String subPath = initialPath.substring("semanticfs".length() + 1);
            this.myView.setSelectedPath(subPath);
        } else {
            this.myView.setSelectedPath(initialPath);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.BrowseSFSDialog_Browser_XGRP);
    }

    public String getSelectedPathString() {
        String selectedPath = this.myView.getSelectedPath();
        if (selectedPath != null) {
            return "semanticfs:" + selectedPath;
        }
        return "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).hint(500, 300).applyTo((Control)main);
        this.myView.createPartControl(main);
        return main;
    }
}

