/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.wizard;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class AddWebDAVResourceNameAndURLPage
extends WizardPage {
    private IContainer myContainer;
    private Text parentText;
    private Text childText;
    private Text urlText;
    private Button forceOverwrite;

    public AddWebDAVResourceNameAndURLPage() {
        super(AddWebDAVResourceNameAndURLPage.class.getName());
        this.setTitle(Messages.AddWebDAVResourceNameAndURLPage_PageTitle_XGRP);
    }

    public void setResourceContainer(IContainer container) {
        this.myContainer = container;
        if (this.myContainer != null) {
            if (this.myContainer.getAdapter(ISemanticResource.class) == null) {
                this.setMessage(Messages.AddWebDAVResourceNameAndURLPage_ParentNotSemanticMessage_XMSG);
            } else {
                this.setMessage(Messages.AddWebDAVResourceNameAndURLPage_ParentIsSemanticMessage_XMSG);
            }
            if (this.parentText != null) {
                this.parentText.setText(this.myContainer.getFullPath().toString());
            }
        }
    }

    public IContainer getResourceContainer() {
        return this.myContainer;
    }

    public boolean getForceOverwrite() {
        return this.forceOverwrite.getSelection();
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        new Label(main, 0).setText(Messages.AddWebDAVResourceNameAndURLPage_ParentLabel_XFLD);
        this.parentText = new Text(main, 2048);
        if (this.myContainer != null) {
            this.parentText.setText(this.myContainer.getFullPath().toString());
        }
        this.parentText.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parentText);
        Button browseButton = new Button(main, 8);
        browseButton.setText(Messages.AddWebDAVResourceNameAndURLPage_BrowseButton_XBUT);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog csd = new ContainerSelectionDialog(AddWebDAVResourceNameAndURLPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.AddWebDAVResourceNameAndURLPage_SelectFolderMessage_XMSG);
                csd.setValidator(new ISelectionValidator(){

                    public String isValid(Object selection) {
                        IPath path = (IPath)selection;
                        if (path.segmentCount() > 1) {
                            IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                            if (folder.isLinked()) {
                                return Messages.AddWebDAVResourceNameAndURLPage_LinksForbiddenMessage_XMSG;
                            }
                            return null;
                        }
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                        if (project.isLinked()) {
                            return Messages.AddWebDAVResourceNameAndURLPage_LinksForbiddenMessage_XMSG;
                        }
                        return null;
                    }
                });
                if (csd.open() == 0) {
                    Object[] result = csd.getResult();
                    IPath path = (IPath)result[0];
                    if (path.segmentCount() > 1) {
                        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                        AddWebDAVResourceNameAndURLPage.this.setResourceContainer((IContainer)folder);
                    } else {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                        AddWebDAVResourceNameAndURLPage.this.setResourceContainer((IContainer)project);
                    }
                    AddWebDAVResourceNameAndURLPage.this.checkPage();
                }
            }
        });
        new Label(main, 0).setText(Messages.AddWebDAVResourceNameAndURLPage_NameLabel_XFLD);
        this.childText = new Text(main, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.childText);
        this.childText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddWebDAVResourceNameAndURLPage.this.checkPage();
            }
        });
        new Label(main, 0).setText(Messages.AddWebDAVResourceNameAndURLPage_WebDAVUrlLabel_XFLD);
        this.urlText = new Text(main, 2048);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.urlText);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddWebDAVResourceNameAndURLPage.this.checkPage();
            }
        });
        this.forceOverwrite = new Button(main, 32);
        this.forceOverwrite.setText(Messages.AddWebDAVResourceNameAndURLPage_OverwriteLabel_XFLD);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.forceOverwrite);
        this.forceOverwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddWebDAVResourceNameAndURLPage.this.checkPage();
            }
        });
        this.setPageComplete(false);
        this.setControl((Control)main);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkPage() {
        block15: {
            this.setErrorMessage(null);
            this.setMessage(null, 2);
            if (this.myContainer == null) {
                this.setErrorMessage(Messages.AddWebDAVResourceNameAndURLPage_ChooseParentFolderMessage_XMSG);
            }
            ** GOTO lbl-1000
            {
                block14: {
                    catch (Throwable var4_4) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw var4_4;
                    }
lbl11:
                    // 3 sources

                    while (true) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        return;
                    }
lbl-1000:
                    // 1 sources

                    {
                        block16: {
                            if (this.childText.getText().length() != 0) break block16;
                            this.setErrorMessage(Messages.AddWebDAVResourceNameAndURLPage_MustProviderChildMessage_XMSG);
                            ** GOTO lbl11
                        }
                        if (this.myContainer.exists((IPath)new Path(this.childText.getText()))) {
                            if (this.forceOverwrite.getSelection()) {
                                this.setMessage(NLS.bind((String)Messages.AddWebDAVResourceNameAndURLPage_OverwriteChildMessage_XMSG, (Object)this.childText.getText()), 2);
                            } else {
                                this.setErrorMessage(NLS.bind((String)Messages.AddWebDAVResourceNameAndURLPage_ChildExistsMessage_XMSG, (Object)this.childText.getText()));
                            }
                            this.forceOverwrite.setEnabled(true);
                            ** continue;
                        }
                        valid = ResourcesPlugin.getWorkspace().validateName(this.childText.getText(), 2);
                        if (valid.isOK()) break block14;
                        this.setErrorMessage(valid.getMessage());
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                try {
                    childPath = this.myContainer.getFullPath().append(this.childText.getText()).toString();
                    sfsUri = new URI("semanticfs", null, childPath, null);
                    if (!EFS.getStore((URI)sfsUri).fetchInfo().exists()) ** GOTO lbl45
                    if (this.forceOverwrite.getSelection()) {
                        this.setMessage(NLS.bind((String)Messages.AddWebDAVResourceNameAndURLPage_StoreOverwriteMessage_XMSG, (Object)sfsUri.toString()), 2);
                    } else {
                        this.setErrorMessage(NLS.bind((String)Messages.AddWebDAVResourceNameAndURLPage_StoreExistsMessage_XMSG, (Object)sfsUri.toString()));
                    }
                    this.forceOverwrite.setEnabled(true);
                }
                catch (URISyntaxException v0) {}
                this.setPageComplete(this.getErrorMessage() == null);
                return;
                {
                    block17: {
                        break block17;
                        catch (CoreException v1) {}
                    }
                    if (this.urlText.getText().length() != 0) break block15;
                    this.setErrorMessage(Messages.AddWebDAVResourceNameAndURLPage_ChooseURLMessage_XMSG);
                }
            }
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public String getChildName() {
        return this.childText.getText();
    }

    public String getUrl() {
        return this.urlText.getText();
    }
}

