/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TestsSemanticResourceException {
    @Test
    public void testStackTraceNoRootCause() {
        String methodName = "testStackTraceNoRootCause";
        SemanticResourceException plain = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, null);
        this.showTrace("Path and message are null", plain);
        SemanticResourceException path = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), null);
        this.showTrace("Path is not null and message are null", path);
        SemanticResourceException message = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, methodName);
        this.showTrace("Path is null and message is not null", message);
        SemanticResourceException both = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), methodName);
        this.showTrace("Path is not null and message is not null", both);
    }

    @Test
    public void testStackTraceWithSimpleRootCause() {
        String methodName = "testStackTraceWithSimpleRootCause";
        RuntimeException rootCause = new RuntimeException("I'm the root cause");
        SemanticResourceException plain = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, null, (Throwable)rootCause);
        this.showTrace("Path and message are null", plain);
        SemanticResourceException path = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), null, (Throwable)rootCause);
        this.showTrace("Path is not null and message are null", path);
        SemanticResourceException message = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, methodName, (Throwable)rootCause);
        this.showTrace("Path is null and message is not null", message);
        SemanticResourceException both = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), methodName, (Throwable)rootCause);
        this.showTrace("Path is not null and message is not null", both);
    }

    @Test
    public void testStackTraceWithNestedRootCause() {
        String methodName = "testStackTraceWithNestedRootCause";
        IOException ioe = new IOException("I'm the root root cause");
        RuntimeException rootCause = new RuntimeException("I'm the root cause", ioe);
        SemanticResourceException plain = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, null, (Throwable)rootCause);
        this.showTrace("Path and message are null", plain);
        SemanticResourceException path = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), null, (Throwable)rootCause);
        this.showTrace("Path is not null and message are null", path);
        SemanticResourceException message = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, methodName, (Throwable)rootCause);
        this.showTrace("Path is null and message is not null", message);
        SemanticResourceException both = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), methodName, (Throwable)rootCause);
        this.showTrace("Path is not null and message is not null", both);
    }

    @Test
    public void testStackTraceWithCoreExceptionRootCause() {
        String methodName = "testStackTraceWithCoreExceptionRootCause";
        IOException ioe = new IOException("I'm the root root cause");
        Status status = new Status(2, "pluginId", "A Message", (Throwable)ioe);
        CoreException rootCause = new CoreException((IStatus)status);
        SemanticResourceException plain = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, null, (Throwable)rootCause);
        this.showTrace("Path and message are null", plain);
        SemanticResourceException path = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), null, (Throwable)rootCause);
        this.showTrace("Path is not null and message are null", path);
        SemanticResourceException message = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, methodName, (Throwable)rootCause);
        this.showTrace("Path is null and message is not null", message);
        SemanticResourceException both = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), methodName, (Throwable)rootCause);
        this.showTrace("Path is not null and message is not null", both);
    }

    @Test
    public void testStackTraceWithMultiStatusCoreExceptionRootCause() {
        String methodName = "testStackTraceWithMultiStatusCoreExceptionRootCause";
        IOException ioe = new IOException("I'm the root root cause");
        MultiStatus status = new MultiStatus("plgin", 0, "I'm the multi status", null);
        status.add((IStatus)new Status(2, "pluginId", "First child no RootCause", null));
        status.add((IStatus)new Status(2, "pluginId", "Second child with RootCause", (Throwable)ioe));
        CoreException rootCause = new CoreException((IStatus)status);
        SemanticResourceException plain = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, null, (Throwable)rootCause);
        this.showTrace("Path and message are null", plain);
        SemanticResourceException path = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), null, (Throwable)rootCause);
        this.showTrace("Path is not null and message are null", path);
        SemanticResourceException message = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, methodName, (Throwable)rootCause);
        this.showTrace("Path is null and message is not null", message);
        SemanticResourceException both = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), methodName, (Throwable)rootCause);
        this.showTrace("Path is not null and message is not null", both);
    }

    @Test
    public void testStackTraceWithSemanticExceptionRootCause() {
        String methodName = "testStackTraceWithSemanticExceptionRootCause";
        IOException ioe = new IOException("I'm the root root cause");
        Status status = new Status(2, "pluginId", "A Message", (Throwable)ioe);
        CoreException coreRoot = new CoreException((IStatus)status);
        SemanticResourceException rootCause = new SemanticResourceException(SemanticResourceStatusCode.FILECACHE_ERROR_WRITING_METADATA, null, "I'm the semantic cause", (Throwable)coreRoot);
        SemanticResourceException plain = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, null, (Throwable)rootCause);
        this.showTrace("Path and message are null", plain);
        SemanticResourceException path = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), null, (Throwable)rootCause);
        this.showTrace("Path is not null and message are null", path);
        SemanticResourceException message = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, null, methodName, (Throwable)rootCause);
        this.showTrace("Path is null and message is not null", message);
        SemanticResourceException both = new SemanticResourceException(SemanticResourceStatusCode.AUTO_REFRESH, (IPath)new Path("Some/path"), methodName, (Throwable)rootCause);
        this.showTrace("Path is not null and message is not null", both);
    }

    private void showTrace(String text, SemanticResourceException plain) {
        this.logForSFS((CoreException)plain, text);
    }

    void logDefault(CoreException x) {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.resources.semantic"));
        if (log != null) {
            log.log(x.getStatus());
        }
    }

    void logWithStack(CoreException x) {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.resources.semantic"));
        if (log != null) {
            Status dummyStatus = new Status(x.getStatus().getSeverity(), x.getStatus().getPlugin(), x.getStatus().getCode(), x.getStatus().getMessage(), (Throwable)x);
            log.log((IStatus)dummyStatus);
        }
    }

    void logForSFS(CoreException x, String text) {
        try {
            ISemanticFileSystem sfs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
            Status textStatus = new Status(1, "org.eclipse.core.resources.semantic.test", text);
            sfs.getLog().log(new CoreException((IStatus)textStatus));
            sfs.getLog().log(x);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    void trace(CoreException x) {
        try {
            if (SfsTraceLocation.CORE.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), x.getMessage(), (Throwable)x);
            }
        }
        catch (Exception exception) {
            x.printStackTrace(System.out);
        }
    }

    void trace(IStatus stat) {
        try {
            if (SfsTraceLocation.CORE.isActive()) {
                SfsTraceLocation.getTrace().trace(SfsTraceLocation.CORE.getLocation(), stat.getMessage());
            }
        }
        catch (Exception exception) {
            this.printChildren(stat, System.out);
        }
    }

    private void printChildren(IStatus status, PrintStream output) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus element = iStatusArray[n2];
            output.println("Contains: " + element.getMessage());
            Throwable exception = element.getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            this.printChildren(element, output);
            ++n2;
        }
    }
}

