/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.javascript.ui;

import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

class PlatformLoggerHandler
extends Handler {
    private Bundle bundle;

    public PlatformLoggerHandler(Bundle bundle) {
        this.bundle = bundle;
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    public void publish(LogRecord record) {
        int severity = 0;
        if (record.getLevel() == Level.SEVERE) {
            severity = 4;
        } else if (record.getLevel() == Level.WARNING) {
            severity = 2;
        } else if (record.getLevel() == Level.INFO) {
            severity = 1;
        }
        Throwable throwable = record.getThrown();
        String message = record.getMessage();
        if (message != null) {
            if (record.getParameters() != null) {
                message = MessageFormat.format(record.getMessage(), record.getParameters());
            }
        } else if (throwable != null && throwable.getMessage() != null) {
            message = throwable.getMessage();
        }
        final Status status = new Status(4, record.getLoggerName(), severity, message, throwable);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Platform.getLog((Bundle)PlatformLoggerHandler.this.bundle).log((IStatus)status);
            }
        });
    }
}

