/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.util.swt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;

public class GridLayoutHelper {
    private Composite fComposite;
    public int[] widths;
    public int[] heights;
    private GridLayout fGridLayout;
    private Field cacheWidthField;
    private Field cacheHeightField;
    private Method computeSizeMethod;

    public void setComposite(Composite aComposite) {
        this.fComposite = aComposite;
        if (aComposite.isDisposed()) {
            return;
        }
        this.fGridLayout = (GridLayout)aComposite.getLayout();
        if (this.fGridLayout != null) {
            this.computeValues();
        }
    }

    private void runComputeSize(GridData aGridData, Object[] args) {
        if (this.computeSizeMethod == null) {
            try {
                this.computeSizeMethod = GridData.class.getDeclaredMethod("computeSize", Control.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                this.computeSizeMethod.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.computeSizeMethod != null) {
                this.computeSizeMethod.invoke((Object)aGridData, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getCacheWidth(GridData aGridData) {
        if (this.cacheWidthField == null) {
            try {
                this.cacheWidthField = GridData.class.getDeclaredField("cacheWidth");
                this.cacheWidthField.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Integer cacheWidth = (Integer)this.cacheWidthField.get(aGridData);
            return cacheWidth;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private int getCacheHeight(GridData aGridData) {
        if (this.cacheHeightField == null) {
            try {
                this.cacheHeightField = GridData.class.getDeclaredField("cacheHeight");
                this.cacheHeightField.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Integer cacheWidth = (Integer)this.cacheHeightField.get(aGridData);
            return cacheWidth;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void putCacheWidth(GridData aGridData, int value) {
        if (this.cacheWidthField == null) {
            try {
                this.cacheWidthField = GridData.class.getDeclaredField("cacheWidth");
                this.cacheWidthField.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.cacheWidthField.setInt(aGridData, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void putCacheHeight(GridData aGridData, int value) {
        if (this.cacheHeightField == null) {
            try {
                this.cacheHeightField = GridData.class.getDeclaredField("cacheHeight");
                this.cacheHeightField.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.cacheHeightField.setInt(aGridData, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeValues() {
        int k;
        int i;
        int k2;
        int i2;
        GridData data;
        Rectangle clientArea = this.fComposite.getClientArea();
        int width = clientArea.width;
        int height = clientArea.height;
        if (this.fGridLayout.numColumns < 1) {
            return;
        }
        int count = 0;
        Control[] children = this.fComposite.getChildren();
        int i3 = 0;
        while (i3 < children.length) {
            Control control = children[i3];
            data = (GridData)control.getLayoutData();
            if (data == null || !data.exclude) {
                children[count++] = children[i3];
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < count) {
            Control child = children[i3];
            data = (GridData)child.getLayoutData();
            if (data == null) {
                data = new GridData();
                child.setLayoutData((Object)data);
            }
            this.runComputeSize(data, new Object[]{child, data.widthHint, data.heightHint, Boolean.FALSE});
            if (data.grabExcessHorizontalSpace && data.minimumWidth > 0 && this.getCacheWidth(data) < data.minimumWidth) {
                int trim = 0;
                if (child instanceof Scrollable) {
                    Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                    trim = rect.width;
                } else {
                    trim = child.getBorderWidth() * 2;
                }
                this.putCacheWidth(data, -1);
                this.putCacheHeight(data, -1);
                this.runComputeSize(data, new Object[]{child, Math.max(0, data.minimumWidth - trim), data.heightHint, Boolean.FALSE});
            }
            if (data.grabExcessVerticalSpace && data.minimumHeight > 0) {
                this.putCacheHeight(data, Math.max(this.getCacheHeight(data), data.minimumHeight));
            }
            ++i3;
        }
        int row = 0;
        int column = 0;
        int rowCount = 0;
        int columnCount = this.fGridLayout.numColumns;
        Control[][] grid = new Control[4][columnCount];
        int i4 = 0;
        while (i4 < count) {
            Control child = children[i4];
            GridData data2 = (GridData)child.getLayoutData();
            if (data2 == null) {
                data2 = new GridData();
            }
            int hSpan = Math.max(1, Math.min(data2.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data2.verticalSpan);
            while (true) {
                int lastRow;
                if ((lastRow = row + vSpan) >= grid.length) {
                    Control[][] newGrid = new Control[lastRow + 4][columnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row] == null) {
                    grid[row] = new Control[columnCount];
                }
                while (column < columnCount && grid[row][column] != null) {
                    ++column;
                }
                int endCount = column + hSpan;
                if (endCount <= columnCount) {
                    int index = column;
                    while (index < endCount && grid[row][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column = index;
                }
                if (column + hSpan < columnCount) continue;
                column = 0;
                ++row;
            }
            int j = 0;
            while (j < vSpan) {
                if (grid[row + j] == null) {
                    grid[row + j] = new Control[columnCount];
                }
                int k3 = 0;
                while (k3 < hSpan) {
                    grid[row + j][column + k3] = child;
                    ++k3;
                }
                ++j;
            }
            rowCount = Math.max(rowCount, row + vSpan);
            column += hSpan;
            ++i4;
        }
        if (rowCount == 0) {
            this.widths = new int[0];
            this.heights = new int[0];
            return;
        }
        int availableWidth = width - this.fGridLayout.horizontalSpacing * (columnCount - 1) - (this.fGridLayout.marginLeft + this.fGridLayout.marginWidth * 2 + this.fGridLayout.marginRight);
        int expandCount = 0;
        this.widths = new int[columnCount];
        int[] minWidths = new int[columnCount];
        boolean[] expandColumn = new boolean[columnCount];
        int j = 0;
        while (j < columnCount) {
            int hSpan;
            i2 = 0;
            while (i2 < rowCount) {
                GridData data3 = this.getData(grid, i2, j, rowCount, columnCount, true);
                if (data3 != null && (hSpan = Math.max(1, Math.min(data3.horizontalSpan, columnCount))) == 1) {
                    int w = this.getCacheWidth(data3) + data3.horizontalIndent;
                    this.widths[j] = Math.max(this.widths[j], w);
                    if (data3.grabExcessHorizontalSpace) {
                        if (!expandColumn[j]) {
                            ++expandCount;
                        }
                        expandColumn[j] = true;
                    }
                    if (!data3.grabExcessHorizontalSpace || data3.minimumWidth != 0) {
                        w = !data3.grabExcessHorizontalSpace || data3.minimumWidth == -1 ? this.getCacheWidth(data3) : data3.minimumWidth;
                        minWidths[j] = Math.max(minWidths[j], w += data3.horizontalIndent);
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < rowCount) {
                GridData data4 = this.getData(grid, i2, j, rowCount, columnCount, false);
                if (data4 != null && (hSpan = Math.max(1, Math.min(data4.horizontalSpan, columnCount))) > 1) {
                    int last;
                    int remainder;
                    int delta;
                    int w;
                    int spanWidth = 0;
                    int spanMinWidth = 0;
                    int spanExpandCount = 0;
                    int k4 = 0;
                    while (k4 < hSpan) {
                        spanWidth += this.widths[j - k4];
                        spanMinWidth += minWidths[j - k4];
                        if (expandColumn[j - k4]) {
                            ++spanExpandCount;
                        }
                        ++k4;
                    }
                    if (data4.grabExcessHorizontalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandColumn[j] = true;
                    }
                    if ((w = this.getCacheWidth(data4) + data4.horizontalIndent - spanWidth - (hSpan - 1) * this.fGridLayout.horizontalSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n = j;
                            this.widths[n] = this.widths[n] + w;
                        } else {
                            delta = w / spanExpandCount;
                            remainder = w % spanExpandCount;
                            last = -1;
                            k2 = 0;
                            while (k2 < hSpan) {
                                if (expandColumn[j - k2]) {
                                    last = j - k2;
                                    this.widths[last] = this.widths[last] + delta;
                                }
                                ++k2;
                            }
                            if (last > -1) {
                                int n = last;
                                this.widths[n] = this.widths[n] + remainder;
                            }
                        }
                    }
                    if (!data4.grabExcessHorizontalSpace || data4.minimumWidth != 0) {
                        int n = w = !data4.grabExcessHorizontalSpace || data4.minimumWidth == -1 ? this.getCacheWidth(data4) : data4.minimumWidth;
                        if ((w += data4.horizontalIndent - spanMinWidth - (hSpan - 1) * this.fGridLayout.horizontalSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n2 = j;
                                minWidths[n2] = minWidths[n2] + w;
                            } else {
                                delta = w / spanExpandCount;
                                remainder = w % spanExpandCount;
                                last = -1;
                                k2 = 0;
                                while (k2 < hSpan) {
                                    if (expandColumn[j - k2]) {
                                        last = j - k2;
                                        minWidths[last] = minWidths[last] + delta;
                                    }
                                    ++k2;
                                }
                                if (last > -1) {
                                    int n3 = last;
                                    minWidths[n3] = minWidths[n3] + remainder;
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
            ++j;
        }
        if (this.fGridLayout.makeColumnsEqualWidth) {
            int minColumnWidth = 0;
            int columnWidth = 0;
            int i5 = 0;
            while (i5 < columnCount) {
                minColumnWidth = Math.max(minColumnWidth, minWidths[i5]);
                columnWidth = Math.max(columnWidth, this.widths[i5]);
                ++i5;
            }
            columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / columnCount);
            i5 = 0;
            while (i5 < columnCount) {
                expandColumn[i5] = expandCount > 0;
                this.widths[i5] = columnWidth;
                ++i5;
            }
        } else if (width != -1 && expandCount > 0) {
            int totalWidth = 0;
            i2 = 0;
            while (i2 < columnCount) {
                totalWidth += this.widths[i2];
                ++i2;
            }
            int c = expandCount;
            int delta = (availableWidth - totalWidth) / c;
            int remainder = (availableWidth - totalWidth) % c;
            int last = -1;
            while (totalWidth != availableWidth) {
                int j2 = 0;
                while (j2 < columnCount) {
                    if (expandColumn[j2]) {
                        if (this.widths[j2] + delta > minWidths[j2]) {
                            last = j2;
                            this.widths[last] = this.widths[j2] + delta;
                        } else {
                            this.widths[j2] = minWidths[j2];
                            expandColumn[j2] = false;
                            --c;
                        }
                    }
                    ++j2;
                }
                if (last > -1) {
                    int n = last;
                    this.widths[n] = this.widths[n] + remainder;
                }
                j2 = 0;
                while (j2 < columnCount) {
                    i = 0;
                    while (i < rowCount) {
                        int hSpan;
                        GridData data5 = this.getData(grid, i, j2, rowCount, columnCount, false);
                        if (!(data5 == null || (hSpan = Math.max(1, Math.min(data5.horizontalSpan, columnCount))) <= 1 || data5.grabExcessHorizontalSpace && data5.minimumWidth == 0)) {
                            int w;
                            int spanWidth = 0;
                            int spanExpandCount = 0;
                            k2 = 0;
                            while (k2 < hSpan) {
                                spanWidth += this.widths[j2 - k2];
                                if (expandColumn[j2 - k2]) {
                                    ++spanExpandCount;
                                }
                                ++k2;
                            }
                            int n = w = !data5.grabExcessHorizontalSpace || data5.minimumWidth == -1 ? this.getCacheWidth(data5) : data5.minimumWidth;
                            if ((w += data5.horizontalIndent - spanWidth - (hSpan - 1) * this.fGridLayout.horizontalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n4 = j2;
                                    this.widths[n4] = this.widths[n4] + w;
                                } else {
                                    int delta2 = w / spanExpandCount;
                                    int remainder2 = w % spanExpandCount;
                                    int last2 = -1;
                                    int k5 = 0;
                                    while (k5 < hSpan) {
                                        if (expandColumn[j2 - k5]) {
                                            last2 = j2 - k5;
                                            this.widths[last2] = this.widths[last2] + delta2;
                                        }
                                        ++k5;
                                    }
                                    if (last2 > -1) {
                                        int n5 = last2;
                                        this.widths[n5] = this.widths[n5] + remainder2;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++j2;
                }
                if (c != 0) {
                    totalWidth = 0;
                    int i6 = 0;
                    while (i6 < columnCount) {
                        totalWidth += this.widths[i6];
                        ++i6;
                    }
                    delta = (availableWidth - totalWidth) / c;
                    remainder = (availableWidth - totalWidth) % c;
                    last = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] flush = null;
        int flushLength = 0;
        if (width != -1) {
            int j3 = 0;
            while (j3 < columnCount) {
                int i7 = 0;
                while (i7 < rowCount) {
                    GridData data6 = this.getData(grid, i7, j3, rowCount, columnCount, false);
                    if (data6 != null && data6.heightHint == -1) {
                        Control child = grid[i7][j3];
                        int hSpan = Math.max(1, Math.min(data6.horizontalSpan, columnCount));
                        int currentWidth = 0;
                        int k6 = 0;
                        while (k6 < hSpan) {
                            currentWidth += this.widths[j3 - k6];
                            ++k6;
                        }
                        if ((currentWidth += (hSpan - 1) * this.fGridLayout.horizontalSpacing - data6.horizontalIndent) != this.getCacheWidth(data6) && data6.horizontalAlignment == 4 || this.getCacheWidth(data6) > currentWidth) {
                            int trim = 0;
                            if (child instanceof Scrollable) {
                                Rectangle rect = ((Scrollable)child).computeTrim(0, 0, 0, 0);
                                trim = rect.width;
                            } else {
                                trim = child.getBorderWidth() * 2;
                            }
                            this.putCacheWidth(data6, -1);
                            this.putCacheHeight(data6, -1);
                            this.runComputeSize(data6, new Object[]{child, Math.max(0, currentWidth - trim), data6.heightHint, Boolean.FALSE});
                            if (data6.grabExcessVerticalSpace && data6.minimumHeight > 0) {
                                this.putCacheHeight(data6, Math.max(this.getCacheHeight(data6), data6.minimumHeight));
                            }
                            if (flush == null) {
                                flush = new GridData[count];
                            }
                            flush[flushLength++] = data6;
                        }
                    }
                    ++i7;
                }
                ++j3;
            }
        }
        int availableHeight = height - this.fGridLayout.verticalSpacing * (rowCount - 1) - (this.fGridLayout.marginTop + this.fGridLayout.marginHeight * 2 + this.fGridLayout.marginBottom);
        expandCount = 0;
        this.heights = new int[rowCount];
        int[] minHeights = new int[rowCount];
        boolean[] expandRow = new boolean[rowCount];
        int i8 = 0;
        while (i8 < rowCount) {
            int vSpan;
            int j4 = 0;
            while (j4 < columnCount) {
                GridData data7 = this.getData(grid, i8, j4, rowCount, columnCount, true);
                if (data7 != null && (vSpan = Math.max(1, Math.min(data7.verticalSpan, rowCount))) == 1) {
                    int h = this.getCacheHeight(data7) + data7.verticalIndent;
                    this.heights[i8] = Math.max(this.heights[i8], h);
                    if (data7.grabExcessVerticalSpace) {
                        if (!expandRow[i8]) {
                            ++expandCount;
                        }
                        expandRow[i8] = true;
                    }
                    if (!data7.grabExcessVerticalSpace || data7.minimumHeight != 0) {
                        h = !data7.grabExcessVerticalSpace || data7.minimumHeight == -1 ? this.getCacheHeight(data7) : data7.minimumHeight;
                        minHeights[i8] = Math.max(minHeights[i8], h += data7.verticalIndent);
                    }
                }
                ++j4;
            }
            j4 = 0;
            while (j4 < columnCount) {
                GridData data8 = this.getData(grid, i8, j4, rowCount, columnCount, false);
                if (data8 != null && (vSpan = Math.max(1, Math.min(data8.verticalSpan, rowCount))) > 1) {
                    int last;
                    int remainder;
                    int delta;
                    int h;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k7 = 0;
                    while (k7 < vSpan) {
                        spanHeight += this.heights[i8 - k7];
                        spanMinHeight += minHeights[i8 - k7];
                        if (expandRow[i8 - k7]) {
                            ++spanExpandCount;
                        }
                        ++k7;
                    }
                    if (data8.grabExcessVerticalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i8] = true;
                    }
                    if ((h = this.getCacheHeight(data8) + data8.verticalIndent - spanHeight - (vSpan - 1) * this.fGridLayout.verticalSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n = i8;
                            this.heights[n] = this.heights[n] + h;
                        } else {
                            delta = h / spanExpandCount;
                            remainder = h % spanExpandCount;
                            last = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i8 - k]) {
                                    last = i8 - k;
                                    this.heights[last] = this.heights[last] + delta;
                                }
                                ++k;
                            }
                            if (last > -1) {
                                int n = last;
                                this.heights[n] = this.heights[n] + remainder;
                            }
                        }
                    }
                    if (!data8.grabExcessVerticalSpace || data8.minimumHeight != 0) {
                        int n = h = !data8.grabExcessVerticalSpace || data8.minimumHeight == -1 ? this.getCacheHeight(data8) : data8.minimumHeight;
                        if ((h += data8.verticalIndent - spanMinHeight - (vSpan - 1) * this.fGridLayout.verticalSpacing) > 0) {
                            if (spanExpandCount == 0) {
                                int n6 = i8;
                                minHeights[n6] = minHeights[n6] + h;
                            } else {
                                delta = h / spanExpandCount;
                                remainder = h % spanExpandCount;
                                last = -1;
                                k = 0;
                                while (k < vSpan) {
                                    if (expandRow[i8 - k]) {
                                        last = i8 - k;
                                        minHeights[last] = minHeights[last] + delta;
                                    }
                                    ++k;
                                }
                                if (last > -1) {
                                    int n7 = last;
                                    minHeights[n7] = minHeights[n7] + remainder;
                                }
                            }
                        }
                    }
                }
                ++j4;
            }
            ++i8;
        }
        if (height != -1 && expandCount > 0) {
            int totalHeight = 0;
            i = 0;
            while (i < rowCount) {
                totalHeight += this.heights[i];
                ++i;
            }
            int c = expandCount;
            int delta = (availableHeight - totalHeight) / c;
            int remainder = (availableHeight - totalHeight) % c;
            int last = -1;
            while (totalHeight != availableHeight) {
                int i9 = 0;
                while (i9 < rowCount) {
                    if (expandRow[i9]) {
                        if (this.heights[i9] + delta > minHeights[i9]) {
                            last = i9;
                            this.heights[last] = this.heights[i9] + delta;
                        } else {
                            this.heights[i9] = minHeights[i9];
                            expandRow[i9] = false;
                            --c;
                        }
                    }
                    ++i9;
                }
                if (last > -1) {
                    int n = last;
                    this.heights[n] = this.heights[n] + remainder;
                }
                i9 = 0;
                while (i9 < rowCount) {
                    int j5 = 0;
                    while (j5 < columnCount) {
                        int vSpan;
                        GridData data9 = this.getData(grid, i9, j5, rowCount, columnCount, false);
                        if (!(data9 == null || (vSpan = Math.max(1, Math.min(data9.verticalSpan, rowCount))) <= 1 || data9.grabExcessVerticalSpace && data9.minimumHeight == 0)) {
                            int h;
                            int spanHeight = 0;
                            int spanExpandCount = 0;
                            k = 0;
                            while (k < vSpan) {
                                spanHeight += this.heights[i9 - k];
                                if (expandRow[i9 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            int n = h = !data9.grabExcessVerticalSpace || data9.minimumHeight == -1 ? this.getCacheHeight(data9) : data9.minimumHeight;
                            if ((h += data9.verticalIndent - spanHeight - (vSpan - 1) * this.fGridLayout.verticalSpacing) > 0) {
                                if (spanExpandCount == 0) {
                                    int n8 = i9;
                                    this.heights[n8] = this.heights[n8] + h;
                                } else {
                                    int delta2 = h / spanExpandCount;
                                    int remainder2 = h % spanExpandCount;
                                    int last2 = -1;
                                    int k8 = 0;
                                    while (k8 < vSpan) {
                                        if (expandRow[i9 - k8]) {
                                            last2 = i9 - k8;
                                            this.heights[last2] = this.heights[last2] + delta2;
                                        }
                                        ++k8;
                                    }
                                    if (last2 > -1) {
                                        int n9 = last2;
                                        this.heights[n9] = this.heights[n9] + remainder2;
                                    }
                                }
                            }
                        }
                        ++j5;
                    }
                    ++i9;
                }
                if (c == 0) break;
                totalHeight = 0;
                i9 = 0;
                while (i9 < rowCount) {
                    totalHeight += this.heights[i9];
                    ++i9;
                }
                delta = (availableHeight - totalHeight) / c;
                remainder = (availableHeight - totalHeight) % c;
                last = -1;
            }
        }
        i8 = 0;
        while (i8 < flushLength) {
            this.putCacheHeight(flush[i8], -1);
            this.putCacheWidth(flush[i8], -1);
            ++i8;
        }
    }

    protected GridData getData(Control[][] grid, int row, int column, int rowCount, int columnCount, boolean first) {
        Control control = grid[row][column];
        if (control != null) {
            int j;
            GridData data = (GridData)control.getLayoutData();
            if (data == null) {
                data = new GridData();
            }
            int hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data.verticalSpan);
            int i = first ? row + vSpan - 1 : row - vSpan + 1;
            int n = j = first ? column + hSpan - 1 : column - hSpan + 1;
            if (i >= 0 && i < rowCount && j >= 0 && j < columnCount && control == grid[i][j]) {
                return data;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        Display d = new Display();
        Shell s = new Shell();
        s.setLayout((Layout)new GridLayout());
        new Label((Composite)s, 0).setText("Label");
        new Button((Composite)s, 0).setText("Button");
        s.open();
        GridLayoutHelper helper = new GridLayoutHelper();
        helper.setComposite((Composite)s);
        while (!s.isDisposed()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        d.dispose();
    }
}

