/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.web;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.internal.web.E4BrowserUtil;
import org.eclipse.e4.ui.web.BrowserRPCHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Shell;

public class BrowserRPC {
    private static final String UNDEFINED = "undefined";
    private BrowserFunction rpcFunction;
    private Map handlers = new HashMap();
    private Browser browser;

    public BrowserRPC(Browser browser) {
        String e4Script;
        this.browser = browser;
        try {
            e4Script = new String(E4BrowserUtil.getBytesFromStream(this.getClass().getClassLoader().getResourceAsStream("js/e4.js")), "ISO-8859-1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                BrowserRPC.this.registerRPC();
            }

            public void changing(LocationEvent event) {
            }
        });
        this.registerRPC();
        browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                if (!BrowserRPC.this.browser.execute(e4Script)) {
                    MessageDialog.openError((Shell)BrowserRPC.this.browser.getShell(), (String)"Error", (String)"Error executing e4 script");
                }
            }

            public void changed(ProgressEvent event) {
            }
        });
    }

    private void registerRPC() {
        if (this.rpcFunction != null) {
            this.rpcFunction.dispose();
        }
        this.rpcFunction = new BrowserFunction(this.browser, "e4RPC"){

            public Object function(Object[] arguments) {
                BrowserRPCHandler handler = (BrowserRPCHandler)BrowserRPC.this.handlers.get(arguments[0]);
                if (handler != null) {
                    return handler.handle(arguments);
                }
                return BrowserRPC.UNDEFINED;
            }
        };
    }

    public void addRPCHandler(String function, BrowserRPCHandler handler) {
        if (this.handlers.get(function) != null) {
            throw new IllegalArgumentException();
        }
        this.handlers.put(function, handler);
    }

    public void removeRPCHandler(String function) {
        this.handlers.remove(function);
    }
}

