/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IDataProviderFactory;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.IMetaclassFactory;
import org.eclipse.e4.xwt.INamespaceHandler;
import org.eclipse.e4.xwt.IStyle;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.LoadingContext;
import org.eclipse.e4.xwt.ResourceDictionary;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.converters.BindingToObject;
import org.eclipse.e4.xwt.converters.CollectionToBoolean;
import org.eclipse.e4.xwt.converters.DateToString;
import org.eclipse.e4.xwt.converters.EnumToString;
import org.eclipse.e4.xwt.converters.ObjectToBoolean;
import org.eclipse.e4.xwt.converters.ObjectToObject;
import org.eclipse.e4.xwt.converters.ObjectToString;
import org.eclipse.e4.xwt.converters.SelectionToBoolean;
import org.eclipse.e4.xwt.converters.StringToBoolean;
import org.eclipse.e4.xwt.converters.StringToColor;
import org.eclipse.e4.xwt.converters.StringToFont;
import org.eclipse.e4.xwt.converters.StringToImage;
import org.eclipse.e4.xwt.converters.StringToIntArray;
import org.eclipse.e4.xwt.converters.StringToInteger;
import org.eclipse.e4.xwt.converters.StringToPoint;
import org.eclipse.e4.xwt.converters.StringToRectangle;
import org.eclipse.e4.xwt.converters.StringToType;
import org.eclipse.e4.xwt.converters.StringToURL;
import org.eclipse.e4.xwt.dataproviders.ObjectDataProvider;
import org.eclipse.e4.xwt.input.ICommand;
import org.eclipse.e4.xwt.internal.core.Core;
import org.eclipse.e4.xwt.internal.core.MetaclassManager;
import org.eclipse.e4.xwt.internal.core.NameScope;
import org.eclipse.e4.xwt.internal.core.Setter;
import org.eclipse.e4.xwt.internal.core.Style;
import org.eclipse.e4.xwt.internal.utils.UserDataHelper;
import org.eclipse.e4.xwt.javabean.ResourceLoaderFactory;
import org.eclipse.e4.xwt.javabean.ValueConvertorRegister;
import org.eclipse.e4.xwt.javabean.metadata.BindingMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.ComboBoxCellEditorMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.ExpandItemHeightAction;
import org.eclipse.e4.xwt.javabean.metadata.TableEditorMetaclass;
import org.eclipse.e4.xwt.javabean.metadata.TableViewerColumnMetaClass;
import org.eclipse.e4.xwt.javabean.metadata.properties.DataProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DynamicBeanProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.StyleProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableColumnEditorProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableEditorDynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableItemEditorProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableItemProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnImageProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnPropertyProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnTextProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnWidthProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableViewerColumnsProperty;
import org.eclipse.e4.xwt.jface.ComboBoxCellEditor;
import org.eclipse.e4.xwt.jface.DefaultCellModifier;
import org.eclipse.e4.xwt.jface.DefaultLabelProvider;
import org.eclipse.e4.xwt.jface.DefaultListContentProvider;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.utils.ResourceManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTLoader
implements IXWTLoader {
    private Core core = null;
    private ILoadingContext _loadingContext = null;
    private Set<Tracking> trackingSet = new HashSet<Tracking>();
    private Map<String, ICommand> commands = new HashMap<String, ICommand>();
    private Map<String, INamespaceHandler> nsHandlers = new HashMap<String, INamespaceHandler>();
    private ILogger logger;
    private Collection<IStyle> defaultStyles = new ArrayList<IStyle>();
    private static Collection<IDataProviderFactory> dataProviderFactories = new ArrayList<IDataProviderFactory>();
    public Display display = Display.getCurrent();
    public Realm realm;

    public XWTLoader() {
        if (this.display == null) {
            this.display = new Display();
        }
        if (this.realm == null) {
            this.realm = SWTObservables.getRealm((Display)this.display);
        }
        this.initialize();
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    @Override
    public ILogger getLogger() {
        if (this.logger == null) {
            return Core.nullLog;
        }
        return this.logger;
    }

    @Override
    public void setLogger(ILogger log) {
        this.logger = log;
    }

    @Override
    public void registerNamespaceHandler(String nsmapace, INamespaceHandler handler) {
        this.nsHandlers.put(nsmapace, handler);
    }

    @Override
    public void unregisterNamespaceHandler(String nsmapace) {
        this.nsHandlers.remove(nsmapace);
    }

    @Override
    public INamespaceHandler getNamespaceHandler(String nsmapace) {
        return this.nsHandlers.get(nsmapace);
    }

    @Override
    public String getNamespace(Class<?> javaclass) {
        if (this.getMetaclass(javaclass) != null) {
            return "http://www.eclipse.org/xwt/presentation";
        }
        Package javaPackage = javaclass.getPackage();
        if (javaPackage == null) {
            return "clr-namespace:";
        }
        return "clr-namespace:" + javaclass.getPackage().getName();
    }

    @Override
    public String getElementName(Object object) {
        return UserDataHelper.getElementName(object);
    }

    @Override
    public NameScope findNameContext(Widget widget) {
        return UserDataHelper.findNameContext(widget);
    }

    @Override
    public Object findElementByName(Widget context, String name) {
        return UserDataHelper.findElementByName(context, name);
    }

    @Override
    public Object getDataContext(Widget element) {
        return UserDataHelper.getDataContext(element);
    }

    @Override
    public void setDataContext(Widget widget, Object dataContext) {
        UserDataHelper.setDataContext(widget, dataContext);
    }

    @Override
    public Object getCLR(Widget widget) {
        return UserDataHelper.getCLR(widget);
    }

    @Override
    public Shell findShell(Widget context) {
        return UserDataHelper.findShell(context);
    }

    @Override
    public Composite findCompositeParent(Widget context) {
        return UserDataHelper.findCompositeParent(context);
    }

    @Override
    public IMetaclass getMetaclass(Object object) {
        return this.core.getMetaclass(object);
    }

    @Override
    public synchronized Control load(URL file) throws Exception {
        return this.loadWithOptions(file, (Map<String, Object>)Collections.EMPTY_MAP);
    }

    @Override
    public synchronized Control load(URL file, Object dataContext) throws Exception {
        return this.load(null, file, dataContext);
    }

    @Override
    public synchronized Control load(Composite parent, URL file) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        return this.loadWithOptions(file, options);
    }

    @Override
    public synchronized Control load(Composite parent, URL file, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        options.put("XWT.DataContext", dataContext);
        return this.loadWithOptions(file, options);
    }

    @Override
    public synchronized Control load(Composite parent, Class<?> viewType, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        options.put("XWT.DataContext", dataContext);
        return this.loadWithOptions(viewType, options);
    }

    protected Map<String, Object> prepareOptions(Map<String, Object> options) {
        Boolean disabledStyle = (Boolean)options.get("XWT.DisabledStyles");
        if (!Boolean.TRUE.equals(disabledStyle)) {
            Collection<IStyle> defaultStyles = this.getDefaultStyles();
            Object styles = options.get("XWT.DefaultStyles");
            if (styles != null) {
                if (styles instanceof IStyle) {
                    defaultStyles.add((IStyle)styles);
                } else if (styles instanceof Collection) {
                    for (IStyle style : (Collection)styles) {
                        defaultStyles.add(style);
                    }
                } else if (styles instanceof Object[]) {
                    Object[] objectArray = (Object[])styles;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (!(element instanceof IStyle)) {
                            throw new XWTException("IStyle is expected in [styles] paramters.");
                        }
                        defaultStyles.add((IStyle)element);
                        ++n2;
                    }
                }
                options.remove("XWT.DefaultStyles");
            }
            if (!defaultStyles.isEmpty()) {
                ResourceDictionary dictionary = (ResourceDictionary)options.get("XWT.Resources");
                if (dictionary == null) {
                    dictionary = new ResourceDictionary();
                    if (options == Collections.EMPTY_MAP) {
                        options = new HashMap<String, Object>();
                    }
                    options.put("XWT.Resources", dictionary);
                }
                dictionary.put("XWT.DefaultStyles", defaultStyles);
            }
        }
        return options;
    }

    @Override
    public synchronized Control loadWithOptions(Class<?> viewType, Map<String, Object> options) throws Exception {
        ILoadingContext context = this.getLoadingContext();
        try {
            this.setLoadingContext(new LoadingContext(viewType.getClassLoader()));
            options = this.prepareOptions(options);
            Control control = this.loadWithOptions(viewType.getResource(String.valueOf(viewType.getSimpleName()) + ".xwt"), options);
            return control;
        }
        finally {
            this.setLoadingContext(context);
        }
    }

    @Override
    public synchronized void open(Class<?> type) throws Exception {
        this.open(type.getResource(String.valueOf(type.getSimpleName()) + ".xwt"), Collections.EMPTY_MAP);
    }

    @Override
    public synchronized void open(URL url) throws Exception {
        this.open(url, Collections.EMPTY_MAP);
    }

    @Override
    public synchronized Control load(Composite parent, InputStream stream, URL file, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        options.put("XWT.DataContext", dataContext);
        return this.loadWithOptions(stream, file, options);
    }

    @Override
    public synchronized void open(URL url, Object dataContext) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.DataContext", dataContext);
        this.open(url, options);
    }

    @Override
    public synchronized void open(Class<?> type, Object dataContext) throws Exception {
        this.open(type.getResource(String.valueOf(type.getSimpleName()) + ".xwt"), dataContext);
    }

    @Override
    public synchronized void open(final URL url, final Map<String, Object> options) throws Exception {
        Realm.runWithDefault((Realm)this.realm, (Runnable)new Runnable(){

            public void run() {
                try {
                    Control control = XWTLoader.this.loadWithOptions(url, (Map<String, Object>)options);
                    Shell shell = control.getShell();
                    shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            ResourceManager.resources.dispose();
                        }
                    });
                    shell.open();
                    while (!shell.isDisposed()) {
                        if (shell.getDisplay().readAndDispatch()) continue;
                        shell.getDisplay().sleep();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public Object convertFrom(IMetaclass type, String string) {
        Class<?> targetType = type.getType();
        return this.convertFrom(targetType, string);
    }

    @Override
    public Object convertFrom(Class<?> targetType, String string) {
        if (targetType == String.class) {
            return string;
        }
        IConverter converter = this.findConvertor(String.class, targetType);
        if (converter != null) {
            return converter.convert((Object)string);
        }
        throw new XWTException("Converter is missing of type: " + targetType.getName() + " from String");
    }

    @Override
    public synchronized Control loadWithOptions(URL url, Map<String, Object> options) throws Exception {
        Composite object = (Composite)options.get("XWT.Container");
        ILoadingContext loadingContext = object != null ? this.getLoadingContext(object) : this.getLoadingContext();
        options = this.prepareOptions(options);
        Control visualObject = this.core.load(loadingContext, url, options);
        return visualObject;
    }

    @Override
    public synchronized Control load(InputStream stream, URL url) throws Exception {
        return this.loadWithOptions(stream, url, Collections.EMPTY_MAP);
    }

    @Override
    public synchronized Control loadWithOptions(InputStream stream, URL base, Map<String, Object> options) throws Exception {
        Composite object = (Composite)options.get("XWT.Container");
        ILoadingContext loadingContext = object != null ? this.getLoadingContext(object) : this.getLoadingContext();
        options = this.prepareOptions(options);
        Control visualObject = this.core.load(loadingContext, stream, base, options);
        return visualObject;
    }

    @Override
    public IMetaclass[] getAllMetaclasses() {
        Collection<IMetaclass> metaclasses = this.core.getAllMetaclasses("http://www.eclipse.org/xwt/presentation");
        return metaclasses.toArray(new IMetaclass[metaclasses.size()]);
    }

    @Override
    public IMetaclass getMetaclass(String tagName, String ns) {
        return this.core.getMetaclass(this.getLoadingContext(), tagName, ns);
    }

    @Override
    public IMetaclass registerMetaclass(Class<?> type) {
        return this.register(type, "http://www.eclipse.org/xwt/presentation");
    }

    @Override
    public void registerMetaclassFactory(IMetaclassFactory metaclassFactory) {
        this.core.registerMetaclassFactory(metaclassFactory);
    }

    @Override
    public IMetaclass register(Class<?> javaclass, String namespace) {
        return this.core.registerMetaclass(javaclass, namespace);
    }

    @Override
    public ConverterService getConverterService() {
        ConverterService service = (ConverterService)this.core.getService(ConverterService.class);
        if (service == null) {
            service = new ConverterService();
            this.core.registerService(ConverterService.class, service);
            service.register(Object.class, new IConverter(){

                public Object convert(Object fromObject) {
                    return null;
                }

                public Object getFromType() {
                    return Object.class;
                }

                public Object getToType() {
                    return String.class;
                }
            });
        }
        return service;
    }

    public static Class<?> normalizedType(Class<?> type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    @Override
    public IConverter findConvertor(Class<?> source, Class<?> target) {
        if ((source = XWTLoader.normalizedType(source)) == (target = XWTLoader.normalizedType(target)) || source != Object.class && source.isAssignableFrom(target)) {
            return ObjectToObject.instance;
        }
        ValueConvertorRegister convertorRegister = (ValueConvertorRegister)this.core.getService(ValueConvertorRegister.class);
        return convertorRegister.findConverter(source, target);
    }

    @Override
    public void registerConvertor(IConverter converter) {
        Class source = (Class)converter.getFromType();
        Class target = (Class)converter.getToType();
        ValueConvertorRegister convertorRegister = (ValueConvertorRegister)this.core.getService(ValueConvertorRegister.class);
        convertorRegister.register(source, target, converter);
    }

    protected void registerConvertor(Class<?> converter, String methodName) {
        try {
            Method method = converter.getDeclaredMethod(methodName, new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            if (object instanceof IConverter) {
                this.registerConvertor((IConverter)object);
            }
        }
        catch (Exception exception) {}
    }

    protected void registerConvertor(Class<?> converterType, String methodName, boolean value) {
        IConverter converter = this.loadConvertor(converterType, methodName, value);
        if (converter != null) {
            this.registerConvertor(converter);
        }
    }

    protected void registerConvertor(ValueConvertorRegister convertorRegister, Class<?> source, Class<?> target, Class<?> converterType, String methodName, boolean value) {
        IConverter converter = this.loadConvertor(converterType, methodName, value);
        if (converter != null) {
            convertorRegister.register(source, target, converter);
        }
    }

    protected IConverter loadConvertor(Class<?> converter, String methodName, boolean value) {
        try {
            Method method = converter.getDeclaredMethod(methodName, new Class[0]);
            Object object = method.invoke(null, value);
            if (object instanceof IConverter) {
                return (IConverter)object;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    @Override
    public void addTracking(Tracking tracking) {
        if (!this.trackingSet.contains((Object)tracking)) {
            this.trackingSet.add(tracking);
        }
    }

    @Override
    public boolean isTracking(Tracking tracking) {
        return this.trackingSet.contains((Object)tracking);
    }

    @Override
    public Set<Tracking> getTrackings() {
        return this.trackingSet;
    }

    @Override
    public void removeTracking(Tracking tracking) {
        if (this.trackingSet.contains((Object)tracking)) {
            this.trackingSet.remove((Object)tracking);
        }
    }

    @Override
    public void registerCommand(String name, ICommand command) {
        this.commands.put(name, command);
    }

    @Override
    public ICommand getCommand(String name) {
        return this.commands.get(name);
    }

    @Override
    public Map<String, ICommand> getCommands() {
        return this.commands;
    }

    @Override
    public void unregisterCommand(String name) {
        this.commands.remove(name);
    }

    @Override
    public void addDefaultStyle(IStyle style) {
        this.defaultStyles.add(style);
    }

    @Override
    public void removeDefaultStyle(IStyle style) {
        this.defaultStyles.remove(style);
    }

    @Override
    public Collection<IStyle> getDefaultStyles() {
        return new ArrayList<IStyle>(this.defaultStyles);
    }

    @Override
    public void addDataProviderFactory(IDataProviderFactory dataProviderFactory) {
        if (dataProviderFactory == null) {
            return;
        }
        if (!dataProviderFactories.contains(dataProviderFactory)) {
            dataProviderFactories.add(dataProviderFactory);
            this.registerMetaclass(dataProviderFactory.getType());
        }
    }

    @Override
    public void removeDataProviderFactory(IDataProviderFactory dataProvider) {
        if (dataProvider == null) {
            return;
        }
        if (dataProviderFactories.contains(dataProvider)) {
            dataProviderFactories.remove(dataProvider);
        }
    }

    @Override
    public Collection<IDataProviderFactory> getDataProviderFactories() {
        return dataProviderFactories;
    }

    @Override
    public IDataProvider findDataProvider(Object dataContext) {
        for (IDataProviderFactory factory : dataProviderFactories) {
            IDataProvider dataProvider = factory.create(dataContext);
            if (dataProvider == null) continue;
            return dataProvider;
        }
        ObjectDataProvider dataProvider = new ObjectDataProvider();
        dataProvider.setObjectInstance(dataContext);
        return dataProvider;
    }

    private void initialize() {
        this.core = new Core(new ResourceLoaderFactory(), this);
        this.core.registerService(ValueConvertorRegister.class, new ValueConvertorRegister());
        this.core.registerMetaclassManager("http://www.eclipse.org/xwt/presentation", new MetaclassManager(null, null, this));
        this.core.registerMetaclass(new BindingMetaclass(this), "http://www.eclipse.org/xwt/presentation");
        this.core.registerMetaclass(new TableEditorMetaclass(this.core.getMetaclass(ControlEditor.class, "http://www.eclipse.org/xwt/presentation"), this), "http://www.eclipse.org/xwt/presentation");
        this.registerConvertor(ObjectToString.instance);
        this.registerConvertor(DateToString.instance);
        this.registerConvertor(EnumToString.instance);
        this.registerConvertor(StringToInteger.instance);
        this.registerConvertor(StringToNumberConverter.class, "toBigDecimal");
        this.registerConvertor(StringToNumberConverter.class, "toByte", false);
        this.registerConvertor((IConverter)StringToNumberConverter.toLong((boolean)false));
        this.registerConvertor(StringToNumberConverter.class, "toShort", false);
        this.registerConvertor((IConverter)StringToNumberConverter.toFloat((boolean)false));
        this.registerConvertor((IConverter)StringToNumberConverter.toDouble((boolean)false));
        this.registerConvertor((IConverter)NumberToStringConverter.fromInteger((boolean)false));
        this.registerConvertor(NumberToStringConverter.class, "fromBigDecimal");
        this.registerConvertor(NumberToStringConverter.class, "fromByte", false);
        this.registerConvertor((IConverter)NumberToStringConverter.fromLong((boolean)false));
        this.registerConvertor(NumberToStringConverter.class, "fromShort", false);
        this.registerConvertor((IConverter)NumberToStringConverter.fromFloat((boolean)false));
        this.registerConvertor((IConverter)NumberToStringConverter.fromDouble((boolean)false));
        this.registerConvertor(StringToBoolean.instance);
        this.registerConvertor(ObjectToBoolean.instance);
        this.registerConvertor(SelectionToBoolean.instance);
        this.registerConvertor(CollectionToBoolean.instance);
        this.registerConvertor(StringToIntArray.instance);
        this.registerConvertor(BindingToObject.instance);
        this.registerConvertor(StringToColor.instance);
        this.registerConvertor(StringToFont.instance);
        this.registerConvertor(StringToImage.instance);
        this.registerConvertor(StringToPoint.instance);
        this.registerConvertor(StringToRectangle.instance);
        this.registerConvertor(StringToURL.instance);
        this.registerConvertor(StringToType.instance);
        ValueConvertorRegister convertorRegister = (ValueConvertorRegister)this.core.getService(ValueConvertorRegister.class);
        convertorRegister.register(String.class, Float.TYPE, (IConverter)StringToNumberConverter.toFloat((boolean)true));
        convertorRegister.register(String.class, Integer.TYPE, StringToInteger.instance);
        this.registerConvertor(convertorRegister, String.class, Short.TYPE, StringToNumberConverter.class, "toShort", true);
        convertorRegister.register(String.class, Long.TYPE, (IConverter)StringToNumberConverter.toLong((boolean)true));
        this.registerConvertor(convertorRegister, String.class, Byte.TYPE, StringToNumberConverter.class, "toByte", true);
        convertorRegister.register(String.class, Boolean.TYPE, StringToBoolean.instance);
        convertorRegister.register(String.class, Double.TYPE, (IConverter)StringToNumberConverter.toDouble((boolean)true));
        convertorRegister.register(Float.TYPE, String.class, (IConverter)NumberToStringConverter.fromFloat((boolean)true));
        convertorRegister.register(Integer.TYPE, String.class, (IConverter)NumberToStringConverter.fromInteger((boolean)true));
        this.registerConvertor(convertorRegister, Short.TYPE, String.class, NumberToStringConverter.class, "fromShort", true);
        convertorRegister.register(Long.TYPE, String.class, (IConverter)NumberToStringConverter.fromLong((boolean)true));
        this.registerConvertor(convertorRegister, Byte.TYPE, String.class, NumberToStringConverter.class, "fromByte", true);
        convertorRegister.register(Double.TYPE, String.class, (IConverter)NumberToStringConverter.fromDouble((boolean)true));
        Class<Browser> type = Browser.class;
        IMetaclass browserMetaclass = this.registerMetaclass(type);
        browserMetaclass.addProperty(new DynamicProperty(type, String.class, "url"));
        IMetaclass buttonMetaclass = this.registerMetaclass(Button.class);
        buttonMetaclass.addProperty(new DataProperty("Command", ICommand.class, "__XWT.Command"));
        this.registerMetaclass(Canvas.class);
        this.registerMetaclass(Caret.class);
        this.registerMetaclass(Combo.class);
        this.registerMetaclass(Composite.class);
        this.registerMetaclass(CoolBar.class);
        this.registerMetaclass(CoolItem.class);
        this.registerMetaclass(DateTime.class);
        this.registerMetaclass(Decorations.class);
        this.registerMetaclass(ExpandBar.class);
        IMetaclass expandItemMetaclass = this.registerMetaclass(ExpandItem.class);
        expandItemMetaclass.findProperty("control").addSetPostAction(new ExpandItemHeightAction());
        this.registerMetaclass(Group.class);
        this.registerMetaclass(IME.class);
        this.registerMetaclass(Label.class);
        this.registerMetaclass(Link.class);
        this.registerMetaclass(Listener.class);
        this.registerMetaclass(List.class);
        this.registerMetaclass(Menu.class);
        IMetaclass menuItemMetaclass = this.registerMetaclass(MenuItem.class);
        menuItemMetaclass.addProperty(new DataProperty("Command", ICommand.class, "__XWT.Command"));
        this.registerMetaclass(MessageBox.class);
        this.registerMetaclass(ProgressBar.class);
        this.registerMetaclass(Sash.class);
        this.registerMetaclass(Scale.class);
        this.registerMetaclass(ScrollBar.class);
        this.registerMetaclass(Shell.class);
        this.registerMetaclass(Slider.class);
        this.registerMetaclass(Spinner.class);
        this.registerMetaclass(TabFolder.class);
        this.registerMetaclass(TabItem.class);
        this.registerMetaclass(Table.class);
        type = TableItem.class;
        IMetaclass metaclass = this.registerMetaclass(type);
        metaclass.addProperty(new TableItemProperty());
        metaclass.addProperty(new TableItemEditorProperty());
        metaclass.addProperty(new DynamicBeanProperty(TableItem.class, String[].class, "texts", "text"));
        this.registerMetaclass(TableItemProperty.Cell.class);
        this.registerMetaclass(ControlEditor.class);
        this.registerMetaclass(TableEditor.class);
        IMetaclass TableEditorMetaclass2 = this.core.getMetaclass(TableEditor.class, "http://www.eclipse.org/xwt/presentation");
        TableEditorMetaclass2.addProperty(new TableEditorDynamicProperty());
        type = TableColumn.class;
        metaclass = this.registerMetaclass(type);
        metaclass.addProperty(new TableColumnEditorProperty());
        this.registerMetaclass(Text.class);
        this.registerMetaclass(ToolBar.class);
        this.registerMetaclass(ToolItem.class);
        this.registerMetaclass(ToolTip.class);
        this.registerMetaclass(Tracker.class);
        this.registerMetaclass(Tray.class);
        this.registerMetaclass(Tree.class);
        this.registerMetaclass(TreeColumn.class);
        this.registerMetaclass(TreeItem.class);
        type = TreeItem.class;
        metaclass = this.registerMetaclass(type);
        metaclass.addProperty(new DynamicBeanProperty(TreeItem.class, String[].class, "texts", "text"));
        this.registerMetaclass(FillLayout.class);
        this.registerMetaclass(FormAttachment.class);
        this.registerMetaclass(FormData.class);
        this.registerMetaclass(FormLayout.class);
        this.registerMetaclass(GridData.class);
        this.registerMetaclass(GridLayout.class);
        this.registerMetaclass(RowData.class);
        this.registerMetaclass(RowLayout.class);
        this.registerMetaclass(StackLayout.class);
        this.registerMetaclass(CLabel.class);
        this.registerMetaclass(CCombo.class);
        this.registerMetaclass(CTabFolder.class);
        this.registerMetaclass(CTabItem.class);
        this.registerMetaclass(SashForm.class);
        this.registerMetaclass(StyledText.class);
        type = Widget.class;
        metaclass = this.registerMetaclass(type);
        metaclass.addProperty(new DataProperty("DataContext", "__XWT.Datacontext"));
        metaclass.addProperty(new StyleProperty());
        type = ColumnViewer.class;
        metaclass = this.core.getMetaclass(type, "http://www.eclipse.org/xwt/presentation");
        if (metaclass != null) {
            metaclass.addProperty(new DynamicBeanProperty(type, String[].class, "columnProperties", "columnProperties"));
            metaclass.addProperty(new TableViewerColumnsProperty());
        }
        Class<?>[] classArray = JFacesHelper.getSupportedElements();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            this.registerMetaclass(cls);
            ++n2;
        }
        this.core.registerMetaclass(new ComboBoxCellEditorMetaclass(this.core.getMetaclass(ComboBoxCellEditor.class.getSuperclass(), "http://www.eclipse.org/xwt/presentation"), this), "http://www.eclipse.org/xwt/presentation");
        type = TableViewerColumn.class;
        this.core.registerMetaclass(new TableViewerColumnMetaClass(this.core.getMetaclass(type.getSuperclass(), "http://www.eclipse.org/xwt/presentation"), this), "http://www.eclipse.org/xwt/presentation");
        metaclass = this.core.getMetaclass(type, "http://www.eclipse.org/xwt/presentation");
        metaclass.addProperty(new TableViewerColumnWidthProperty());
        metaclass.addProperty(new TableViewerColumnTextProperty());
        metaclass.addProperty(new TableViewerColumnImageProperty());
        metaclass.addProperty(new TableViewerColumnPropertyProperty());
        this.registerMetaclass(DefaultCellModifier.class);
        this.registerMetaclass(DefaultLabelProvider.class);
        this.registerMetaclass(ObjectDataProvider.class);
        this.registerMetaclass(Style.class);
        this.registerMetaclass(Setter.class);
        this.registerMetaclass(DefaultListContentProvider.class);
        this.registerMetaclass(ObservableListContentProvider.class);
        this.registerMetaclass(ObservableListTreeContentProvider.class);
        this.registerMetaclass(ObservableSetContentProvider.class);
        this.registerMetaclass(ObservableListTreeContentProvider.class);
        this.registerMetaclass(ObservableSetTreeContentProvider.class);
    }

    @Override
    public ILoadingContext findLoadingContext(Object container) {
        return this.getLoadingContext();
    }

    @Override
    public ILoadingContext getLoadingContext(Composite object) {
        return this.getLoadingContext();
    }

    @Override
    public ILoadingContext getLoadingContext() {
        if (this._loadingContext == null) {
            return LoadingContext.defaultLoadingContext;
        }
        return this._loadingContext;
    }

    @Override
    public void setLoadingContext(ILoadingContext loadingContext) {
        this._loadingContext = loadingContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConverterService {
        protected Map<Class<?>, IConverter> converters = new HashMap();

        ConverterService() {
        }

        public IConverter getConverter(Class<?> type) {
            IConverter converter = this.converters.get(type);
            if (converter != null) {
                return converter;
            }
            return null;
        }

        public void register(Class<?> type, IConverter converter) {
            this.converters.put(type, converter);
        }
    }
}

