/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.databinding.XWTObservableValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanObservableValue
extends XWTObservableValue {
    private String propertyName;

    public BeanObservableValue(Object valueType, Object observed, String propertyName) {
        super(valueType, observed);
        this.propertyName = propertyName;
    }

    @Override
    protected Object doGetValue() {
        Object value = BeanObservableValue.getValue(this.getObserved(), this.propertyName);
        if (value != null) {
            return value;
        }
        return null;
    }

    public static Object getValue(Object target, String propertyName) {
        if (target == null || propertyName == null || propertyName.indexOf(".") != -1) {
            return null;
        }
        Class<?> type = target.getClass();
        try {
            Field[] fields;
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                Method readMethod;
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (propertyName.equalsIgnoreCase(pd.getName()) && (readMethod = pd.getReadMethod()) != null) {
                    return readMethod.invoke(target, null);
                }
                ++n2;
            }
            Field[] fieldArray = fields = type.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field field = fieldArray[n];
                if (propertyName.equalsIgnoreCase(field.getName())) {
                    Object object = field.get(target);
                    return object;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Class<?> getValueType(Class<?> type, String propertyName) {
        if (type == null || propertyName == null || propertyName.indexOf(".") != -1) {
            return null;
        }
        try {
            Field[] fields;
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (propertyName.equals(pd.getName())) {
                    return pd.getPropertyType();
                }
                ++n2;
            }
            Field[] fieldArray = fields = type.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field field = fieldArray[n];
                if (propertyName.equals(field.getName())) {
                    return field.getType();
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static boolean isPropertyReadOnly(Class<?> type, String propertyName) {
        if (type == null || propertyName == null || propertyName.indexOf(".") != -1) {
            return true;
        }
        try {
            Field[] fields;
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (propertyName.equals(pd.getName())) {
                    return pd.getWriteMethod() == null;
                }
                ++n2;
            }
            Field[] fieldArray = fields = type.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field field = fieldArray[n];
                if (propertyName.equals(field.getName())) {
                    return !Modifier.isPublic(field.getModifiers());
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return true;
    }

    @Override
    protected void doSetApprovedValue(Object value) {
        Object observed = this.getObserved();
        BeanObservableValue.setValue(observed, this.propertyName, value);
    }

    public static void setValue(Object target, String propertyName, Object value) {
        Class<?> type = target.getClass();
        try {
            Field[] fields;
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (propertyName.equals(pd.getName())) {
                    Class<?>[] parameterTypes;
                    Class<?> targetType;
                    Method writeMethod = pd.getWriteMethod();
                    if (writeMethod == null) {
                        return;
                    }
                    if (!writeMethod.isAccessible()) {
                        writeMethod.setAccessible(true);
                    }
                    if ((targetType = (parameterTypes = writeMethod.getParameterTypes())[0]) != value.getClass()) {
                        IConverter c;
                        if (targetType.isEnum() && value instanceof String) {
                            try {
                                writeMethod.invoke(target, Enum.valueOf(targetType, (String)value));
                                return;
                            }
                            catch (Exception exception) {}
                        }
                        if ((c = XWT.findConvertor(value.getClass(), targetType)) != null) {
                            value = c.convert(value);
                        }
                    }
                    writeMethod.invoke(target, value);
                    return;
                }
                ++n2;
            }
            Field[] fieldArray = fields = type.getDeclaredFields();
            int n3 = fields.length;
            n = 0;
            while (n < n3) {
                Field field = fieldArray[n];
                if (propertyName.equals(field.getName())) {
                    IConverter c;
                    Class<?> fieldType;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if ((fieldType = field.getType()).isEnum() && value instanceof String) {
                        try {
                            field.set(target, Enum.valueOf(fieldType, (String)value));
                            return;
                        }
                        catch (Exception exception) {}
                    }
                    if ((c = XWT.findConvertor(value.getClass(), fieldType)) != null) {
                        value = c.convert(value);
                    }
                    field.set(target, value);
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

