/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.IBindingContext;
import org.eclipse.e4.xwt.IDataBindingInfo;
import org.eclipse.e4.xwt.IValueConverter;
import org.eclipse.e4.xwt.InverseValueConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTLoader;

public class BindingContext
implements IBindingContext {
    public IObservableValue observeValue;
    public IObservableValue observeWidget;

    public void bind(IObservableValue source, IObservableValue target, IDataBindingInfo dataBinding) {
        if (source != null && target != null) {
            IConverter t2m;
            IConverter m2t;
            Class<Object> targetValueType;
            Class<Object> sourceValueType;
            this.observeValue = source;
            this.observeWidget = target;
            int sourceToTargetPolicy = UpdateValueStrategy.POLICY_UPDATE;
            int targetToSourcePolicy = UpdateValueStrategy.POLICY_UPDATE;
            DataBindingContext core = new DataBindingContext(XWT.getRealm());
            if (dataBinding != null) {
                switch (dataBinding.getBindingMode()) {
                    case OneWay: {
                        targetToSourcePolicy = UpdateValueStrategy.POLICY_NEVER;
                        break;
                    }
                    case OneTime: {
                        sourceToTargetPolicy = UpdateValueStrategy.POLICY_NEVER;
                        targetToSourcePolicy = UpdateValueStrategy.POLICY_NEVER;
                        break;
                    }
                }
            }
            if ((sourceValueType = source.getValueType()) == null) {
                sourceValueType = Object.class;
            }
            if ((targetValueType = target.getValueType()) == null) {
                targetValueType = Object.class;
            }
            Class sourceType = sourceValueType instanceof Class ? sourceValueType : sourceValueType.getClass();
            Class targetType = targetValueType instanceof Class ? targetValueType : targetValueType.getClass();
            sourceType = sourceType == null ? Object.class : XWTLoader.normalizedType(sourceType);
            targetType = targetType == null ? Object.class : XWTLoader.normalizedType(targetType);
            IValueConverter converter = dataBinding.getConverter();
            UpdateValueStrategy sourceToTarget = new UpdateValueStrategy(sourceToTargetPolicy);
            if (converter != null) {
                sourceToTarget.setConverter((IConverter)converter);
            } else if (!targetType.isAssignableFrom(sourceType) && (m2t = XWT.findConvertor(sourceType, targetType)) != null) {
                sourceToTarget.setConverter(m2t);
            }
            UpdateValueStrategy targetToSource = new UpdateValueStrategy(targetToSourcePolicy);
            if (converter != null) {
                targetToSource.setConverter((IConverter)new InverseValueConverter(converter));
            } else if (!sourceType.isAssignableFrom(targetType) && (t2m = XWT.findConvertor(targetType, sourceType)) != null) {
                targetToSource.setConverter(t2m);
            }
            core.bindValue(target, source, targetToSource, sourceToTarget);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TwoWay,
        OneWay,
        OneTime;

    }
}

