/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.IBindingContext;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IValueConverter;
import org.eclipse.e4.xwt.databinding.AbstractDataBinding;
import org.eclipse.e4.xwt.databinding.BindingMode;
import org.eclipse.e4.xwt.databinding.ObservableValueUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class DataBinding
extends AbstractDataBinding {
    private IObservableValue observableSource;
    private IObservableValue observableWidget;

    public DataBinding(Object target, String sourceProperty, String targetProperty, BindingMode mode, IValueConverter converter, IDataProvider dataProvider) {
        super(sourceProperty, targetProperty, target, mode, converter, dataProvider);
        assert (dataProvider != null) : "DataProvider is null";
        assert (sourceProperty != null) : "Binding path is null";
        this.setDataProvider(dataProvider);
    }

    public Object getValue() {
        IObservableValue observableWidget = this.getObservableWidget();
        IDataProvider dataProvider = this.getDataProvider();
        if (observableWidget == null) {
            return dataProvider.getData(this.getSourceProperty());
        }
        IObservableValue observableSource = this.getObservableSource();
        IBindingContext bindingContext = dataProvider.getBindingContext();
        if (bindingContext != null && observableSource != null) {
            String sourceProperty;
            Object target = this.getTarget();
            if (target instanceof Text && this.getTargetProperty().equalsIgnoreCase("text")) {
                String sourceProperty2 = this.getSourceProperty();
                if (dataProvider.isPropertyReadOnly(sourceProperty2)) {
                    Text text = (Text)target;
                    text.setEditable(false);
                }
            } else if (target instanceof Button && this.getTargetProperty().equalsIgnoreCase("selection")) {
                String sourceProperty3 = this.getSourceProperty();
                if (dataProvider.isPropertyReadOnly(sourceProperty3)) {
                    Button button = (Button)target;
                    button.setEnabled(false);
                }
            } else if ((target instanceof Combo || target instanceof CCombo) && this.getTargetProperty().equalsIgnoreCase("text")) {
                String sourceProperty4 = this.getSourceProperty();
                if (dataProvider.isPropertyReadOnly(sourceProperty4)) {
                    Control control = (Control)target;
                    control.setEnabled(false);
                }
            } else if (target instanceof MenuItem && this.getTargetProperty().equalsIgnoreCase("selection") && dataProvider.isPropertyReadOnly(sourceProperty = this.getSourceProperty())) {
                MenuItem menuItem = (MenuItem)target;
                menuItem.setEnabled(false);
            }
            bindingContext.bind(observableSource, observableWidget, this);
        }
        if (observableSource != null) {
            return observableSource.getValue();
        }
        return null;
    }

    public IObservableValue getObservableSource() {
        if (this.observableSource == null) {
            IDataProvider dataProvider = this.getDataProvider();
            String sourceProperty = this.getSourceProperty();
            Class<?> valueType = dataProvider.getDataType(sourceProperty);
            this.observableSource = dataProvider.createObservableValue(valueType, sourceProperty);
        }
        return this.observableSource;
    }

    public IObservableValue getObservableWidget() {
        if (this.observableWidget == null) {
            this.observableWidget = ObservableValueUtil.createWidget(this.getTarget(), this.getTargetProperty());
        }
        return this.observableWidget;
    }
}

