/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.databinding;

import java.lang.reflect.Method;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.internal.databinding.menuitem.MenuItemEnabledObservableValue;
import org.eclipse.e4.xwt.internal.databinding.menuitem.MenuItemSelectionObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class ObservableValueUtil {
    static final String ENABLED = "enabled";
    static final String SELECTION = "selection";
    static final String TEXT = "text";
    public static final Class<?>[] CONTROL_ARGUMENT_TYPES = new Class[]{Control.class};
    public static final Class<?>[] VIEWER_ARGUMENT_TYPES = new Class[]{Viewer.class};

    public static IObservableValue createWidget(Object object, String property) {
        if (object instanceof Control) {
            try {
                return ObservableValueUtil.observePropertyValue((Control)object, property);
            }
            catch (XWTException xWTException) {}
        }
        if (object instanceof MenuItem) {
            if (ENABLED.equalsIgnoreCase(property)) {
                return new MenuItemEnabledObservableValue((MenuItem)object);
            }
            if (SELECTION.equalsIgnoreCase(property)) {
                return new MenuItemSelectionObservableValue((MenuItem)object);
            }
        }
        if (object instanceof Viewer) {
            try {
                return ObservableValueUtil.observePropertyValue((Viewer)object, property);
            }
            catch (XWTException xWTException) {}
        }
        return null;
    }

    public static IObservableValue observePropertyValue(Control control, String property) {
        if (TEXT.equalsIgnoreCase(property)) {
            if (control instanceof Text) {
                return SWTObservables.observeText((Control)control, (int)24);
            }
            if (SWT.getVersion() == 3449 && control instanceof Button) {
                return null;
            }
            try {
                return SWTObservables.observeText((Control)control);
            }
            catch (IllegalArgumentException e) {
                throw new XWTException(e);
            }
        }
        if (property == null) {
            return null;
        }
        String getterName = "observe" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            Method method = SWTObservables.class.getMethod(getterName, CONTROL_ARGUMENT_TYPES);
            if (method == null) {
                Method[] methodArray = SWTObservables.class.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method element = methodArray[n2];
                    if (element.getParameterTypes().length == 0 && element.getName().equalsIgnoreCase(getterName)) {
                        method = element;
                        break;
                    }
                    ++n2;
                }
            }
            if (method != null) {
                return (IObservableValue)method.invoke(null, control);
            }
        }
        catch (Exception e) {
            throw new XWTException(e);
        }
        return null;
    }

    public static IObservableValue observePropertyValue(Viewer viewer, String property) {
        if (property == null) {
            return null;
        }
        String getterName = "observe" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            Method method = ViewersObservables.class.getMethod(getterName, VIEWER_ARGUMENT_TYPES);
            if (method == null) {
                Method[] methodArray = ViewersObservables.class.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method element = methodArray[n2];
                    if (element.getParameterTypes().length == 0 && element.getName().equalsIgnoreCase(getterName)) {
                        method = element;
                        break;
                    }
                    ++n2;
                }
            }
            if (method != null) {
                return (IObservableValue)method.invoke(null, viewer);
            }
        }
        catch (Exception e) {
            throw new XWTException(e);
        }
        return null;
    }
}

