/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.xml;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.internal.xml.Attribute;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.internal.xml.ElementManager;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

class ElementHandler
extends DefaultHandler
implements ContentHandler {
    private Stack<StringBuffer> bufferStack;
    private Stack<DocumentObject> elementStack;
    private Stack<Boolean> switchStack;
    private StringBuffer textBuffer;
    private Locator locator;
    private boolean ignoreSystemProcession;
    private boolean hasSetDefaultEncoding;
    private ElementManager elementManager;
    private String defaultNamespace;
    private ExtensionParser extensionParser = new ExtensionParser();
    protected HashMap<String, String> namespaceMapping = new HashMap();
    private boolean needNormalizeName = true;

    public ElementHandler(ElementManager elementManager) {
        this.bufferStack = new Stack();
        this.elementStack = new Stack();
        this.ignoreSystemProcession = false;
        this.hasSetDefaultEncoding = false;
        this.elementManager = elementManager;
    }

    public ElementHandler(DocumentObject parent, ElementManager elementManager) {
        if (parent != null) {
            this.elementStack.push(parent);
            this.bufferStack.push(this.textBuffer);
        }
        this.ignoreSystemProcession = true;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.switchStack = new Stack();
        this.defaultNamespace = "http://www.eclipse.org/xwt/presentation";
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix.length() == 0 && !this.ignoreSystemProcession) {
            this.defaultNamespace = uri;
        }
        this.namespaceMapping.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaceMapping.remove(prefix);
    }

    public void endDocument() throws SAXException {
        this.elementStack.clear();
        this.bufferStack.clear();
        this.switchStack.clear();
        this.switchStack = null;
        this.defaultNamespace = null;
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (!this.switchStack.isEmpty() && !this.switchStack.peek().booleanValue()) {
            return;
        }
        String string = new String(arg0, arg1, arg2);
        if (string.length() > 0) {
            if (this.textBuffer == null) {
                this.textBuffer = new StringBuffer(string);
            } else {
                this.textBuffer.append(string);
            }
        }
    }

    public void skippedEntity(String name) throws SAXException {
        super.skippedEntity(name);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (!this.ignoreSystemProcession && !this.hasSetDefaultEncoding) {
            Locator2 locator2;
            String encoding;
            if (this.locator instanceof Locator2 && (encoding = (locator2 = (Locator2)this.locator).getEncoding()) != null && encoding.length() > 0) {
                this.elementManager.setEncoding(encoding);
            }
            this.hasSetDefaultEncoding = true;
        }
        uri = this.normalizeNamespace(uri);
        if (!this.switchStack.isEmpty() && !this.switchStack.peek().booleanValue()) {
            if (uri.equalsIgnoreCase("http://www.eclipse.org/xwt/presentation") && "Switch".equals(localName)) {
                this.switchStack.push(false);
            }
            return;
        }
        if (localName.indexOf(46) > 0) {
            this.preProperty(uri, localName, attrs);
        } else {
            this.preElement(uri, localName, attrs);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        uri = this.normalizeNamespace(uri);
        if (!this.switchStack.isEmpty() && !this.switchStack.peek().booleanValue()) {
            if (uri.equalsIgnoreCase("http://www.eclipse.org/xwt/presentation") && "Switch".equals(localName)) {
                this.switchStack.pop();
            }
            return;
        }
        if (!this.elementStack.isEmpty()) {
            DocumentObject element = this.elementStack.peek();
            if (element instanceof Attribute) {
                this.postProperty(uri, localName);
            } else {
                this.postElement(uri, localName);
            }
        }
    }

    private void preElement(String namespace, String name, Attributes attrs) throws SAXException {
        String id;
        namespace = this.normalizeNamespace(namespace);
        if ((name = this.normalizeName(name)).equalsIgnoreCase("xdata")) {
            this.needNormalizeName = false;
        }
        if (this.elementManager.hasElement(id = ElementManager.generateID(name))) {
            throw new SAXException(this.getFormattedMessage("Element already exists: ", id));
        }
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        int i = 0;
        int len = attrs.getLength();
        while (i < len) {
            Attribute attribute;
            String attrUri = this.normalizeAttrNamespace(attrs.getURI(i));
            String attrName = attrs.getLocalName(i);
            int index = attrName.indexOf(46);
            if (index != -1) {
                String prefix = this.normalizeName(attrName.substring(0, attrName.indexOf(46)));
                String attributeName = XWT.isXWTNamespace(attrUri) ? this.normalizeName(attrName.substring(attrName.indexOf(46) + 1)) : attrName;
                attribute = new Attribute(attrUri, attributeName, id);
                attribute.setPrefix(prefix);
            } else {
                attribute = new Attribute(attrUri, XWT.isXWTNamespace(attrUri) ? this.normalizeName(attrName) : attrName, id);
            }
            this.handleContent(attribute, attrs.getValue(i));
            attributes.add(attribute);
            ++i;
        }
        Element element = new Element(namespace, name, attributes, this.namespaceMapping);
        element.setId(id);
        if (!this.elementStack.isEmpty()) {
            this.elementStack.peek().addChild(element);
        }
        this.elementStack.push(element);
        this.bufferStack.push(this.textBuffer);
        this.textBuffer = null;
        this.elementManager.preElement(element);
    }

    private void postElement(String namespace, String name) throws SAXException {
        if (!this.elementStack.isEmpty()) {
            String text;
            DocumentObject element = this.elementStack.pop();
            if (this.textBuffer != null && (text = this.textBuffer.toString().trim()).length() > 0) {
                this.handleContent(element, text);
            }
            this.textBuffer = this.bufferStack.pop();
            this.elementManager.postElement((Element)element);
        }
        if (name.equalsIgnoreCase("xdata")) {
            this.needNormalizeName = true;
        }
    }

    protected void handleContent(DocumentObject element, String text) {
        int index;
        if (text.startsWith("{") && text.endsWith("}")) {
            this.extensionParser.parse(element, text);
            return;
        }
        if (("Type".equals(element.getName()) || "Static".equals(element.getName())) && (index = text.indexOf(58)) != -1) {
            String ns = text.substring(0, index);
            String content = text.substring(index + 1);
            String namespace = this.namespaceMapping.get(ns);
            if (namespace != null) {
                Element childElement = new Element(namespace, content, this.namespaceMapping);
                childElement.setId(ElementManager.generateID(element.getName()));
                element.addChild(childElement);
                return;
            }
        }
        element.setContent(text);
    }

    private void preProperty(String namespace, String name, Attributes attrs) throws SAXException {
        String elementTag = this.normalizeName(name.substring(0, name.indexOf(46)));
        String attributeName = XWT.isXWTNamespace(namespace) ? this.normalizeName(name.substring(name.indexOf(46) + 1)) : name;
        String elementId = null;
        int i = this.elementStack.size() - 1;
        while (i >= 0) {
            DocumentObject element = (DocumentObject)this.elementStack.get(i);
            if (element instanceof Element && element.getName().equals(elementTag)) {
                elementId = element.getId();
                break;
            }
            --i;
        }
        if (elementId == null) {
            this.preElement(namespace, name, attrs);
        } else {
            namespace = this.normalizeNamespace(namespace);
            name = this.normalizeName(name);
            ArrayList<Attribute> collection = new ArrayList<Attribute>();
            int i2 = 0;
            int len = attrs.getLength();
            while (i2 < len) {
                Attribute attr;
                String attrUri = this.normalizeNamespace(attrs.getURI(i2));
                String attrName = attrs.getLocalName(i2);
                int index = attrName.indexOf(46);
                if (index != -1) {
                    String prefix = this.normalizeName(attrName.substring(0, attrName.indexOf(46)));
                    String aName = XWT.isXWTNamespace(namespace) ? this.normalizeName(attrName.substring(attrName.indexOf(46) + 1)) : attrName;
                    attr = new Attribute(attrUri, aName, elementId);
                    attr.setPrefix(prefix);
                } else {
                    attr = new Attribute(attrUri, XWT.isXWTNamespace(namespace) ? this.normalizeName(attrName) : attrName, elementId);
                }
                this.handleContent(attr, attrs.getValue(i2));
                collection.add(attr);
                ++i2;
            }
            Attribute attribute = new Attribute(this.normalizeAttrNamespace(namespace), attributeName, elementId, collection);
            this.elementStack.push(attribute);
            this.bufferStack.push(this.textBuffer);
            this.textBuffer = null;
        }
    }

    private void postProperty(String namespace, String name) throws SAXException {
        if (!this.elementStack.isEmpty()) {
            String text;
            Attribute attribute = (Attribute)this.elementStack.pop();
            if (this.textBuffer != null && (text = this.textBuffer.toString().trim()).length() > 0) {
                this.handleContent(attribute, text);
            }
            this.textBuffer = this.bufferStack.pop();
            Element element = this.elementManager.getElement(attribute.getId());
            element.setAttribute(attribute);
        }
    }

    private String normalizeNamespace(String uri) {
        if (uri == null || uri.length() == 0) {
            uri = this.defaultNamespace;
        }
        if (uri.startsWith("clr-namespace:")) {
            return uri;
        }
        return uri.toLowerCase();
    }

    private String normalizeAttrNamespace(String uri) {
        if (uri == null || uri.length() == 0) {
            uri = this.defaultNamespace;
        }
        if (uri.startsWith("clr-namespace:")) {
            uri = this.defaultNamespace;
        }
        return uri.toLowerCase();
    }

    private String normalizeName(String tagName) {
        if (!this.needNormalizeName) {
            return tagName;
        }
        StringBuffer buffer = new StringBuffer();
        boolean isH = false;
        int i = 0;
        int len = tagName.length();
        while (i < len) {
            char c = tagName.charAt(i);
            if (i == 0) {
                buffer.append(Character.toUpperCase(c));
            } else {
                switch (c) {
                    case '-': {
                        isH = true;
                        break;
                    }
                    case '.': {
                        isH = true;
                        buffer.append(c);
                        break;
                    }
                    default: {
                        if (isH) {
                            buffer.append(Character.toUpperCase(c));
                            isH = false;
                            break;
                        }
                        buffer.append(c);
                    }
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private String getDefaultAttribute(Attributes attrs, String name) {
        String value = attrs.getValue("http://www.eclipse.org/xwt/presentation", name);
        if (value == null || value.length() == 0) {
            value = attrs.getValue(name);
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private String getFormattedMessage(String msg, Object ... args) {
        StringBuffer buffer = new StringBuffer("[" + this.locator.getLineNumber() + "," + this.locator.getColumnNumber() + "] ");
        buffer.append(msg);
        return MessageFormat.format(buffer.toString(), args);
    }

    static /* synthetic */ ElementManager access$1(ElementHandler elementHandler) {
        return elementHandler.elementManager;
    }

    class ExtensionParser {
        private Element root;
        private DocumentObject current;

        ExtensionParser() {
        }

        public void parse(DocumentObject element, String text) {
            if (this.root != null) {
                ExtensionParser parser = new ExtensionParser();
                parser.parse(element, text);
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(text, "{}", true);
            String previous = null;
            String nextPrevious = null;
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken();
                if (previous != null) {
                    if (previous.equals("{")) {
                        if (token.equals("}")) {
                            if (stringTokenizer.hasMoreTokens()) {
                                this.handleBlock(stringTokenizer.nextToken(" \t\n\r\f"), false);
                            }
                        } else {
                            this.startBlock();
                        }
                    } else if (previous.equals("}")) {
                        this.endBlock();
                    } else {
                        String block = previous;
                        if (token.equals("{")) {
                            int level = 1;
                            block = String.valueOf(block) + token;
                            while (stringTokenizer.hasMoreTokens() && level >= 0) {
                                String value = stringTokenizer.nextToken();
                                if (value.equals("{")) {
                                    ++level;
                                } else if (value.equals("}")) {
                                    --level;
                                }
                                if (level < 0) continue;
                                block = String.valueOf(block) + value;
                            }
                        }
                        this.handleBlock(block, nextPrevious == null || !nextPrevious.equals("}"));
                    }
                }
                nextPrevious = previous;
                previous = token;
            }
            element.addChild(this.root);
            this.root = null;
            this.current = null;
        }

        protected void startBlock() {
        }

        protected void endBlock() {
            if (this.current != null) {
                this.current = this.current.getParent().getParent();
            }
        }

        protected Element createElement(String token) {
            int index = token.indexOf(58);
            String namespace = null;
            String name = token;
            if (index != -1) {
                String prefix = token.substring(0, index);
                name = token.substring(index + 1);
                namespace = ElementHandler.this.namespaceMapping.get(prefix);
            }
            if (namespace == null) {
                namespace = ElementHandler.this.defaultNamespace;
            }
            Element element = new Element(namespace, name, ElementHandler.this.namespaceMapping);
            element.setId(ElementManager.generateID(name));
            if (this.current != null) {
                this.current.addChild(element);
            } else if (this.root == null) {
                this.root = element;
            }
            this.current = element;
            return element;
        }

        protected void handleBlock(String content, boolean newElement) {
            Attribute attribute;
            String rootPattern = " \t\n\r\f=,";
            StringTokenizer tokenizer = new StringTokenizer(content, rootPattern, true);
            String attributeName = null;
            String attributeValue = null;
            boolean equals = false;
            Element element = null;
            if (!newElement && this.current instanceof Element) {
                element = (Element)this.current;
            }
            boolean skip = false;
            String token = null;
            while (skip || tokenizer.hasMoreTokens()) {
                if (!skip) {
                    token = tokenizer.nextToken(rootPattern).trim();
                }
                skip = false;
                if (token.length() == 0) continue;
                if (element == null) {
                    element = this.createElement(token);
                } else {
                    if (token.equals("=")) {
                        equals = true;
                        if (!"xpath".equalsIgnoreCase(attributeName)) continue;
                        attributeValue = tokenizer.nextToken(",");
                        continue;
                    }
                    if (token.equals(",")) {
                        if (attributeName != null) {
                            if (attributeValue != null) {
                                attribute = new Attribute(ElementHandler.this.normalizeAttrNamespace(this.current.getNamespace()), attributeName, ElementManager.generateID(this.current.getName()));
                                ElementHandler.this.handleContent(attribute, attributeValue);
                                element.setAttribute(attribute);
                                this.current = attribute;
                            } else {
                                element.setContent(attributeName);
                            }
                            attributeName = null;
                            attributeValue = null;
                            equals = false;
                        }
                    } else if (attributeName == null) {
                        attributeName = token;
                    } else {
                        String block = token;
                        if (token.startsWith("{")) {
                            int level = 1;
                            while (tokenizer.hasMoreTokens() && level > 0) {
                                String value = tokenizer.nextToken("{}");
                                if (value.equals("{")) {
                                    ++level;
                                } else if (value.equals("}")) {
                                    --level;
                                }
                                block = String.valueOf(block) + value;
                            }
                        }
                        attributeValue = block;
                        try {
                            token = tokenizer.nextToken(rootPattern).trim();
                            skip = true;
                            continue;
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                    }
                }
                skip = false;
            }
            if (equals) {
                attribute = new Attribute(ElementHandler.this.normalizeAttrNamespace(this.current.getNamespace()), attributeName, ElementManager.generateID(this.current.getName()));
                if (attributeValue != null) {
                    ElementHandler.this.handleContent(attribute, attributeValue);
                    element.setAttribute(attribute);
                } else {
                    element.setAttribute(attribute);
                    this.current = attribute;
                }
            } else if (attributeName != null) {
                int index = attributeName.indexOf(":");
                if (index != -1) {
                    element = this.createElement(attributeName);
                    this.current = this.current.getParent();
                } else {
                    this.current.setContent(attributeName);
                }
            }
        }
    }
}

