/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.xwt.IXWTLoader;
import org.eclipse.e4.xwt.javabean.metadata.BeanEvent;
import org.eclipse.e4.xwt.javabean.metadata.LoadedEvent;
import org.eclipse.e4.xwt.javabean.metadata.TypedEvent;
import org.eclipse.e4.xwt.javabean.metadata.properties.BeanProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.DynamicProperty;
import org.eclipse.e4.xwt.javabean.metadata.properties.FieldProperty;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMetaclass
implements IMetaclass {
    public static IProperty[] EMPTY_PROPERTIES = new IProperty[0];
    public static IEvent[] EMPTY_ROUTED_EVENTS = new IEvent[0];
    protected final Map<String, IProperty> propertyCache = new HashMap<String, IProperty>();
    protected Map<String, IEvent> routedEventCache = new HashMap<String, IEvent>();
    public static final String LOADED = "Loaded";
    protected Class<?> type;
    protected String name;
    protected IMetaclass superClass;
    protected IXWTLoader xwtLoader;
    protected boolean buildTypedEvents;
    private boolean initialize = false;

    protected boolean shouldIgnored(Class<?> type, String propertyName, Class<?> propertyType) {
        String packageName = "";
        if (type.getPackage() != null) {
            packageName = type.getPackage().getName();
        }
        if ("data".equals(propertyName) && packageName.startsWith("org.eclipse.swt.")) {
            return true;
        }
        if ("class".equals(propertyName)) {
            return true;
        }
        return "handle".equals(propertyName) && Integer.TYPE == propertyType || "monitor".equals(propertyName) && Monitor.class == propertyType || "region".equals(propertyName) && Region.class == propertyType || "parent".equals(propertyName) && Composite.class == propertyType || "shell".equals(propertyName) && Shell.class == propertyType || "display".equals(propertyName) && Display.class == propertyType;
    }

    protected boolean isWidgetType(Class<?> type) {
        Class<?> superClass = type.getSuperclass();
        if (superClass != null) {
            if (superClass.getName().equalsIgnoreCase(Widget.class.getName())) {
                return true;
            }
            return this.isWidgetType(superClass);
        }
        return false;
    }

    protected final IXWTLoader getXWTLoader() {
        return this.xwtLoader;
    }

    @Override
    public IProperty addProperty(IProperty property) {
        String name = this.normalize(property.getName());
        return this.propertyCache.put(name, property);
    }

    private void buildTypedEvents() {
        if (this.buildTypedEvents) {
            return;
        }
        if (this.isSubclassOf(this.getXWTLoader().getMetaclass(Widget.class))) {
            this.addTypedEvent("Activate", 26);
            this.addTypedEvent("Arm", 30);
            this.addTypedEvent("Close", 21);
            this.addTypedEvent("Collapse", 18);
            this.addTypedEvent("Deactivate", 27);
            this.addTypedEvent("DefaultSelection", 14);
            this.addTypedEvent("Deiconify", 20);
            this.addTypedEvent("Dispose", 12);
            this.addTypedEvent("DragDetect", 29);
            this.addTypedEvent("EraseItem", 40);
            this.addTypedEvent("Expand", 17);
            this.addTypedEvent("FocusIn", 15);
            this.addTypedEvent("FocusOut", 16);
            this.addTypedEvent("HardKeyDown", 33);
            this.addTypedEvent("HardKeyUp", 34);
            this.addTypedEvent("Help", 28);
            this.addTypedEvent("Hide", 23);
            this.addTypedEvent("Iconify", 19);
            this.addTypedEvent("KeyDown", 1);
            this.addTypedEvent("KeyUp", 2);
            this.addTypedEvent("MeasureItem", 41);
            this.addTypedEvent("MenuDetect", 35);
            this.addTypedEvent("Modify", 24);
            this.addTypedEvent("MouseDoubleClick", 8);
            this.addTypedEvent("MouseDown", 3);
            this.addTypedEvent("MouseEnter", 6);
            this.addTypedEvent("MouseExit", 7);
            this.addTypedEvent("MouseHover", 32);
            this.addTypedEvent("MouseMove", 5);
            this.addTypedEvent("MouseUp", 4);
            this.addTypedEvent("MouseWheel", 37);
            this.addTypedEvent("Move", 10);
            this.addTypedEvent("Paint", 9);
            this.addTypedEvent("PaintItem", 42);
            this.addTypedEvent("Resize", 11);
            this.addTypedEvent("Selection", 13);
            this.addTypedEvent("SetData", 36);
            this.addTypedEvent("Show", 22);
            this.addTypedEvent("Traverse", 31);
            this.addTypedEvent("Verify", 25);
            this.addTypedEvent("ImeComposition", 43);
        }
        this.buildTypedEvents = true;
    }

    private void addTypedEvent(String name, int eventType) {
        if (!this.routedEventCache.containsKey(this.normalize(String.valueOf(name) + "Event"))) {
            this.routedEventCache.put(this.normalize(String.valueOf(name) + "Event"), new TypedEvent(name, eventType));
        }
    }

    @Override
    public IProperty findDefaultProperty() {
        return null;
    }

    @Override
    public IEvent findEvent(String name) {
        this.assertInitialize();
        this.buildTypedEvents();
        return this.routedEventCache.get(this.normalize(name));
    }

    @Override
    public IProperty findProperty(String name) {
        this.assertInitialize();
        IProperty property = this.propertyCache.get(this.normalize(name));
        if (property == null && this.superClass != null) {
            property = this.superClass.findProperty(name);
        }
        if (property == null) {
            try {
                Method getter = DynamicProperty.createGetter(this.type, name);
                Class<?> propertyType = getter.getReturnType();
                Method setter = DynamicProperty.createSetter(this.type, propertyType, name);
                return new DynamicProperty(propertyType, setter, getter, name);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return property;
    }

    protected String normalize(String name) {
        return name.toLowerCase();
    }

    @Override
    public IEvent[] getEvents() {
        this.assertInitialize();
        this.buildTypedEvents();
        return this.routedEventCache.values().toArray(new IEvent[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IProperty[] getProperties() {
        this.assertInitialize();
        return this.propertyCache.values().toArray(new IProperty[this.propertyCache.size()]);
    }

    @Override
    public IMetaclass getSuperClass() {
        return this.superClass;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.type.getModifiers());
    }

    @Override
    public boolean isAssignableFrom(IMetaclass metaclass) {
        return this.getType().isAssignableFrom(metaclass.getType());
    }

    @Override
    public boolean isInstance(Object object) {
        return this.type.isInstance(object);
    }

    @Override
    public boolean isSubclassOf(IMetaclass metaclass) {
        this.assertInitialize();
        if (metaclass == null) {
            return false;
        }
        if (this == metaclass) {
            return true;
        }
        if (this.superClass == metaclass) {
            return true;
        }
        if (this.superClass != null) {
            return this.superClass.isSubclassOf(metaclass);
        }
        return false;
    }

    @Override
    public boolean isSuperclassOf(IMetaclass metaclass) {
        return metaclass.isSubclassOf(this);
    }

    @Override
    public Object newInstance(Object[] parameters) {
        this.assertInitialize();
        try {
            if (parameters.length == 0 || !(parameters[0] instanceof Widget) && !JFacesHelper.isViewer(parameters[0])) {
                return this.getType().newInstance();
            }
        }
        catch (Exception exception) {}
        try {
            Class<?>[] parameterTypes;
            Constructor<?> constructor;
            Object swtObject = null;
            Object parent = parameters[0];
            Widget directParent = null;
            if (parent instanceof Widget) {
                directParent = (Widget)parent;
            } else if (JFacesHelper.isViewer(parent)) {
                directParent = JFacesHelper.getControl(parent);
            } else {
                throw new IllegalStateException();
            }
            if (Control.class.isAssignableFrom(this.getType()) && !(directParent instanceof Composite)) {
                directParent = this.getXWTLoader().findCompositeParent(directParent);
            }
            Object styleValue = null;
            if (parameters.length == 2 && parameters[1] != null && (parameters[1].getClass() == Integer.TYPE || parameters[1].getClass() == Integer.class)) {
                styleValue = parameters[1];
            }
            Constructor<?> defaultConstructor = null;
            Constructor<?>[] constructorArray = this.getType().getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                constructor = constructorArray[n2];
                parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length > 2 || parameterTypes.length == 0) {
                    if (parameterTypes.length == 0) {
                        defaultConstructor = constructor;
                    }
                } else if (parameterTypes[0].isAssignableFrom(parent.getClass())) {
                    if (parameterTypes.length == 1) {
                        swtObject = constructor.newInstance(parent);
                        break;
                    }
                    if (parameterTypes[1].isAssignableFrom(Integer.TYPE)) {
                        if (styleValue == null) {
                            swtObject = constructor.newInstance(parent, 0);
                            break;
                        }
                        swtObject = constructor.newInstance(parent, styleValue);
                        break;
                    }
                }
                ++n2;
            }
            if (swtObject == null) {
                constructorArray = this.getType().getConstructors();
                n = constructorArray.length;
                n2 = 0;
                while (n2 < n) {
                    constructor = constructorArray[n2];
                    parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length > 2 || parameterTypes.length == 0) {
                        if (parameterTypes.length == 0) {
                            defaultConstructor = constructor;
                        }
                    } else if (parameterTypes[0].isAssignableFrom(directParent.getClass())) {
                        if (parameterTypes.length == 1) {
                            swtObject = constructor.newInstance(directParent);
                            break;
                        }
                        if (parameterTypes[1].isAssignableFrom(Integer.TYPE)) {
                            if (styleValue == null) {
                                swtObject = constructor.newInstance(directParent, 0);
                                break;
                            }
                            swtObject = constructor.newInstance(directParent, styleValue);
                            break;
                        }
                    }
                    ++n2;
                }
            }
            if (swtObject == null) {
                if (defaultConstructor == null) {
                    try {
                        swtObject = this.getType().newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new UnsupportedOperationException("Constructor " + this.getType().getName() + " no found.");
                    }
                }
                swtObject = defaultConstructor.newInstance(new Object[0]);
            }
            return swtObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Class<?> getDataContextType() {
        return Object.class;
    }

    private void assertInitialize() {
        this.initialize(this.type, this.superClass);
    }

    protected void initialize(Class<?> type, IMetaclass superClass) {
        if (this.isInitialize()) {
            return;
        }
        try {
            Class<?> propertyType;
            String propertyName;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            Object[] objectArray = propertyDescriptors;
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor p = objectArray[n2];
                propertyName = p.getName();
                if (!this.shouldIgnored(type, propertyName, propertyType = p.getPropertyType()) && !this.propertyCache.containsKey(propertyName.toLowerCase()) && p.getPropertyType() != null) {
                    IProperty property;
                    IProperty iProperty = property = superClass != null ? superClass.findProperty(p.getName()) : null;
                    if (property != null && !property.isDefault()) {
                        this.addProperty(property);
                    } else if (p.getWriteMethod() != null || !p.getPropertyType().isPrimitive()) {
                        this.addProperty(new BeanProperty(p));
                    }
                }
                ++n2;
            }
            objectArray = type.getDeclaredFields();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object f = objectArray[n2];
                propertyName = ((Field)f).getName();
                if (!this.shouldIgnored(type, propertyName, propertyType = ((Field)f).getType()) && !this.propertyCache.containsKey(this.normalize(propertyName)) && !Modifier.isFinal(((Field)f).getModifiers()) && Modifier.isPublic(((Field)f).getModifiers())) {
                    this.addProperty(new FieldProperty((Field)f));
                }
                ++n2;
            }
            objectArray = beanInfo.getEventSetDescriptors();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object eventSetDescriptor = objectArray[n2];
                BeanEvent event = new BeanEvent(((FeatureDescriptor)eventSetDescriptor).getName(), (EventSetDescriptor)eventSetDescriptor);
                this.routedEventCache.put(this.normalize(String.valueOf(((FeatureDescriptor)eventSetDescriptor).getName()) + "Event"), event);
                ++n2;
            }
            if (this.isWidgetType(type)) {
                this.routedEventCache.put(this.normalize(LOADED), new LoadedEvent(LOADED));
            }
            this.markInitialized();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void markInitialized() {
        this.initialize = true;
    }

    private boolean isInitialize() {
        return this.initialize;
    }
}

