/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata.properties;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.javabean.metadata.properties.AbstractProperty;

public class BeanProperty
extends AbstractProperty {
    protected PropertyDescriptor descriptor;

    public BeanProperty(PropertyDescriptor descriptor) {
        super(descriptor.getName(), descriptor.getPropertyType());
        if (descriptor == null) {
            throw new NullPointerException();
        }
        this.descriptor = descriptor;
    }

    public void setValue(Object target, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        Method writeMethod;
        Class<?>[] parameterTypes;
        if (this.descriptor != null && this.descriptor.getWriteMethod() != null && (parameterTypes = (writeMethod = this.descriptor.getWriteMethod()).getParameterTypes()).length == 1) {
            Class<?> paraType;
            IConverter convertor = XWT.findConvertor(value == null ? Object.class : value.getClass(), paraType = parameterTypes[0]);
            if (convertor != null) {
                value = convertor.convert(value);
            }
            writeMethod.invoke(target, value);
            this.fireSetPostAction(target, this, value);
        }
    }

    public Object getValue(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        if (this.descriptor != null && this.descriptor.getReadMethod() != null) {
            Method writeMethod = this.descriptor.getReadMethod();
            return writeMethod.invoke(target, new Object[0]);
        }
        return null;
    }

    public boolean isDefault() {
        return true;
    }
}

