/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.jface;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;

public class DefaultLabelProvider
implements ITableLabelProvider {
    protected TableViewer tableViewer;

    public DefaultLabelProvider(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(Object element, int columnIndex) {
        Object[] properties = this.tableViewer.getColumnProperties();
        if (properties == null) {
            throw new XWTException("property is missing in TableViewerColumn or TableViewer.columnProperties is missing.");
        }
        String propertyName = properties[columnIndex].toString();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(element.getClass());
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return "";
                }
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                if (propertyDescriptor.getName().equalsIgnoreCase(propertyName)) {
                    Object value = propertyDescriptor.getReadMethod().invoke(element, new Object[0]);
                    if (value == null) return null;
                    Class<?> type = value.getClass();
                    if (type == String.class) return value.toString();
                    IConverter converter = XWT.findConvertor(type, String.class);
                    if (converter == null) return value.toString();
                    value = converter.convert(value);
                    return value.toString();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new XWTException(e);
        }
    }
}

