/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;

public final class EditorSelectionDialog
extends Dialog {
    private EditorDescriptor selectedEditor;
    private Button externalButton;
    private Table editorTable;
    private Button browseExternalEditorsButton;
    private Button internalButton;
    private Button okButton;
    private static final String STORE_ID_INTERNAL_EXTERNAL = "EditorSelectionDialog.STORE_ID_INTERNAL_EXTERNAL";
    private String message = WorkbenchMessages.EditorSelection_chooseAnEditor;
    private IEditorDescriptor[] externalEditors;
    private IEditorDescriptor[] internalEditors;
    private Image[] externalEditorImages;
    private Image[] internalEditorImages;
    private IEditorDescriptor[] editorsToFilter;
    private DialogListener listener = new DialogListener();
    private static final String[] Executable_Filters = Util.isWindows() ? new String[]{"*.exe", "*.bat", "*.*"} : new String[]{"*"};
    private static final int TABLE_WIDTH = 200;

    public EditorSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        int i;
        if (this.internalEditorImages != null) {
            i = 0;
            while (i < this.internalEditorImages.length) {
                this.internalEditorImages[i].dispose();
                ++i;
            }
            this.internalEditorImages = null;
        }
        if (this.externalEditorImages != null) {
            i = 0;
            while (i < this.externalEditorImages.length) {
                this.externalEditorImages[i].dispose();
                ++i;
            }
            this.externalEditorImages = null;
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.EditorSelection_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.editor_selection_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite contents = (Composite)super.createDialogArea(parent);
        ((GridLayout)contents.getLayout()).numColumns = 2;
        Label textLabel = new Label(contents, 0);
        textLabel.setText(this.message);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        textLabel.setLayoutData((Object)data);
        textLabel.setFont(font);
        this.internalButton = new Button(contents, 16400);
        this.internalButton.setText(WorkbenchMessages.EditorSelection_internal);
        this.internalButton.addListener(13, (Listener)this.listener);
        data = new GridData();
        data.horizontalSpan = 1;
        this.internalButton.setLayoutData((Object)data);
        this.internalButton.setFont(font);
        this.externalButton = new Button(contents, 16400);
        this.externalButton.setText(WorkbenchMessages.EditorSelection_external);
        this.externalButton.addListener(13, (Listener)this.listener);
        data = new GridData();
        data.horizontalSpan = 1;
        this.externalButton.setLayoutData((Object)data);
        this.externalButton.setFont(font);
        this.editorTable = new Table(contents, 2052);
        this.editorTable.addListener(13, (Listener)this.listener);
        this.editorTable.addListener(14, (Listener)this.listener);
        this.editorTable.addListener(8, (Listener)this.listener);
        data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 2;
        this.editorTable.setLayoutData((Object)data);
        this.editorTable.setFont(font);
        data.heightHint = this.editorTable.getItemHeight() * 12;
        this.browseExternalEditorsButton = new Button(contents, 8);
        this.browseExternalEditorsButton.setText(WorkbenchMessages.EditorSelection_browse);
        this.browseExternalEditorsButton.addListener(13, (Listener)this.listener);
        data = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseExternalEditorsButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseExternalEditorsButton.setLayoutData((Object)data);
        this.browseExternalEditorsButton.setFont(font);
        this.restoreWidgetValues();
        this.fillEditorTable();
        this.updateEnableState();
        return contents;
    }

    protected void fillEditorTable() {
        Image[] images;
        IEditorDescriptor[] editors;
        this.editorTable.removeAll();
        this.editorTable.update();
        if (this.internalButton.getSelection()) {
            editors = this.getInternalEditors();
            images = this.internalEditorImages;
        } else {
            editors = this.getExternalEditors();
            images = this.externalEditorImages;
        }
        this.editorTable.setRedraw(false);
        int i = 0;
        while (i < editors.length) {
            TableItem item = new TableItem(this.editorTable, 0);
            item.setData((Object)editors[i]);
            item.setText(editors[i].getLabel());
            item.setImage(images[i]);
            ++i;
        }
        this.editorTable.setRedraw(true);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("EditorSelectionDialog");
        if (section == null) {
            section = workbenchSettings.addNewSection("EditorSelectionDialog");
        }
        return section;
    }

    protected IEditorDescriptor[] getExternalEditors() {
        if (this.externalEditors == null) {
            Composite topShell;
            Shell shell = this.getShell();
            if (!shell.isVisible() && (topShell = shell.getParent()) != null) {
                shell = topShell;
            }
            Cursor busy = new Cursor((Device)shell.getDisplay(), 1);
            shell.setCursor(busy);
            EditorRegistry reg = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            this.externalEditors = reg.getSortedEditorsFromOS();
            this.externalEditors = this.filterEditors(this.externalEditors);
            this.externalEditorImages = this.getImages(this.externalEditors);
            shell.setCursor(null);
            busy.dispose();
        }
        return this.externalEditors;
    }

    protected IEditorDescriptor[] filterEditors(IEditorDescriptor[] editors) {
        if (editors == null || editors.length < 1) {
            return editors;
        }
        if (this.editorsToFilter == null || this.editorsToFilter.length < 1) {
            return editors;
        }
        ArrayList<IEditorDescriptor> filteredList = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            boolean add = true;
            int j = 0;
            while (j < this.editorsToFilter.length) {
                if (editors[i].getId().equals(this.editorsToFilter[j].getId())) {
                    add = false;
                }
                ++j;
            }
            if (add) {
                filteredList.add(editors[i]);
            }
            ++i;
        }
        return filteredList.toArray(new IEditorDescriptor[filteredList.size()]);
    }

    protected Image[] getImages(IEditorDescriptor[] editors) {
        Image[] images = new Image[editors.length];
        int i = 0;
        while (i < editors.length) {
            images[i] = editors[i].getImageDescriptor().createImage();
            ++i;
        }
        return images;
    }

    protected IEditorDescriptor[] getInternalEditors() {
        if (this.internalEditors == null) {
            EditorRegistry reg = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            this.internalEditors = reg.getSortedEditorsFromPlugins();
            this.internalEditors = this.filterEditors(this.internalEditors);
            this.internalEditorImages = this.getImages(this.internalEditors);
        }
        return this.internalEditors;
    }

    public IEditorDescriptor getSelectedEditor() {
        return this.selectedEditor;
    }

    protected void promptForExternalEditor() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10009000);
        dialog.setFilterExtensions(Executable_Filters);
        String result = dialog.open();
        if (result != null) {
            EditorDescriptor editor = EditorDescriptor.createForProgram(result);
            TableItem ti = new TableItem(this.editorTable, 0);
            ti.setData((Object)editor);
            ti.setText(editor.getLabel());
            Image image = editor.getImageDescriptor().createImage();
            ti.setImage(image);
            this.editorTable.setSelection(new TableItem[]{ti});
            this.editorTable.showSelection();
            this.editorTable.setFocus();
            this.selectedEditor = editor;
            IEditorDescriptor[] newEditors = new IEditorDescriptor[this.externalEditors.length + 1];
            System.arraycopy(this.externalEditors, 0, newEditors, 0, this.externalEditors.length);
            newEditors[newEditors.length - 1] = editor;
            this.externalEditors = newEditors;
            Image[] newImages = new Image[this.externalEditorImages.length + 1];
            System.arraycopy(this.externalEditorImages, 0, newImages, 0, this.externalEditorImages.length);
            newImages[newImages.length - 1] = image;
            this.externalEditorImages = newImages;
        }
    }

    protected void handleDoubleClickEvent() {
        this.buttonPressed(0);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        boolean wasExternal = settings.getBoolean(STORE_ID_INTERNAL_EXTERNAL);
        this.internalButton.setSelection(!wasExternal);
        this.externalButton.setSelection(wasExternal);
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_ID_INTERNAL_EXTERNAL, !this.internalButton.getSelection());
    }

    public void setMessage(String aMessage) {
        this.message = aMessage;
    }

    public void setEditorsToFilter(IEditorDescriptor[] editors) {
        this.editorsToFilter = editors;
    }

    protected void updateEnableState() {
        boolean enableExternal = this.externalButton.getSelection();
        this.browseExternalEditorsButton.setEnabled(enableExternal);
        this.updateOkButton();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(false);
    }

    protected void updateOkButton() {
        if (this.okButton == null) {
            return;
        }
        if (this.editorTable.getSelectionCount() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(this.selectedEditor != null);
    }

    protected boolean isResizable() {
        return true;
    }

    private class DialogListener
    implements Listener {
        private DialogListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 8) {
                EditorSelectionDialog.this.handleDoubleClickEvent();
                return;
            }
            if (event.widget == EditorSelectionDialog.this.externalButton) {
                EditorSelectionDialog.this.fillEditorTable();
            } else if (event.widget == EditorSelectionDialog.this.browseExternalEditorsButton) {
                EditorSelectionDialog.this.promptForExternalEditor();
            } else if (event.widget == EditorSelectionDialog.this.editorTable) {
                if (EditorSelectionDialog.this.editorTable.getSelectionIndex() != -1) {
                    EditorSelectionDialog.this.selectedEditor = (EditorDescriptor)EditorSelectionDialog.this.editorTable.getSelection()[0].getData();
                } else {
                    EditorSelectionDialog.this.selectedEditor = null;
                    EditorSelectionDialog.this.okButton.setEnabled(false);
                }
            }
            EditorSelectionDialog.this.updateEnableState();
        }
    }
}

