/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.customize;

import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public abstract class PaletteEntryFactory {
    private String label;
    private ImageDescriptor imageDescriptor;

    public PaletteEntry createNewEntry(Shell shell, PaletteEntry selected) {
        PaletteContainer parent = this.determineContainerForNewEntry(selected);
        int index = this.determineIndexForNewEntry(parent, selected);
        PaletteEntry entry = this.createNewEntry(shell);
        parent.add(index, entry);
        return entry;
    }

    protected abstract PaletteEntry createNewEntry(Shell var1);

    public boolean canCreate(PaletteEntry selected) {
        if (selected instanceof PaletteRoot) {
            return false;
        }
        PaletteContainer parent = selected instanceof PaletteContainer ? (PaletteContainer)selected : selected.getParent();
        return parent.getUserModificationPermission() == 15 && parent.acceptsType(this.determineTypeForNewEntry(selected));
    }

    protected PaletteContainer determineContainerForNewEntry(PaletteEntry selected) {
        if (selected instanceof PaletteContainer) {
            return (PaletteContainer)selected;
        }
        return selected.getParent();
    }

    protected Object determineTypeForNewEntry(PaletteEntry selected) {
        return "Palette_type_Unknown";
    }

    protected int determineIndexForNewEntry(PaletteContainer c, PaletteEntry selected) {
        return c.getChildren().indexOf(selected) + 1;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public String getLabel() {
        return this.label;
    }

    public void setImageDescriptor(ImageDescriptor imgDesc) {
        this.imageDescriptor = imgDesc;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }
}

