/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class UpdateProjectSettingsOperation
extends UIJob {
    private IMarker fBackingMarker = null;

    public UpdateProjectSettingsOperation(IMarker marker) {
        super(MarkerMessages.bind((String)MarkerMessages.UpdateProjectSettingsOperation_0, (Object)PreferenceMessages.ReportApiComponentResolutionFailureDescription));
        this.fBackingMarker = marker;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        boolean notNull;
        boolean bl = notNull = monitor != null;
        if (notNull && monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (notNull) {
            monitor.beginTask(MarkerMessages.bind((String)MarkerMessages.UpdateProjectSettingsOperation_title, (Object)PreferenceMessages.ReportApiComponentResolutionFailureDescription), 3);
        }
        try {
            IResource resource;
            IProject project;
            if (notNull) {
                monitor.worked(1);
            }
            if ((project = (resource = this.fBackingMarker.getResource()).getProject()) == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IApiComponent component = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline().getApiComponent(project.getName());
            if (component == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IEclipsePreferences inode = new ProjectScope(project).getNode("org.eclipse.pde.api.tools");
            inode.put("report_resolution_errors_api_component", "Ignore");
            try {
                inode.flush();
            }
            catch (BackingStoreException e) {
                ApiPlugin.log((Throwable)e);
            }
            if (notNull) {
                monitor.worked(1);
            }
            Util.getBuildJob((IProject[])new IProject[]{project}).schedule();
            if (notNull) {
                monitor.worked(1);
            }
        }
        finally {
            if (notNull) {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }
}

