/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.template.java.JavaDocContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.jdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.jdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.templates.AbstractTemplatesPage;

public class JavaTemplatesPage
extends AbstractTemplatesPage {
    private static final String PREFERENCE_PAGE_ID = "org.eclipse.jdt.ui.preferences.JavaTemplatePreferencePage";
    private static final TemplateStore TEMPLATE_STORE = JavaPlugin.getDefault().getTemplateStore();
    private static final IPreferenceStore PREFERENCE_STORE = JavaPlugin.getDefault().getPreferenceStore();
    private static final ContextTypeRegistry TEMPLATE_CONTEXT_REGISTRY = JavaPlugin.getDefault().getTemplateContextRegistry();
    private TemplateVariableProcessor fTemplateProcessor;
    private JavaEditor fJavaEditor;

    public JavaTemplatesPage(JavaEditor javaEditor) {
        super((ITextEditor)javaEditor, javaEditor.getViewer());
        this.fJavaEditor = javaEditor;
        this.fTemplateProcessor = new TemplateVariableProcessor();
    }

    protected void insertTemplate(Template template, IDocument document) {
        String savedText;
        if (!this.fJavaEditor.validateEditorInputState()) {
            return;
        }
        ISourceViewer contextViewer = this.fJavaEditor.getViewer();
        ITextSelection textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
        if (!this.isValidTemplate(document, template, textSelection.getOffset(), textSelection.getLength())) {
            return;
        }
        this.beginCompoundChange(contextViewer);
        try {
            savedText = document.get(textSelection.getOffset(), textSelection.getLength());
            if (savedText.length() == 0) {
                String prefix = this.getIdentifierPart(document, template, textSelection.getOffset(), textSelection.getLength());
                if (prefix.length() > 0 && !template.getName().startsWith(prefix.toString())) {
                    return;
                }
                if (prefix.length() > 0) {
                    contextViewer.setSelectedRange(textSelection.getOffset() - prefix.length(), prefix.length());
                    textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
                }
            }
            document.replace(textSelection.getOffset(), textSelection.getLength(), template.getName().substring(0, 1));
        }
        catch (BadLocationException badLocationException) {
            this.endCompoundChange(contextViewer);
            return;
        }
        Position position = new Position(textSelection.getOffset() + 1, 0);
        Region region = new Region(textSelection.getOffset() + 1, 0);
        contextViewer.getSelectionProvider().setSelection((ISelection)new TextSelection(textSelection.getOffset(), 1));
        ICompilationUnit compilationUnit = (ICompilationUnit)EditorUtility.getEditorInputJavaElement((IEditorPart)this.fJavaEditor, true);
        TemplateContextType type = this.getContextTypeRegistry().getContextType(template.getContextTypeId());
        CompilationUnitContext context = ((CompilationUnitContextType)type).createContext(document, position, compilationUnit);
        context.setVariable("selection", savedText);
        if (context.getKey().length() == 0) {
            try {
                document.replace(textSelection.getOffset(), 1, savedText);
            }
            catch (BadLocationException badLocationException) {
                this.endCompoundChange(contextViewer);
                return;
            }
        }
        TemplateProposal proposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, null);
        this.fJavaEditor.getSite().getPage().activate((IWorkbenchPart)this.fJavaEditor);
        proposal.apply((ITextViewer)this.fJavaEditor.getViewer(), ' ', 0, region.getOffset());
        this.endCompoundChange(contextViewer);
    }

    protected ContextTypeRegistry getContextTypeRegistry() {
        return TEMPLATE_CONTEXT_REGISTRY;
    }

    protected IPreferenceStore getTemplatePreferenceStore() {
        return PREFERENCE_STORE;
    }

    protected TemplateStore getTemplateStore() {
        return TEMPLATE_STORE;
    }

    protected boolean isValidTemplate(IDocument document, Template template, int offset, int length) {
        String[] contextIds = this.getContextTypeIds(document, offset);
        int i = 0;
        while (i < contextIds.length) {
            if (contextIds[i].equals(template.getContextTypeId())) {
                DocumentTemplateContext context = this.getContext(document, template, offset, length);
                return context.canEvaluate(template) || this.isTemplateAllowed(context, template);
            }
            ++i;
        }
        return false;
    }

    protected SourceViewer createPatternViewer(Composite parent) {
        Document document = new Document();
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer viewer = new JavaSourceViewer(parent, null, null, false, 768, store);
        SimpleJavaSourceViewerConfiguration configuration = new SimpleJavaSourceViewerConfiguration(tools.getColorManager(), store, null, "___java_partitioning", false);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        GridData data = new GridData(1296);
        control.setLayoutData((Object)data);
        viewer.setEditable(false);
        return viewer;
    }

    protected Image getImage(Template template) {
        String contextId = template.getContextTypeId();
        if ("swt".equals(contextId) || "swt-statements".equals(contextId) || "swt-members".equals(contextId)) {
            return JavaPluginImages.get("org.eclipse.jdt.ui.template_swt_obj.gif");
        }
        return JavaPluginImages.get("org.eclipse.jdt.ui.template_obj.gif");
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        EditTemplateDialog dialog = new EditTemplateDialog(this.getSite().getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected void updatePatternViewer(Template template) {
        if (template == null) {
            this.getPatternViewer().getDocument().set("");
            return;
        }
        String contextId = template.getContextTypeId();
        TemplateContextType type = this.getContextTypeRegistry().getContextType(contextId);
        this.fTemplateProcessor.setContextType(type);
        IDocument doc = this.getPatternViewer().getDocument();
        String start = null;
        start = "javadoc".equals(contextId) ? "/**" + doc.getLegalLineDelimiters()[0] : "";
        doc.set(String.valueOf(start) + template.getPattern());
        int startLen = start.length();
        this.getPatternViewer().setDocument(doc, startLen, doc.getLength() - startLen);
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }

    private void endCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().endCompoundChange();
        }
    }

    private void beginCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().beginCompoundChange();
        }
    }

    private boolean isTemplateAllowed(DocumentTemplateContext context, Template template) {
        try {
            if (template.getContextTypeId().equals("javadoc")) {
                int offset = context.getCompletionOffset();
                return offset > 0 && Character.isWhitespace(context.getDocument().getChar(offset - 1));
            }
            int offset = context.getCompletionOffset();
            return offset > 0 && !this.isTemplateNamePart(context.getDocument().getChar(offset - 1));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isTemplateNamePart(char ch) {
        return !Character.isWhitespace(ch) && ch != '(' && ch != ')' && ch != '{' && ch != '}' && ch != ';';
    }

    private DocumentTemplateContext getContext(IDocument document, Template template, int offset, int length) {
        CompilationUnitContext context = template.getContextTypeId().equals("javadoc") ? new JavaDocContext(this.getContextTypeRegistry().getContextType(template.getContextTypeId()), document, new Position(offset, length), (ICompilationUnit)EditorUtility.getEditorInputJavaElement((IEditorPart)this.fJavaEditor, true)) : new JavaContext(this.getContextTypeRegistry().getContextType(template.getContextTypeId()), document, new Position(offset, length), (ICompilationUnit)EditorUtility.getEditorInputJavaElement((IEditorPart)this.fJavaEditor, true));
        return context;
    }

    protected String[] getContextTypeIds(IDocument document, int offset) {
        try {
            String partition = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
            String[] ids = new String[]{"java", "java-members", "java-statements", "swt", "swt-statements", "swt-members"};
            if (partition.equals("__java_javadoc")) {
                ids = new String[]{"javadoc"};
            }
            return ids;
        }
        catch (BadLocationException badLocationException) {
            return new String[0];
        }
    }

    private String getIdentifierPart(IDocument document, Template template, int offset, int length) {
        return this.getContext(document, template, offset, length).getKey();
    }
}

