/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxFwConfigFileParser;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.generator.Activator;
import org.eclipse.equinox.internal.p2.metadata.generator.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.Generator;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.GeneratorBundleInfo;
import org.eclipse.equinox.internal.provisional.p2.metadata.generator.IGeneratorInfo;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class EclipseInstallGeneratorInfoProvider
implements IGeneratorInfo {
    private static final String FILTER_OBJECTCLASS;
    private static final String filterFwName = "(org.eclipse.equinox.frameworkhandler.framework.name=Equinox)";
    private static final String filterLauncherName = "(org.eclipse.equinox.frameworkhandler.launcher.name=Eclipse.exe)";
    private static final String frameworkAdminFillter;
    private static final String ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR = "org.eclipse.equinox.simpleconfigurator";
    private static final String ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL = "org.eclipse.equinox.simpleconfigurator.configUrl";
    private static final String ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_MANIPULATOR = "org.eclipse.equinox.simpleconfigurator.manipulator";
    private static final String ORG_ECLIPSE_EQUINOX_FRAMEWORKADMIN_EQUINOX = "org.eclipse.equinox.frameworkadmin.equinox";
    private static final String ORG_ECLIPSE_EQUINOX_P2_RECONCILER_DROPINS = "org.eclipse.equinox.p2.reconciler.dropins";
    private static final String PARAMETER_BASEURL = "org.eclipse.equinox.simpleconfigurator.baseUrl";
    private String os;
    private boolean addDefaultIUs = true;
    private boolean append = false;
    private IArtifactRepository artifactRepository;
    private File baseLocation;
    private File[] bundleLocations;
    private File configLocation;
    private ArrayList defaultIUs;
    private List otherIUs;
    private File executableLocation;
    private File featuresLocation;
    private String flavor;
    private ServiceTracker frameworkAdminTracker;
    private Manipulator manipulator;
    private IMetadataRepository metadataRepository;
    private boolean publishArtifactRepo = false;
    private boolean publishArtifacts = false;
    private String rootId;
    private String rootVersion;
    private String productFile = null;
    private String launcherConfig;
    private String versionAdvice;
    private URI siteLocation;
    private boolean reuseExistingPack200Files = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        StringBuffer stringBuffer = new StringBuffer("(objectClass=");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FILTER_OBJECTCLASS = stringBuffer.append(clazz.getName()).append(")").toString();
        frameworkAdminFillter = "(&" + FILTER_OBJECTCLASS + filterFwName + filterLauncherName + ")";
    }

    public static String getDefaultExecutableName(String providedOS) {
        String theOS = providedOS;
        if (theOS == null) {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            theOS = info.getOS();
        }
        if (theOS.equalsIgnoreCase("win32")) {
            return "eclipse.exe";
        }
        if (theOS.equalsIgnoreCase("macosx")) {
            return "Eclipse.app";
        }
        return "eclipse";
    }

    public boolean addDefaultIUs() {
        return this.addDefaultIUs;
    }

    public boolean append() {
        return this.append;
    }

    protected GeneratorBundleInfo createDefaultConfigurationBundleInfo() {
        GeneratorBundleInfo result = new GeneratorBundleInfo();
        result.setSymbolicName("defaultConfigure");
        result.setVersion("1.0.0");
        result.setStartLevel(4);
        return result;
    }

    protected GeneratorBundleInfo createDefaultUnconfigurationBundleInfo() {
        GeneratorBundleInfo result = new GeneratorBundleInfo();
        result.setSymbolicName("defaultUnconfigure");
        result.setVersion("1.0.0");
        return result;
    }

    private void createFrameworkManipulator() {
        FrameworkAdmin admin = this.getFrameworkAdmin();
        if (admin == null) {
            throw new RuntimeException("Framework admin service not found");
        }
        this.manipulator = admin.getManipulator();
        if (this.manipulator == null) {
            throw new RuntimeException("Framework manipulator not found");
        }
    }

    public static GeneratorBundleInfo createLauncher() {
        GeneratorBundleInfo result = new GeneratorBundleInfo();
        result.setSymbolicName("org.eclipse.equinox.launcher");
        result.setVersion("0.0.0");
        result.setSpecialConfigCommands("addProgramArg(programArg:-startup);addProgramArg(programArg:@artifact);");
        result.setSpecialUnconfigCommands("removeProgramArg(programArg:-startup);removeProgramArg(programArg:@artifact);");
        return result;
    }

    private Collection createLauncherBundleInfo(Set ius) {
        HashSet<GeneratorBundleInfo> result = new HashSet<GeneratorBundleInfo>();
        Collection launchers = this.getIUs(ius, "org.eclipse.equinox.launcher.");
        if (launchers.size() > 0) {
            Iterator iterator = launchers.iterator();
            while (iterator.hasNext()) {
                IInstallableUnit object = (IInstallableUnit)iterator.next();
                if (object.getId().endsWith(".source")) continue;
                GeneratorBundleInfo temp = new GeneratorBundleInfo();
                temp.setSymbolicName(object.getId());
                temp.setVersion(object.getVersion().toString());
                temp.setSpecialConfigCommands("addProgramArg(programArg:--launcher.library);addProgramArg(programArg:@artifact);");
                temp.setSpecialUnconfigCommands("removeProgramArg(programArg:--launcher.library);removeProgramArg(programArg:@artifact);");
                result.add(temp);
            }
        } else if (this.launcherConfig != null) {
            String[] config = Generator.parseConfigSpec(this.launcherConfig);
            GeneratorBundleInfo temp = new GeneratorBundleInfo();
            temp.setSymbolicName("org.eclipse.equinox.launcher." + config[1] + '.' + config[0] + '.' + config[2]);
            temp.setSpecialConfigCommands("addProgramArg(programArg:--launcher.library);addProgramArg(programArg:@artifact);");
            temp.setSpecialUnconfigCommands("removeProgramArg(programArg:--launcher.library);removeProgramArg(programArg:@artifact);");
            result.add(temp);
        }
        return result;
    }

    private GeneratorBundleInfo createSimpleConfiguratorBundleInfo() {
        GeneratorBundleInfo result = new GeneratorBundleInfo();
        result.setSymbolicName(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR);
        result.setVersion("0.0.0");
        result.setStartLevel(1);
        result.setMarkedAsStarted(true);
        return result;
    }

    private GeneratorBundleInfo createDropinsReconcilerBundleInfo() {
        GeneratorBundleInfo result = new GeneratorBundleInfo();
        result.setSymbolicName(ORG_ECLIPSE_EQUINOX_P2_RECONCILER_DROPINS);
        result.setVersion("0.0.0");
        result.setMarkedAsStarted(true);
        result.setSpecialConfigCommands("mkdir(path:${installFolder}/dropins)");
        result.setSpecialUnconfigCommands("rmdir(path:${installFolder}/dropins)");
        return result;
    }

    private void expandBundleLocations() {
        if (this.bundleLocations == null) {
            this.bundleLocations = new File[0];
            return;
        }
        ArrayList<File> result = new ArrayList<File>();
        int i = 0;
        while (i < this.bundleLocations.length) {
            File location = this.bundleLocations[i];
            if (location.isDirectory()) {
                File[] list = location.listFiles();
                int j = 0;
                while (j < list.length) {
                    result.add(list[j]);
                    ++j;
                }
            } else {
                result.add(location);
            }
            ++i;
        }
        this.bundleLocations = result.toArray(new File[result.size()]);
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public File getBaseLocation() {
        return this.baseLocation;
    }

    public File[] getBundleLocations() {
        return this.bundleLocations;
    }

    public ConfigData getConfigData() {
        return this.manipulator == null ? null : this.manipulator.getConfigData();
    }

    public ConfigData loadConfigData(File location) {
        if (this.manipulator == null) {
            return null;
        }
        EquinoxFwConfigFileParser parser = new EquinoxFwConfigFileParser(Activator.getContext());
        try {
            parser.readFwConfig(this.manipulator, location);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ConfigData data = this.manipulator.getConfigData();
        String value = data.getProperty(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL);
        if (value != null) {
            try {
                BundleInfo[] bundleInfos = EclipseInstallGeneratorInfoProvider.readConfiguration(new URL(value));
                data.setBundles(bundleInfos);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
            try {
                data.setProperty(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL, EquinoxManipulatorImpl.makeRelative((String)value, (URL)this.configLocation.toURL()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return data;
    }

    public static BundleInfo[] readConfiguration(URL url) throws IOException {
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                URL baseUrl = new URL(url, "./");
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
                    if (line.startsWith("org.eclipse.equinox.simpleconfigurator.baseUrl=")) {
                        String baseUrlSt = line.substring("org.eclipse.equinox.simpleconfigurator.baseUrl=".length());
                        if (!baseUrlSt.endsWith("/")) {
                            baseUrlSt = String.valueOf(baseUrlSt) + "/";
                        }
                        baseUrl = new URL(url, baseUrlSt);
                        continue;
                    }
                    StringTokenizer tok = new StringTokenizer(line, ",", true);
                    String symbolicName = tok.nextToken();
                    if (symbolicName.equals(",")) {
                        symbolicName = null;
                    } else {
                        tok.nextToken();
                    }
                    String version = tok.nextToken();
                    if (version.equals(",")) {
                        version = null;
                    } else {
                        tok.nextToken();
                    }
                    String urlSt = tok.nextToken();
                    if (urlSt.equals(",")) {
                        urlSt = symbolicName != null && version != null ? String.valueOf(symbolicName) + "_" + version + ".jar" : null;
                    } else {
                        tok.nextToken();
                    }
                    try {
                        new URL(urlSt);
                    }
                    catch (MalformedURLException malformedURLException) {
                        urlSt = Utils.getUrlInFull((String)urlSt, (URL)baseUrl).toExternalForm();
                    }
                    int sl = Integer.parseInt(tok.nextToken().trim());
                    tok.nextToken();
                    boolean markedAsStarted = Boolean.valueOf(tok.nextToken());
                    try {
                        BundleInfo bInfo = new BundleInfo(symbolicName, version, new URI(urlSt), sl, markedAsStarted);
                        bundles.add(bInfo);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        throw new IllegalStateException("Error coverting url based string to uri: " + e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException malformedURLException) {}
        return bundles.toArray(new BundleInfo[bundles.size()]);
    }

    public ArrayList getDefaultIUs(Set ius) {
        if (this.defaultIUs != null) {
            return this.defaultIUs;
        }
        this.defaultIUs = new ArrayList(5);
        if (this.addDefaultIUs) {
            this.defaultIUs.addAll(this.createLauncherBundleInfo(ius));
            this.defaultIUs.add(EclipseInstallGeneratorInfoProvider.createLauncher());
            this.defaultIUs.add(this.createSimpleConfiguratorBundleInfo());
            this.defaultIUs.add(this.createDropinsReconcilerBundleInfo());
        }
        return this.defaultIUs;
    }

    public Collection getOtherIUs() {
        if (this.otherIUs != null) {
            return this.otherIUs;
        }
        this.otherIUs = new ArrayList();
        this.otherIUs.add(this.createDropinsReconcilerBundleInfo());
        return this.otherIUs;
    }

    public File getExecutableLocation() {
        return this.executableLocation;
    }

    public File getFeaturesLocation() {
        return this.featuresLocation;
    }

    public String getFlavor() {
        return this.flavor == null ? "tooling" : this.flavor;
    }

    private FrameworkAdmin getFrameworkAdmin() {
        FrameworkAdmin admin;
        if (this.frameworkAdminTracker == null) {
            try {
                Filter filter = Activator.getContext().createFilter(frameworkAdminFillter);
                this.frameworkAdminTracker = new ServiceTracker(Activator.getContext(), filter, null);
                this.frameworkAdminTracker.open();
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
        if ((admin = (FrameworkAdmin)this.frameworkAdminTracker.getService()) == null) {
            this.startBundle(ORG_ECLIPSE_EQUINOX_FRAMEWORKADMIN_EQUINOX);
            this.startBundle(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_MANIPULATOR);
            admin = (FrameworkAdmin)this.frameworkAdminTracker.getService();
        }
        return admin;
    }

    private Collection getIUs(Set ius, String prefix) {
        HashSet<IInstallableUnit> result = new HashSet<IInstallableUnit>();
        Iterator iterator = ius.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit tmp = (IInstallableUnit)iterator.next();
            if (!tmp.getId().startsWith(prefix)) continue;
            result.add(tmp);
        }
        return result;
    }

    public File getJRELocation() {
        if (this.executableLocation == null) {
            return null;
        }
        return new File(this.executableLocation.getParentFile(), "jre");
    }

    public String getLauncherConfig() {
        return this.launcherConfig;
    }

    public LauncherData getLauncherData() {
        return this.manipulator == null ? null : this.manipulator.getLauncherData();
    }

    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public String getRootId() {
        return this.rootId;
    }

    public String getRootVersion() {
        if (this.rootVersion == null || this.rootVersion.length() == 0) {
            return "0.0.0";
        }
        return this.rootVersion;
    }

    public String getProductFile() {
        return this.productFile;
    }

    public URI getSiteLocation() {
        return this.siteLocation;
    }

    public void initialize(File base) {
        File[] fileArray;
        if (this.bundleLocations == null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = new File(base, "plugins");
        } else {
            fileArray = this.bundleLocations;
        }
        File[] bundles = fileArray;
        File features = this.featuresLocation == null ? new File(base, "features") : this.featuresLocation;
        File executable = this.executableLocation == null ? new File(base, EclipseInstallGeneratorInfoProvider.getDefaultExecutableName(this.os)) : this.executableLocation;
        File configuration = this.configLocation == null ? new File(base, "configuration") : this.configLocation;
        this.initialize(base, configuration, executable, bundles, features);
    }

    public void initialize(File base, File config, File executable, File[] bundles, File features) {
        if (base == null || !base.exists()) {
            throw new RuntimeException(NLS.bind((String)Messages.exception_sourceDirectoryInvalid, (Object)(base == null ? "null" : base.getAbsolutePath())));
        }
        this.baseLocation = base;
        if (config == null || config.exists()) {
            this.configLocation = config;
        }
        if (executable == null || executable.exists()) {
            this.executableLocation = executable;
        }
        if (bundles != null) {
            this.bundleLocations = bundles;
        }
        if (features != null) {
            this.featuresLocation = features;
        }
        this.expandBundleLocations();
        if (this.configLocation == null || this.executableLocation == null) {
            return;
        }
        this.createFrameworkManipulator();
        LauncherData launcherData = this.manipulator.getLauncherData();
        launcherData.setFwPersistentDataLocation(this.configLocation, true);
        launcherData.setLauncher(this.executableLocation);
        try {
            this.manipulator.load();
        }
        catch (IllegalStateException e2) {
            e2.printStackTrace();
        }
        catch (FrameworkAdminRuntimeException e2) {
            e2.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public boolean publishArtifactRepository() {
        return this.publishArtifactRepo;
    }

    public boolean publishArtifacts() {
        return this.publishArtifacts;
    }

    public boolean reuseExistingPack200Files() {
        return this.reuseExistingPack200Files;
    }

    public void reuseExistingPack200Files(boolean publishPack) {
        this.reuseExistingPack200Files = publishPack;
    }

    public void setAddDefaultIUs(boolean value) {
        this.addDefaultIUs = value;
    }

    public void setAppend(boolean value) {
        this.append = value;
    }

    public void setArtifactRepository(IArtifactRepository value) {
        this.artifactRepository = value;
    }

    public void setExecutableLocation(String value) {
        this.executableLocation = new File(value);
    }

    public void setFlavor(String value) {
        this.flavor = value;
    }

    public void setLauncherConfig(String value) {
        this.launcherConfig = value;
    }

    public void setMappingRules(String[][] value) {
    }

    public void setMetadataRepository(IMetadataRepository value) {
        this.metadataRepository = value;
    }

    public void setOS(String os) {
        this.os = os;
    }

    public void setPublishArtifactRepository(boolean value) {
        this.publishArtifactRepo = value;
    }

    public void setPublishArtifacts(boolean value) {
        this.publishArtifacts = value;
    }

    public void setRootId(String value) {
        this.rootId = value;
    }

    public void setRootVersion(String value) {
        this.rootVersion = value;
    }

    public void setProductFile(String file) {
        this.productFile = file;
    }

    public void setSiteLocation(URI location) {
        this.siteLocation = location;
    }

    private boolean startBundle(String bundleId) {
        PackageAdmin packageAdmin;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleId, null);
        if (bundles != null && bundles.length > 0) {
            int i = 0;
            while (i < bundles.length) {
                try {
                    if ((bundles[0].getState() & 4) > 0) {
                        bundles[0].start();
                        return true;
                    }
                }
                catch (BundleException bundleException) {}
                ++i;
            }
        }
        return false;
    }

    public String getVersionAdvice() {
        return this.versionAdvice;
    }

    public void setVersionAdvice(String advice) {
        this.versionAdvice = advice;
    }
}

