/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.comment;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.jdt.internal.formatter.comment.CommentLine;
import org.eclipse.jdt.internal.formatter.comment.CommentRange;
import org.eclipse.jdt.internal.formatter.comment.CommentRegion;
import org.eclipse.jdt.internal.formatter.comment.IJavaDocTagConstants;
import org.eclipse.jdt.internal.formatter.comment.MultiCommentLine;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class MultiCommentRegion
extends CommentRegion
implements IJavaDocTagConstants {
    private final boolean fIndentDescriptions;
    private final boolean fIndentRoots;
    private final boolean fParameterNewLine;
    private boolean fSeparateRoots;

    public MultiCommentRegion(IDocument document, Position position, CodeFormatterVisitor formatter) {
        super(document, position, formatter);
        this.fIndentRoots = this.preferences.comment_indent_root_tags;
        this.fIndentDescriptions = this.preferences.comment_indent_parameter_description;
        this.fSeparateRoots = this.preferences.comment_insert_empty_line_before_root_tags;
        this.fParameterNewLine = this.preferences.comment_insert_new_line_for_parameter;
        this.fClear = this.preferences.comment_clear_blank_lines_in_block_comment;
    }

    protected boolean canAppend(CommentLine line, CommentRange previous, CommentRange next, int index, int count) {
        boolean blank = next.hasAttribute(2);
        if (next.getLength() <= 2 && !blank && this.isNonAlphaNumeric(next)) {
            return true;
        }
        if (this.fParameterNewLine && line.hasAttribute(1024) && line.getSize() > 1) {
            return false;
        }
        if (previous != null) {
            if (index != 0 && (blank || previous.hasAttribute(2) || next.hasAttribute(1024) || next.hasAttribute(2048) || next.hasAttribute(4096) || next.hasAttribute(128) || previous.hasAttribute(4) || previous.hasAttribute(4096))) {
                return false;
            }
            if (previous.hasAttribute(2048)) {
                return true;
            }
            if (next.hasAttribute(64) && previous.hasAttribute(64)) {
                return true;
            }
        }
        if (!next.hasAttribute(16384)) {
            return true;
        }
        if (this.fIndentRoots && !line.hasAttribute(2048) && !line.hasAttribute(1024)) {
            count -= this.stringToLength(line.getIndentationReference());
        }
        if (next.hasAttribute(64) && (previous == null || !previous.hasAttribute(64))) {
            Iterator iter = this.getRanges().iterator();
            CommentRange current = null;
            while (iter.hasNext() && current != next) {
                current = (CommentRange)iter.next();
            }
            if (current != null && iter.hasNext()) {
                try {
                    int lineNumber = this.getDocument().getLineOfOffset(this.getOffset() + current.getOffset());
                    CommentRange last = current;
                    while (iter.hasNext()) {
                        current = (CommentRange)iter.next();
                        if (!current.hasAttribute(64) || this.getDocument().getLineOfOffset(this.getOffset() + current.getOffset()) != lineNumber) break;
                        last = current;
                    }
                    count -= last.getOffset() + last.getLength() - (next.getOffset() + next.getLength());
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return super.canAppend(line, previous, next, index, count);
    }

    protected String getDelimiter(CommentLine predecessor, CommentLine successor, CommentRange previous, CommentRange next, String indentation) {
        String delimiter = super.getDelimiter(predecessor, successor, previous, next, indentation);
        if (previous != null) {
            if (previous.hasAttribute(4160) && !next.hasAttribute(16) && !successor.hasAttribute(2)) {
                return String.valueOf(delimiter) + delimiter;
            }
            if (next.hasAttribute(4160) && !successor.hasAttribute(2) && !predecessor.hasAttribute(2)) {
                return String.valueOf(delimiter) + delimiter;
            }
            if (this.fSeparateRoots && previous.hasAttribute(512) && !successor.hasAttribute(2) && !predecessor.hasAttribute(2)) {
                return String.valueOf(delimiter) + delimiter;
            }
            if (this.fIndentRoots && !predecessor.hasAttribute(2048) && !predecessor.hasAttribute(1024) && !predecessor.hasAttribute(2)) {
                return String.valueOf(delimiter) + this.stringToIndent(predecessor.getIndentationReference());
            }
        }
        return delimiter;
    }

    protected String getDelimiter(CommentRange previous, CommentRange next) {
        if (previous != null && !previous.hasAttribute(16384)) {
            return "";
        }
        return super.getDelimiter(previous, next);
    }

    protected final boolean isIndentDescriptions() {
        return this.fIndentDescriptions;
    }

    protected final boolean isIndentRoots() {
        return this.fIndentRoots;
    }

    protected void markHtmlRanges() {
    }

    protected void markHtmlTag(CommentRange range, char[] token) {
    }

    protected void markJavadocTag(CommentRange range, char[] token) {
        range.markPrefixTag(COMMENT_ROOT_TAGS, '@', token, 2048);
    }

    protected void markRegion() {
        int count = 0;
        boolean paragraph = false;
        char[] token = null;
        CommentRange range = null;
        ListIterator iterator = this.getRanges().listIterator();
        while (iterator.hasNext()) {
            range = (CommentRange)iterator.next();
            count = range.getLength();
            if (count <= 0) continue;
            token = this.getText(range.getOffset(), count).toLowerCase().toCharArray();
            this.markJavadocTag(range, token);
            if (!paragraph && (range.hasAttribute(2048) || range.hasAttribute(1024))) {
                range.setAttribute(512);
                paragraph = true;
            }
            this.markHtmlTag(range, token);
        }
        this.markHtmlRanges();
    }

    protected CommentLine createLine() {
        return new MultiCommentLine(this);
    }
}

