/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.swt;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.xwt.vex.swt.Win32ImageCapture;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class ImageCapture {
    static ImageCapture instance;

    public Image captureImage(Control control) {
        Rectangle rectangle = control.getBounds();
        Display display = control.getDisplay();
        Image image = null;
        if (control instanceof Shell) {
            Shell shell = (Shell)control;
            shell.layout();
            Point parentLocation = control.toDisplay(0, 0);
            image = this.getImage(control, rectangle.width, rectangle.height, false);
            rectangle.x = parentLocation.x;
            rectangle.y = parentLocation.y;
            GC myImageGC = new GC((Drawable)image);
            try {
                Control[] controlArray = shell.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    Rectangle childBounds = child.getBounds();
                    int x = (rectangle.width - childBounds.width) / 2;
                    int y = rectangle.height - childBounds.height - x;
                    childBounds.x = rectangle.x + x;
                    childBounds.y = rectangle.y + y;
                    if (rectangle.intersects(childBounds)) {
                        Image childImage = new Image((Device)display, child.getBounds());
                        GC gc = new GC((Drawable)childImage);
                        child.print(gc);
                        gc.dispose();
                        try {
                            myImageGC.drawImage(childImage, x, y);
                        }
                        finally {
                            childImage.dispose();
                        }
                    }
                    ++n2;
                }
            }
            finally {
                myImageGC.dispose();
            }
        }
        image = this.defaultCapture(control);
        return image;
    }

    public Image defaultCapture(Control control) {
        Image image = new Image((Device)control.getDisplay(), control.getBounds());
        GC gc = new GC((Drawable)image);
        try {
            if (control.print(gc)) {
                Image image2 = image;
                return image2;
            }
            image.dispose();
            Rectangle bounds = control.getBounds();
            Image image3 = this.getImage(control, bounds.width, bounds.height, true);
            return image3;
        }
        finally {
            gc.dispose();
        }
    }

    protected abstract Image getImage(Control var1, int var2, int var3, boolean var4);

    public static ImageCapture getImageCapture() {
        if (instance == null) {
            if ("win32".equals(Platform.getOS())) {
                instance = new Win32ImageCapture();
            } else if ("gtk".equals(Platform.getWS())) {
                instance = "ia64".equals(Platform.getOSArch()) || "x86_64".equals(Platform.getOSArch()) ? new org.eclipse.ve.internal.swt.targetvm.unix.bits64.ImageCapture() : new org.eclipse.ve.internal.swt.targetvm.unix.ImageCapture();
            } else if ("macosx".equals(Platform.getOS())) {
                instance = new org.eclipse.ve.internal.swt.targetvm.macosx.ImageCapture();
            } else {
                throw new UnsupportedOperationException(Platform.getOS());
            }
        }
        return instance;
    }

    public static int getIntHandle(Control control) {
        try {
            Field handleField = control.getClass().getField("handle");
            handleField.setAccessible(true);
            return (Integer)handleField.get(control);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return -1;
    }
}

