/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.build.BuildContentsSection;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.swt.widgets.Composite;

public class SrcSection
extends BuildContentsSection
implements IModelChangedListener {
    public SrcSection(BuildPage page, Composite parent) {
        super(page, parent);
        this.getSection().setText(PDEUIMessages.BuildEditor_SrcSection_title);
        this.getSection().setDescription(PDEUIMessages.BuildEditor_SrcSection_desc);
    }

    protected void initializeCheckState() {
        super.initializeCheckState();
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry srcIncl = build.getEntry("src.includes");
        IBuildEntry srcExcl = build.getEntry("src.excludes");
        if (srcIncl == null) {
            return;
        }
        super.initializeCheckState(srcIncl, srcExcl);
    }

    protected void deleteFolderChildrenFromEntries(IFolder folder) {
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry srcIncl = build.getEntry("src.includes");
        IBuildEntry srcExcl = build.getEntry("src.excludes");
        String parentFolder = this.getResourceFolderName(folder.getProjectRelativePath().toString());
        this.removeChildren(srcIncl, parentFolder);
        this.removeChildren(srcExcl, parentFolder);
    }

    protected void handleBuildCheckStateChange(boolean wasTopParentChecked) {
        IResource resource = this.fParentResource;
        String resourceName = this.fParentResource.getFullPath().removeFirstSegments(1).toString();
        IBuild build = this.fBuildModel.getBuild();
        IBuildEntry includes = build.getEntry("src.includes");
        IBuildEntry excludes = build.getEntry("src.excludes");
        resourceName = this.handleResourceFolder(resource, resourceName);
        if (this.isChecked) {
            this.handleCheck(includes, excludes, resourceName, resource, wasTopParentChecked, "src.includes");
        } else {
            this.handleUncheck(includes, excludes, resourceName, resource, "src.excludes");
        }
        this.deleteEmptyEntries();
    }
}

