/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist.display;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.contentassist.display.HTML2TextReader;
import org.eclipse.pde.internal.ui.editor.text.HTMLPrinter;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class BrowserInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
DisposeListener {
    private static final int BORDER = 1;
    private static final int MIN_WIDTH = 80;
    private static final int MIN_HEIGHT = 80;
    private static boolean fgIsAvailable = false;
    private static boolean fgAvailabilityChecked = false;
    private Shell fShell;
    private Browser fBrowser;
    private boolean fBrowserHasContent;
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;
    private Font fStatusTextFont;
    private Label fStatusTextField;
    private String fStatusFieldText;
    private boolean fHideScrollBars;
    private Listener fDeactivateListener;
    private ListenerList fFocusListeners = new ListenerList();
    private Label fSeparator;
    private String fInputText;
    private TextLayout fTextLayout;
    private TextStyle fBoldStyle;

    public static boolean isAvailable(Composite parent) {
        if (!fgAvailabilityChecked) {
            try {
                if (parent == null) {
                    parent = PDEPlugin.getActiveWorkbenchShell();
                }
                if (parent == null) {
                    return false;
                }
                try {
                    Browser browser = new Browser(parent, 0);
                    browser.dispose();
                    fgIsAvailable = true;
                }
                catch (SWTError sWTError) {
                    fgIsAvailable = false;
                }
            }
            finally {
                fgAvailabilityChecked = true;
            }
        }
        return fgIsAvailable;
    }

    public BrowserInformationControl(Shell parent, int shellStyle, int style) {
        this(parent, shellStyle, style, null);
    }

    public BrowserInformationControl(Shell parent, int shellStyle, int style, String statusFieldText) {
        GridData gd;
        int border;
        this.fStatusFieldText = statusFieldText;
        this.fShell = new Shell(parent, 0x84000 | shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.fTextLayout = new TextLayout((Device)display);
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = border = (shellStyle & 8) == 0 ? 0 : 1;
        layout.marginWidth = border;
        composite.setLayout((Layout)layout);
        if (statusFieldText != null) {
            composite = new Composite((Composite)composite, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 1;
            layout.horizontalSpacing = 1;
            composite.setLayout((Layout)layout);
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            composite.setForeground(display.getSystemColor(28));
            composite.setBackground(display.getSystemColor(29));
        }
        this.fBrowser = new Browser((Composite)composite, 0);
        this.fBrowser.setJavascriptEnabled(false);
        this.fHideScrollBars = (style & 0x200) == 0 && (style & 0x100) == 0;
        gd = new GridData(1809);
        this.fBrowser.setLayoutData((Object)gd);
        this.fBrowser.setForeground(display.getSystemColor(28));
        this.fBrowser.setBackground(display.getSystemColor(29));
        this.fBrowser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    BrowserInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fBrowser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (!"about:blank".equals(location)) {
                    event.doit = false;
                }
            }
        });
        this.fBrowser.setMenu(new Menu((Decorations)this.fShell, 0));
        if (statusFieldText != null) {
            this.fSeparator = new Label((Composite)composite, 259);
            this.fSeparator.setLayoutData((Object)new GridData(768));
            this.fStatusTextField = new Label((Composite)composite, 131072);
            this.fStatusTextField.setText(statusFieldText);
            Font font = this.fStatusTextField.getFont();
            FontData[] fontDatas = font.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
                ++i;
            }
            this.fStatusTextFont = new Font((Device)this.fStatusTextField.getDisplay(), fontDatas);
            this.fStatusTextField.setFont(this.fStatusTextFont);
            gd = new GridData(802);
            this.fStatusTextField.setLayoutData((Object)gd);
            this.fStatusTextField.setForeground(display.getSystemColor(17));
            this.fStatusTextField.setBackground(display.getSystemColor(29));
        }
        this.addDisposeListener(this);
        this.createTextLayout();
    }

    public BrowserInformationControl(Shell parent, int style) {
        this(parent, 12, style);
    }

    public BrowserInformationControl(Shell parent) {
        this(parent, 0);
    }

    public void setInformation(String content) {
        boolean bl = this.fBrowserHasContent = content != null && content.length() > 0;
        if (!this.fBrowserHasContent) {
            content = "<html><body ></html>";
        }
        this.fInputText = content;
        int shellStyle = this.fShell.getStyle();
        boolean RTL = (shellStyle & 0x4000000) != 0;
        String[] styles = null;
        if (RTL && !this.fHideScrollBars) {
            styles = new String[]{"direction:rtl;", "word-wrap:break-word;"};
        } else if (RTL && this.fHideScrollBars) {
            styles = new String[]{"direction:rtl;", "overflow:hidden;", "word-wrap:break-word;"};
        } else if (this.fHideScrollBars) {
            styles = new String[]{"overflow:hidden;", "word-wrap: break-word;"};
        }
        if (styles != null) {
            StringBuffer buffer = new StringBuffer(content);
            HTMLPrinter.insertStyles(buffer, styles);
            content = buffer.toString();
        }
        this.fBrowser.setText(content);
    }

    public void setStatusText(String statusFieldText) {
        this.fStatusFieldText = statusFieldText;
    }

    public void setVisible(boolean visible) {
        if (this.fShell.isVisible() == visible) {
            return;
        }
        if (visible && this.fStatusTextField != null) {
            boolean state;
            boolean bl = state = this.fStatusFieldText != null;
            if (state) {
                this.fStatusTextField.setText(this.fStatusFieldText);
            }
            this.fStatusTextField.setVisible(state);
            this.fSeparator.setVisible(state);
        }
        this.fShell.setVisible(visible);
        if (!visible) {
            this.setInformation("");
        }
    }

    private void createTextLayout() {
        this.fTextLayout = new TextLayout((Device)this.fBrowser.getDisplay());
        Font font = this.fBrowser.getFont();
        this.fTextLayout.setFont(font);
        this.fTextLayout.setWidth(-1);
        FontData[] fontData = font.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(1);
            ++i;
        }
        font = new Font((Device)this.fShell.getDisplay(), fontData);
        this.fBoldStyle = new TextStyle(font, null, null);
        this.fTextLayout.setText("    ");
        int tabWidth = this.fTextLayout.getBounds().width;
        this.fTextLayout.setTabs(new int[]{tabWidth});
        this.fTextLayout.setText("");
    }

    public void dispose() {
        this.fTextLayout.dispose();
        this.fTextLayout = null;
        this.fBoldStyle.font.dispose();
        this.fBoldStyle = null;
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fShell = null;
        this.fBrowser = null;
        this.fStatusTextFont = null;
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(Math.min(width, this.fMaxWidth), Math.min(height, this.fMaxHeight));
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        String text;
        TextPresentation presentation = new TextPresentation();
        HTML2TextReader reader = new HTML2TextReader(new StringReader(this.fInputText), presentation);
        try {
            text = reader.getString();
        }
        catch (IOException iOException) {
            text = "";
        }
        this.fTextLayout.setText(text);
        Iterator iter = presentation.getAllStyleRangeIterator();
        while (iter.hasNext()) {
            StyleRange sr = (StyleRange)iter.next();
            if (sr.fontStyle != 1) continue;
            this.fTextLayout.setStyle(this.fBoldStyle, sr.start, sr.start + sr.length - 1);
        }
        Rectangle bounds = this.fTextLayout.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        width += 15;
        height += 25;
        if (this.fStatusFieldText != null && this.fSeparator != null) {
            this.fTextLayout.setText(this.fStatusFieldText);
            Rectangle statusBounds = this.fTextLayout.getBounds();
            Rectangle separatorBounds = this.fSeparator.getBounds();
            width = Math.max(width, statusBounds.width);
            height = height + statusBounds.height + separatorBounds.height;
        }
        if (this.fMaxWidth != -1) {
            width = Math.min(this.fMaxWidth, width);
        }
        if (this.fMaxHeight != -1) {
            height = Math.min(this.fMaxHeight, height);
        }
        width = Math.max(80, width);
        height = Math.max(80, height);
        return new Point(width, height);
    }

    public Rectangle computeTrim() {
        return this.fShell.computeTrim(0, 0, 0, 0);
    }

    public Rectangle getBounds() {
        return this.fShell.getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fBrowser.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fBrowser.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fBrowser.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fBrowser.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fBrowser.addFocusListener(listener);
        if (this.fFocusListeners.isEmpty()) {
            this.fDeactivateListener = new Listener(){

                public void handleEvent(Event event) {
                    Object[] listeners = BrowserInformationControl.this.fFocusListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((FocusListener)listeners[i]).focusLost(new FocusEvent(event));
                        ++i;
                    }
                }
            };
            this.fBrowser.getShell().addListener(27, this.fDeactivateListener);
        }
        this.fFocusListeners.add((Object)listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fBrowser.removeFocusListener(listener);
        this.fFocusListeners.remove((Object)listener);
        if (this.fFocusListeners.isEmpty()) {
            this.fBrowser.getShell().removeListener(27, this.fDeactivateListener);
            this.fDeactivateListener = null;
        }
    }

    public boolean hasContents() {
        return this.fBrowserHasContent;
    }
}

