/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleTextChangeListener;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.FragmentHostHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.ui.refactoring.BundleManifestChange;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class CreateHeaderChangeOperation
implements IWorkspaceRunnable {
    private IPluginModelBase fBase;
    private String fHeaderKey;
    private String fOldValue;
    private String fNewValue;
    private TextFileChange fChange;

    public CreateHeaderChangeOperation(IPluginModelBase base, String headerKey, String oldValue, String newValue) {
        this.fBase = base;
        this.fHeaderKey = headerKey;
        this.fOldValue = oldValue;
        this.fNewValue = newValue;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            IResource res = this.fBase.getUnderlyingResource();
            if (res == null) {
                return;
            }
            IProject proj = res.getProject();
            IFile file = proj.getFile("META-INF/MANIFEST.MF");
            if (file.exists()) {
                this.fChange = this.updateBundleHeader(file, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    public TextFileChange getChange() {
        return this.fChange;
    }

    protected TextFileChange updateBundleHeader(IFile manifest, IProgressMonitor monitor) throws CoreException {
        block21: {
            monitor.beginTask("", 2);
            try {
                BundleTextChangeListener listener;
                Bundle bundle = BundleManifestChange.getBundle(manifest, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (bundle == null || (listener = this.createListener((IBundle)bundle)) == null) break block21;
                IManifestHeader mHeader = bundle.getManifestHeader(this.fHeaderKey);
                if (mHeader instanceof BundleSymbolicNameHeader) {
                    ((BundleSymbolicNameHeader)mHeader).setId(this.fNewValue);
                } else if (mHeader instanceof RequireBundleHeader) {
                    RequireBundleHeader header = (RequireBundleHeader)mHeader;
                    RequireBundleObject[] bundles = header.getRequiredBundles();
                    int i = 0;
                    while (i < bundles.length) {
                        if (bundles[i].getId().equals(this.fOldValue)) {
                            bundles[i].setId(this.fNewValue);
                        }
                        ++i;
                    }
                } else if (mHeader instanceof FragmentHostHeader) {
                    ((FragmentHostHeader)mHeader).setHostId(this.fNewValue);
                } else if (mHeader instanceof ExportPackageHeader) {
                    ExportPackageObject[] packages = ((ExportPackageHeader)mHeader).getPackages();
                    int i = 0;
                    while (i < packages.length) {
                        PackageFriend[] friends = packages[i].getFriends();
                        int j = 0;
                        while (j < friends.length) {
                            if (friends[j].getName().equals(this.fOldValue)) {
                                packages[i].removeFriend(friends[j]);
                                packages[i].addFriend(new PackageFriend((PackageObject)packages[i], this.fNewValue));
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                TextFileChange textFileChange = this.getTextChange(listener, manifest);
                return textFileChange;
            }
            catch (MalformedTreeException malformedTreeException) {
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                FileBuffers.getTextFileBufferManager().disconnect(manifest.getFullPath(), LocationKind.NORMALIZE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.done();
            }
        }
        return null;
    }

    private BundleTextChangeListener createListener(IBundle bundle) {
        if (bundle != null) {
            BundleTextChangeListener listener = new BundleTextChangeListener(((BundleModel)bundle.getModel()).getDocument());
            bundle.getModel().addModelChangedListener((IModelChangedListener)listener);
            return listener;
        }
        return null;
    }

    private TextFileChange getTextChange(BundleTextChangeListener listener, IFile manifest) {
        TextEdit[] edits = listener.getTextOperations();
        if (edits.length == 0) {
            return null;
        }
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChildren(edits);
        TextFileChange change = new TextFileChange("", manifest);
        change.setEdit((TextEdit)edit);
        PDEModelUtility.setChangeTextType(change, manifest);
        return change;
    }
}

