/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportTab;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.ProductExportWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ProductDestinationGroup
extends AbstractExportTab {
    protected static final String S_EXPORT_DIRECTORY = "exportDirectory";
    protected static final String S_DESTINATION = "destination";
    protected static final String S_ZIP_FILENAME = "zipFileName";
    protected static String ZIP_EXTENSION = ".zip";
    protected Button fArchiveFileButton;
    protected Combo fArchiveCombo;
    protected Button fBrowseFile;
    protected Button fDirectoryButton;
    protected Combo fDirectoryCombo;
    protected Button fBrowseDirectory;

    public ProductDestinationGroup(AbstractExportWizardPage page) {
        super(page);
    }

    public Control createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.ExportWizard_destination);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        this.fDirectoryButton = new Button((Composite)group, 16);
        this.fDirectoryButton.setText(PDEUIMessages.ExportWizard_directory);
        this.fDirectoryCombo = new Combo((Composite)group, 2048);
        this.fDirectoryCombo.setLayoutData((Object)new GridData(768));
        this.fBrowseDirectory = new Button((Composite)group, 8);
        this.fBrowseDirectory.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseDirectory.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseDirectory);
        this.fArchiveFileButton = new Button((Composite)group, 16);
        this.fArchiveFileButton.setText(PDEUIMessages.ExportWizard_archive);
        this.fArchiveCombo = new Combo((Composite)group, 2048);
        this.fArchiveCombo.setLayoutData((Object)new GridData(768));
        this.fBrowseFile = new Button((Composite)group, 8);
        this.fBrowseFile.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseFile.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseFile);
        return group;
    }

    protected void initialize(IDialogSettings settings) {
        this.initialize(settings, null);
    }

    protected void initialize(IDialogSettings settings, IFile file) {
        try {
            String toDirectory;
            String string = toDirectory = file != null ? file.getPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_DIR) : null;
            if (toDirectory == null) {
                toDirectory = settings.get(S_EXPORT_DIRECTORY);
            }
            boolean useDirectory = toDirectory == null || "true".equals(toDirectory);
            this.fDirectoryButton.setSelection(useDirectory);
            this.fArchiveFileButton.setSelection(!useDirectory);
            this.toggleDestinationGroup(useDirectory);
            this.initializeCombo(settings, S_DESTINATION, this.fDirectoryCombo);
            this.initializeCombo(settings, S_ZIP_FILENAME, this.fArchiveCombo);
            this.updateDestination(file);
            this.hookListeners();
        }
        catch (CoreException coreException) {}
    }

    protected void initializeCombo(IDialogSettings settings, String key, Combo combo) {
        super.initializeCombo(settings, key, combo);
        if (!this.isValidLocation(combo.getText().trim())) {
            combo.setText("");
        }
    }

    protected void updateDestination(IFile file) {
        try {
            if (file == null) {
                return;
            }
            String toDirectory = file.getPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_DIR);
            if (toDirectory == null) {
                return;
            }
            boolean useDirectory = "true".equals(toDirectory);
            this.fArchiveFileButton.setSelection(!useDirectory);
            this.fDirectoryButton.setSelection(useDirectory);
            this.toggleDestinationGroup(useDirectory);
            Combo combo = useDirectory ? this.fDirectoryCombo : this.fArchiveCombo;
            String destination = file.getPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_LOCATION);
            if (destination != null) {
                if (combo.indexOf(destination) == -1) {
                    combo.add(destination, 0);
                }
                combo.setText(destination);
            }
        }
        catch (CoreException coreException) {}
    }

    protected void toggleDestinationGroup(boolean useDirectory) {
        this.fArchiveCombo.setEnabled(!useDirectory);
        this.fBrowseFile.setEnabled(!useDirectory);
        this.fDirectoryCombo.setEnabled(useDirectory);
        this.fBrowseDirectory.setEnabled(useDirectory);
    }

    protected void hookListeners() {
        this.fArchiveFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductDestinationGroup.this.toggleDestinationGroup(!ProductDestinationGroup.this.fArchiveFileButton.getSelection());
                ProductDestinationGroup.this.fPage.pageChanged();
            }
        });
        this.fBrowseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductDestinationGroup.this.chooseFile(ProductDestinationGroup.this.fArchiveCombo, "*" + ZIP_EXTENSION);
            }
        });
        this.fArchiveCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProductDestinationGroup.this.fPage.pageChanged();
            }
        });
        this.fDirectoryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProductDestinationGroup.this.fPage.pageChanged();
            }
        });
        this.fBrowseDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductDestinationGroup.this.chooseDestination();
            }
        });
    }

    protected void saveSettings(IDialogSettings settings) {
        settings.put(S_EXPORT_DIRECTORY, this.fDirectoryButton.getSelection());
        this.saveCombo(settings, S_DESTINATION, this.fDirectoryCombo);
        this.saveCombo(settings, S_ZIP_FILENAME, this.fArchiveCombo);
        IFile file = ((ProductExportWizardPage)this.fPage).getProductFile();
        try {
            if (file != null && file.exists()) {
                file.setPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_DIR, Boolean.toString(this.doExportToDirectory()));
                file.setPersistentProperty(IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_LOCATION, this.doExportToDirectory() ? this.fDirectoryCombo.getText().trim() : this.fArchiveCombo.getText().trim());
            }
        }
        catch (CoreException coreException) {}
    }

    protected boolean doExportToDirectory() {
        return this.fDirectoryButton.getSelection();
    }

    private void chooseDestination() {
        DirectoryDialog dialog = new DirectoryDialog(this.fPage.getShell(), 8192);
        String path = this.fDirectoryCombo.getText();
        if (path.trim().length() == 0) {
            path = PDEPlugin.getWorkspace().getRoot().getLocation().toString();
        }
        dialog.setFilterPath(path);
        dialog.setText(PDEUIMessages.ExportWizard_dialog_title);
        dialog.setMessage(PDEUIMessages.ExportWizard_dialog_message);
        String res = dialog.open();
        if (res != null) {
            if (this.fDirectoryCombo.indexOf(res) == -1) {
                this.fDirectoryCombo.add(res, 0);
            }
            this.fDirectoryCombo.setText(res);
        }
    }

    protected String validate() {
        if (this.fArchiveFileButton.getSelection()) {
            if (this.fArchiveCombo.getText().trim().length() == 0) {
                return PDEUIMessages.ExportWizard_status_nofile;
            }
            if (!this.isValidLocation(this.fArchiveCombo.getText().trim())) {
                return PDEUIMessages.ExportWizard_status_invaliddirectory;
            }
        }
        if (this.fDirectoryButton.getSelection()) {
            if (this.fDirectoryCombo.getText().trim().length() == 0) {
                return PDEUIMessages.ExportWizard_status_nodirectory;
            }
            if (!this.isValidLocation(this.fDirectoryCombo.getText().trim())) {
                return PDEUIMessages.ExportWizard_status_invaliddirectory;
            }
        }
        return null;
    }

    protected String getFileName() {
        String path;
        if (this.fArchiveFileButton.getSelection() && (path = this.fArchiveCombo.getText()) != null && path.length() > 0) {
            String fileName = new Path(path).lastSegment();
            if (!fileName.endsWith(ZIP_EXTENSION)) {
                fileName = String.valueOf(fileName) + ZIP_EXTENSION;
            }
            return fileName;
        }
        return null;
    }

    protected String getDestination() {
        if (this.fArchiveFileButton.getSelection()) {
            String path = this.fArchiveCombo.getText();
            if (path.length() > 0) {
                path = new Path(path).removeLastSegments(1).toOSString();
                return new File(path).getAbsolutePath();
            }
            return "";
        }
        File dir = new File(this.fDirectoryCombo.getText().trim());
        return dir.getAbsolutePath();
    }
}

