/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class JUnitWorkbenchLaunchShortcut
extends JUnitLaunchShortcut {
    protected String getLaunchConfigurationTypeId() {
        return "org.eclipse.pde.ui.JunitLaunchConfig";
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IJavaElement element) throws CoreException {
        String vmArgs;
        ILaunchConfigurationWorkingCopy configuration = super.createLaunchConfiguration(element);
        if (TargetPlatformHelper.usesNewApplicationModel()) {
            configuration.setAttribute("pde.version", "3.3");
        } else if (TargetPlatformHelper.getTargetVersion() >= 3.2) {
            configuration.setAttribute("pde.version", "3.2a");
        }
        configuration.setAttribute("location", LaunchArgumentsHelper.getDefaultJUnitWorkspaceLocation());
        configuration.setAttribute("clearws", true);
        configuration.setAttribute("askclear", false);
        configuration.setAttribute("append.args", true);
        if (LauncherUtils.requiresUI((ILaunchConfiguration)configuration)) {
            String product = TargetPlatform.getDefaultProduct();
            if (product != null) {
                configuration.setAttribute("useProduct", true);
                configuration.setAttribute("product", product);
            }
        } else {
            configuration.setAttribute("application", "org.eclipse.pde.junit.runtime.coretestapplication");
        }
        configuration.setAttribute("default", true);
        String programArgs = LaunchArgumentsHelper.getInitialProgramArguments();
        if (programArgs.length() > 0) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
        }
        if ((vmArgs = LaunchArgumentsHelper.getInitialVMArguments()).length() > 0) {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        }
        configuration.setAttribute("useDefaultConfig", true);
        configuration.setAttribute("useDefaultConfigArea", false);
        configuration.setAttribute("configLocation", LaunchArgumentsHelper.getDefaultJUnitConfigurationLocation());
        configuration.setAttribute("clearConfig", true);
        configuration.setAttribute("checked", "[NONE]");
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
        return configuration;
    }
}

