/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointGroupMessages;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.BreakpointSelectionAction;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.PasteBreakpointsAction;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class CopyBreakpointsAction
extends BreakpointSelectionAction {
    private Clipboard clipboard;
    private PasteBreakpointsAction pasteAction;

    public CopyBreakpointsAction(BreakpointsView view, Clipboard clipboard) {
        super(BreakpointGroupMessages.CopyBreakpointsAction_0, view);
        Assert.isNotNull((Object)clipboard);
        this.clipboard = clipboard;
        this.setToolTipText(BreakpointGroupMessages.CopyBreakpointsAction_1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.copy_breakpoints_action_context");
    }

    public CopyBreakpointsAction(BreakpointsView view, Clipboard clipboard, PasteBreakpointsAction pasteAction) {
        this(view, clipboard);
        this.pasteAction = pasteAction;
    }

    public void run() {
        IStructuredSelection selection = this.getStructuredSelection();
        Object[] objects = selection.toArray();
        StringBuffer buffer = new StringBuffer();
        ILabelProvider labelProvider = (ILabelProvider)((StructuredViewer)this.getBreakpointsView().getViewer()).getLabelProvider();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (i > 0) {
                buffer.append("\n");
            }
            buffer.append(labelProvider.getText(object));
            ++i;
        }
        this.setClipboard((ISelection)selection, buffer.toString());
        if (this.pasteAction != null && this.pasteAction.getStructuredSelection() != null) {
            this.pasteAction.selectionChanged(this.pasteAction.getStructuredSelection());
        }
    }

    private void setClipboard(ISelection selection, String text) {
        block3: {
            try {
                LocalSelectionTransfer.getInstance().setSelection(selection);
                LocalSelectionTransfer.getInstance().setSelectionSetTime(System.currentTimeMillis());
                this.clipboard.setContents(new Object[]{selection, text}, new Transfer[]{LocalSelectionTransfer.getInstance(), TextTransfer.getInstance()});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.getBreakpointsView().getSite().getShell(), (String)BreakpointGroupMessages.CopyBreakpointsAction_2, (String)BreakpointGroupMessages.CopyBreakpointsAction_3)) break block3;
                this.setClipboard(selection, text);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof IBreakpoint) continue;
            return false;
        }
        return true;
    }
}

