/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.services;

import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextFunction;
import org.eclipse.e4.ui.services.ECommandService;

public class ContextCommandService
implements ECommandService {
    private static final String HANDLER_PREFIX = "HDL_";
    private static final String CMD_PREFIX = "CMD_";
    private static final String CMD_CAT_PREFIX = "CMD_CAT_";
    private IEclipseContext context;
    private CommandManager commandManager;

    public ContextCommandService(IEclipseContext context) {
        this.context = context;
        this.commandManager = (CommandManager)context.get(CommandManager.class.getName());
    }

    public Category getCategory(String categoryId) {
        Category cat = (Category)this.context.get(CMD_CAT_PREFIX + categoryId);
        if (cat == null) {
            cat = this.commandManager.getCategory(CMD_CAT_PREFIX + categoryId);
            this.context.set(CMD_CAT_PREFIX + categoryId, (Object)cat);
        }
        return cat;
    }

    public Command getCommand(String commandId) {
        Command cmd = (Command)this.context.get(CMD_PREFIX + commandId);
        if (cmd == null) {
            cmd = this.commandManager.getCommand(commandId);
            this.context.set(CMD_PREFIX + commandId, (Object)cmd);
            this.context.set(commandId, (Object)new CommandHandlerFunction(commandId));
        }
        return cmd;
    }

    public static class CommandHandlerFunction
    extends ContextFunction {
        private String commandId;

        public CommandHandlerFunction(String commandId) {
            this.commandId = commandId;
        }

        public Object compute(IEclipseContext context, Object[] arguments) {
            IEclipseContext childContext = (IEclipseContext)context.getLocal("activeChild");
            if (childContext != null) {
                return childContext.get(this.commandId, arguments);
            }
            if (arguments.length > 0 && "handler".equals(arguments[0])) {
                return context.get(ContextCommandService.HANDLER_PREFIX + this.commandId);
            }
            return context.get(ContextCommandService.CMD_PREFIX + this.commandId);
        }
    }
}

