/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateGroupOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class WizardNewGroupMainPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection currentSelection;
    private IFolder newGroup;
    private ResourceAndContainerGroup resourceGroup;
    static /* synthetic */ Class class$0;

    public WizardNewGroupMainPage(String pageName, IStructuredSelection selection) {
        super("newGroupPage1");
        this.setTitle(pageName);
        this.setDescription(IDEWorkbenchMessages.WizardNewGroupMainPage_description);
        this.currentSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_group_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(composite, this, IDEWorkbenchMessages.WizardNewGroupMainPage_groupName, IDEWorkbenchMessages.WizardNewGroupMainPage_groupLabel, false, 250);
        this.resourceGroup.setAllowExistingResources(false);
        this.initializePage();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected IFolder createGroupHandle(IPath groupPath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(groupPath);
    }

    public IFolder createNewGroup() {
        if (this.newGroup != null) {
            return this.newGroup;
        }
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.resourceGroup.getResource());
        final IFolder newFolderHandle = this.createGroupHandle(newFolderPath);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateGroupOperation op = new CreateGroupOperation(newFolderHandle, IDEWorkbenchMessages.WizardNewGroupCreationPage_title);
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter(WizardNewGroupMainPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    WizardNewGroupMainPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(this, e){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ExecutionException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$e = executionException;
                        }

                        public void run() {
                            if (this.val$e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)WizardNewGroupMainPage.access$0(1.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewGroupCreationPage_errorTitle, null, (IStatus)((CoreException)this.val$e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), "createNewGroup()", this.val$e.getCause());
                                MessageDialog.openError((Shell)WizardNewGroupMainPage.access$0(1.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewGroupCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewGroup_internalError, (Object)this.val$e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ WizardNewGroupMainPage access$0(1 var0) {
                return var0.WizardNewGroupMainPage.this;
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "createNewGroup()", e.getTargetException());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewGroupCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewGroup_internalError, (Object)e.getTargetException().getMessage()));
            return null;
        }
        this.newGroup = newFolderHandle;
        return this.newGroup;
    }

    public void handleEvent(Event ev) {
        this.setPageComplete(this.validatePage());
    }

    protected void initializePage() {
        Iterator it = this.currentSelection.iterator();
        if (it.hasNext()) {
            Object next = it.next();
            IResource selectedResource = null;
            if (next instanceof IResource) {
                selectedResource = (IResource)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                selectedResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (selectedResource != null) {
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                if (selectedResource.isAccessible()) {
                    this.resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                }
            }
        }
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceGroup.setFocus();
        }
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        if (valid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }
}

