/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;

class FilterEditDialog
extends TrayDialog {
    private FilterCopy filter;
    protected Button includeButton;
    protected Button excludeButton;
    protected Button filesButton;
    protected Button foldersButton;
    protected Button filesAndFoldersButton;
    protected Combo idCombo;
    protected Button inherited;
    protected Text arguments;
    protected Label description;
    protected FilterTypeUtil util;

    public FilterEditDialog(Shell parentShell, FilterCopy filter) {
        super(parentShell);
        this.filter = filter;
        this.util = new FilterTypeUtil();
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000000, 0x1000000, true, false);
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.ui.ide.edit_resource_filter_property_page_context");
        Composite topComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        topComposite.setLayout((Layout)layout);
        data = new GridData(16384, 0x1000000, true, false);
        topComposite.setLayoutData((Object)data);
        topComposite.setFont(font);
        this.createModeArea(font, topComposite);
        this.createTargetArea(font, topComposite);
        this.createIdArea(font, composite);
        return composite;
    }

    private void createInheritableArea(Font font, Composite composite) {
        if (!this.filter.isUnderAGroupFilter()) {
            this.inherited = new Button(composite, 32);
            this.inherited.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterInheritable, null));
            GridData data = new GridData(4, 0x1000000, true, false);
            data.horizontalSpan = 1;
            this.inherited.setLayoutData((Object)data);
            this.inherited.setFont(font);
            this.inherited.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.INHERITABLE, new Boolean(FilterEditDialog.this.inherited.getSelection()));
                }
            });
            this.inherited.setSelection(((Boolean)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.INHERITABLE)).booleanValue());
        }
    }

    private void createArgumentsArea(Font font, Composite composite) {
        this.addLabel(composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterArguments, null));
        this.arguments = new Text(composite, 2052);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.arguments.setLayoutData((Object)data);
        this.arguments.setFont(font);
        this.arguments.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.ARGUMENTS, FilterEditDialog.this.arguments.getText());
            }
        });
        if (this.filter.hasStringArguments()) {
            this.arguments.setText((String)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.ARGUMENTS));
        }
        this.arguments.setEnabled(this.filter.hasStringArguments());
    }

    private void createDescriptionArea(Font font, Composite composite) {
        this.description = new Label(composite, 16448);
        this.description.setText(FilterTypeUtil.getDescriptor(this.filter.getId()).getDescription());
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 300;
        data.heightHint = 40;
        this.description.setLayoutData((Object)data);
        this.description.setFont(font);
    }

    private void createIdArea(Font font, Composite composite) {
        Group idComposite = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterID, null));
        this.idCombo = new Combo((Composite)idComposite, 8);
        this.idCombo.setItems(FilterTypeUtil.getFilterNames(this.filter.getChildrenLimit() > 0));
        GridData data = new GridData(4, 0x1000000, true, true);
        this.idCombo.setLayoutData((Object)data);
        this.idCombo.setFont(font);
        this.idCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.ID, FilterEditDialog.this.idCombo.getItem(FilterEditDialog.this.idCombo.getSelectionIndex()));
                FilterEditDialog.this.arguments.setEnabled(FilterEditDialog.this.filter.hasStringArguments());
                FilterEditDialog.this.description.setText(FilterTypeUtil.getDescriptor(FilterEditDialog.this.filter.getId()).getDescription());
            }
        });
        this.idCombo.select(((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.ID)).intValue());
        Composite argumentComposite = new Composite((Composite)idComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        argumentComposite.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        argumentComposite.setLayoutData((Object)data);
        argumentComposite.setFont(font);
        this.createArgumentsArea(font, argumentComposite);
        this.createDescriptionArea(font, (Composite)idComposite);
    }

    private void createModeArea(Font font, Composite composite) {
        if (!this.filter.isUnderAGroupFilter()) {
            Group modeComposite = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterMode, null));
            String[] modes = FilterTypeUtil.getModes();
            this.includeButton = new Button((Composite)modeComposite, 16);
            this.includeButton.setText(modes[0]);
            this.includeButton.setImage(this.util.getImage(FilterTypeUtil.MODE, 0));
            GridData data = new GridData(4, 0x1000000, true, false);
            this.includeButton.setLayoutData((Object)data);
            this.includeButton.setFont(font);
            this.includeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.MODE, new Integer(0));
                }
            });
            this.includeButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.MODE) == 0);
            this.excludeButton = new Button((Composite)modeComposite, 16);
            this.excludeButton.setText(modes[1]);
            this.excludeButton.setImage(this.util.getImage(FilterTypeUtil.MODE, 1));
            data = new GridData(4, 0x1000000, true, false);
            this.excludeButton.setLayoutData((Object)data);
            this.excludeButton.setFont(font);
            this.excludeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.MODE, new Integer(1));
                }
            });
            this.excludeButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.MODE) == 1);
            this.createInheritableArea(font, (Composite)modeComposite);
        } else {
            this.createInheritableArea(font, composite);
        }
    }

    private Group createGroup(Font font, Composite composite, String text) {
        Group modeComposite = new Group(composite, 0);
        modeComposite.setText(text);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        modeComposite.setLayout((Layout)layout);
        GridData data = new GridData(16384, 0x1000000, true, false);
        modeComposite.setLayoutData((Object)data);
        modeComposite.setFont(font);
        return modeComposite;
    }

    private void createTargetArea(Font font, Composite composite) {
        Group targetComposite = this.createGroup(font, composite, NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterTargets, null));
        String[] targets = FilterTypeUtil.getTargets();
        this.filesButton = new Button((Composite)targetComposite, 16);
        this.filesButton.setText(targets[0]);
        this.filesButton.setImage(this.util.getImage(FilterTypeUtil.TARGET, 0));
        GridData data = new GridData(4, 0x1000000, true, false);
        this.filesButton.setLayoutData((Object)data);
        this.filesButton.setFont(font);
        this.foldersButton = new Button((Composite)targetComposite, 16);
        this.foldersButton.setText(targets[1]);
        this.foldersButton.setImage(this.util.getImage(FilterTypeUtil.TARGET, 1));
        data = new GridData(4, 0x1000000, true, false);
        this.foldersButton.setLayoutData((Object)data);
        this.foldersButton.setFont(font);
        this.filesAndFoldersButton = new Button((Composite)targetComposite, 16);
        this.filesAndFoldersButton.setText(targets[2]);
        this.filesAndFoldersButton.setImage(this.util.getImage(FilterTypeUtil.TARGET, 2));
        data = new GridData(4, 0x1000000, true, false);
        this.filesAndFoldersButton.setLayoutData((Object)data);
        this.filesAndFoldersButton.setFont(font);
        this.filesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(0));
            }
        });
        this.foldersButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(1));
            }
        });
        this.filesAndFoldersButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterTypeUtil.setValue(FilterEditDialog.this.filter, FilterTypeUtil.TARGET, new Integer(2));
            }
        });
        this.filesButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 0);
        this.foldersButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 1);
        this.filesAndFoldersButton.setSelection((Integer)FilterTypeUtil.getValue(this.filter, FilterTypeUtil.TARGET) == 2);
    }

    void addLabel(Composite composite, String text) {
        String delimiter = ":";
        Font font = composite.getFont();
        Label label = new Label(composite, 16384);
        label.setText(String.valueOf(text) + delimiter);
        GridData data = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        label.setFont(font);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.initialize();
        this.update();
        return control;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_editFilterDialogTitle, null));
        super.configureShell(newShell);
    }

    private void initialize() {
    }

    protected void update() {
    }

    protected void okPressed() {
        super.okPressed();
    }
}

