/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import org.eclipse.core.resources.FilterTypeManager;
import org.eclipse.core.resources.IFilter;
import org.eclipse.core.resources.IFilterType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class CompoundFilter {
    private static final String T_FILTERS = "filters";
    private static final String T_FILTER = "filter";
    private static final String T_TYPE = "type";
    private static final String T_ID = "id";
    private static final String T_ARGUMENTS = "arguments";

    protected IFilterType instantiate(IProject project, IFilter filter) {
        FilterTypeManager.Descriptor desc = FilterTypeManager.getDefault().findDescriptor(filter.getId());
        if (desc != null) {
            return desc.getFactory().instantiate(project, filter.getArguments());
        }
        return null;
    }

    public static IFilter[] unserialize(final IProject project, String memento) {
        LinkedList<1> filters = new LinkedList<1>();
        XMLMemento mementoObject = null;
        try {
            mementoObject = XMLMemento.createReadRoot((Reader)new StringReader(memento));
        }
        catch (WorkbenchException workbenchException) {
            return new IFilter[0];
        }
        IMemento childMem = mementoObject.getChild(T_FILTERS);
        if (childMem != null) {
            IMemento[] elementMem = childMem.getChildren(T_FILTER);
            int i = 0;
            while (i < elementMem.length) {
                final String id = elementMem[i].getString(T_ID);
                final int type = elementMem[i].getInteger(T_TYPE);
                IMemento argumentMem = elementMem[i].getChild(T_ARGUMENTS);
                final String arguments = argumentMem != null ? argumentMem.getTextData() : "";
                filters.add(new IFilter(){

                    public String getArguments() {
                        return arguments;
                    }

                    public String getId() {
                        return id;
                    }

                    public IPath getPath() {
                        return null;
                    }

                    public IProject getProject() {
                        return project;
                    }

                    public int getType() {
                        return type;
                    }
                });
                ++i;
            }
        }
        return filters.toArray(new IFilter[0]);
    }

    public static String serialize(IFilter[] filters) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)"memento");
        IMemento expandedMem = memento.createChild(T_FILTERS);
        int i = 0;
        while (i < filters.length) {
            IMemento elementMem = expandedMem.createChild(T_FILTER);
            elementMem.putString(T_ID, filters[i].getId());
            elementMem.putInteger(T_TYPE, filters[i].getType());
            IMemento argumentMem = elementMem.createChild(T_ARGUMENTS);
            argumentMem.putTextData(filters[i].getArguments());
            ++i;
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException iOException) {
            return "";
        }
        return writer.toString();
    }

    protected abstract class FilterType
    implements IFilterType {
        protected IFilterType[] filterTypes;
        protected IFilter[] filters;

        public FilterType(IProject project, IFilter[] filters) {
            this.filters = filters;
            this.filterTypes = new IFilterType[filters.length];
            int i = 0;
            while (i < filters.length) {
                this.filterTypes[i] = CompoundFilter.this.instantiate(project, filters[i]);
                ++i;
            }
        }
    }
}

