/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerMap;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class MarkerContentGenerator {
    private static final String ATTRIBUTE_DEFAULT_MARKER_GROUPING = "defaultMarkerGrouping";
    private static final String ATTRIBUTE_VISIBLE = "visible";
    public static final Object CACHE_UPDATE_FAMILY = new Object();
    private static final String ELEMENT_MARKER_FIELD_CONFIGURATION = "markerFieldConfiguration";
    private static final IResource[] EMPTY_RESOURCE_ARRAY = new IResource[0];
    private static final String MARKER_FIELD_REFERENCE = "markerFieldReference";
    private MarkerField[] allFields;
    private IConfigurationElement configurationElement;
    private Collection markerTypes;
    private MarkerField[] initialVisible;
    private Collection groups;
    private Collection generatorExtensions = new ArrayList();
    private Map allTypesTable;
    static /* synthetic */ Class class$0;

    public MarkerContentGenerator(IConfigurationElement element) {
        this.configurationElement = element;
    }

    private void addDefinedGroups(Collection groups) {
        this.addGroupsFrom(this.configurationElement, groups);
        Iterator extensions = this.generatorExtensions.iterator();
        while (extensions.hasNext()) {
            this.addGroupsFrom((IConfigurationElement)extensions.next(), groups);
        }
    }

    public void addExtensions(Collection extensions) {
        this.generatorExtensions = extensions;
    }

    private void addGroupsFrom(IConfigurationElement element, Collection groups) {
        IConfigurationElement[] groupings = element.getChildren("markerGrouping");
        int i = 0;
        while (i < groupings.length) {
            groups.add(MarkerGroup.createMarkerGroup(groupings[i]));
            ++i;
        }
    }

    boolean allTypesSelected(Collection selectedTypes) {
        return selectedTypes.containsAll(this.markerTypes);
    }

    private Collection computeAllMarkers(SubProgressMonitor subMonitor) {
        HashSet allMarkers = new HashSet();
        this.findMarkers(allMarkers, new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, null, 2, (IProgressMonitor)subMonitor);
        return allMarkers;
    }

    private void computeMarkers(Collection returnMarkers, SubProgressMonitor subMonitor, MarkerFieldFilterGroup filterGroup, IResource[] focusResources) {
        int filterType = filterGroup.getScope();
        filterGroup.refresh();
        switch (filterType) {
            case 0: {
                this.findMarkers(returnMarkers, new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, filterGroup, 2, (IProgressMonitor)subMonitor);
                break;
            }
            case 1: {
                this.findMarkers(returnMarkers, focusResources, filterGroup, 0, (IProgressMonitor)subMonitor);
                break;
            }
            case 2: {
                this.findMarkers(returnMarkers, focusResources, filterGroup, 2, (IProgressMonitor)subMonitor);
                break;
            }
            case 3: {
                this.findMarkers(returnMarkers, this.getProjects(focusResources), filterGroup, 2, (IProgressMonitor)subMonitor);
                break;
            }
            case 4: {
                this.findMarkers(returnMarkers, this.getResourcesInWorkingSet(filterGroup.getWorkingSet()), filterGroup, 2, (IProgressMonitor)subMonitor);
            }
        }
    }

    private void filterMarkers(Collection results, MarkerFieldFilterGroup group, IMarker[] markers) {
        int idx = 0;
        while (idx < markers.length) {
            IMarker marker = markers[idx];
            if (group == null || group.select(marker)) {
                results.add(marker);
            }
            ++idx;
        }
    }

    private void findIntersection(Collection matching, Collection returnMarkers) {
        HashSet removeMarkers = new HashSet();
        Iterator existing = returnMarkers.iterator();
        while (existing.hasNext()) {
            Object next = existing.next();
            if (matching.contains(next)) continue;
            removeMarkers.add(next);
        }
        returnMarkers.removeAll(removeMarkers);
    }

    /*
     * Unable to fully structure code
     */
    private void findMarkers(Collection results, IResource[] resources, MarkerFieldFilterGroup group, int depth, IProgressMonitor monitor) {
        if (resources == null) {
            return;
        }
        selectedTypes = this.getMarkerTypes();
        typesToSearch = new HashSet<E>(selectedTypes.size());
        includeAllSubtypes = new HashSet<MarkerType>(selectedTypes.size());
        typesToSearch.addAll(selectedTypes);
        iter = selectedTypes.iterator();
        while (iter.hasNext()) {
            type = (MarkerType)iter.next();
            subtypes = Arrays.asList(type.getAllSubTypes());
            if (!selectedTypes.containsAll(subtypes)) continue;
            typesToSearch.removeAll(subtypes);
            includeAllSubtypes.add(type);
        }
        monitor.beginTask(MarkerMessages.MarkerFilter_searching, typesToSearch.size() * resources.length);
        resourcesToSearch = new HashSet<IResource>();
        idx = 0;
        while (idx < resources.length) {
            next = resources[idx];
            if (next.exists()) {
                if (resourcesToSearch.contains(next)) {
                    monitor.worked(typesToSearch.size());
                } else {
                    resourcesToSearch.add(next);
                }
            }
            ++idx;
        }
        resourceIdx = 0;
        while (resourceIdx < resources.length) {
            block12: {
                iter = typesToSearch.iterator();
                resource = resources[resourceIdx];
                if (!resource.isAccessible()) break block12;
                if (depth != 2) ** GOTO lbl54
                parent = resource.getParent();
                found = false;
                while (parent != null) {
                    if (resourcesToSearch.contains(parent)) {
                        found = true;
                    }
                    parent = parent.getParent();
                }
                if (!found) ** GOTO lbl54
                break block12;
lbl-1000:
                // 1 sources

                {
                    markerType = (MarkerType)iter.next();
                    try {
                        markers = resource.findMarkers(markerType.getId(), includeAllSubtypes.contains(markerType), depth);
                        monitor.worked(1);
                        this.filterMarkers(results, group, markers);
                        continue;
                    }
                    catch (CoreException e) {
                        Policy.handle(e);
                    }
lbl54:
                    // 4 sources

                    ** while (iter.hasNext())
                }
            }
            ++resourceIdx;
        }
        monitor.done();
    }

    MarkerMap generateFilteredMarkers(SubProgressMonitor subMonitor, boolean andFilters, IResource[] focusResources, Collection enabledFilters) {
        HashSet returnMarkers = null;
        if (enabledFilters.size() > 0) {
            Iterator filtersIterator = enabledFilters.iterator();
            if (andFilters) {
                HashSet matching = new HashSet();
                while (filtersIterator.hasNext()) {
                    this.computeMarkers(matching, subMonitor, (MarkerFieldFilterGroup)filtersIterator.next(), focusResources);
                    if (returnMarkers == null) {
                        returnMarkers = new HashSet(matching);
                    } else {
                        this.findIntersection(matching, returnMarkers);
                    }
                    matching.clear();
                }
            } else {
                returnMarkers = new HashSet();
                while (filtersIterator.hasNext()) {
                    this.computeMarkers(returnMarkers, subMonitor, (MarkerFieldFilterGroup)filtersIterator.next(), focusResources);
                }
            }
        } else {
            returnMarkers = this.computeAllMarkers(subMonitor);
        }
        MarkerEntry[] entries = new MarkerEntry[returnMarkers.size()];
        Iterator markers = returnMarkers.iterator();
        int index = 0;
        while (markers.hasNext()) {
            entries[index] = new MarkerEntry((IMarker)markers.next());
            ++index;
        }
        return new MarkerMap(entries);
    }

    MarkerField[] getAllFields() {
        return this.allFields;
    }

    String getCategoryName() {
        return this.configurationElement.getAttribute(ATTRIBUTE_DEFAULT_MARKER_GROUPING);
    }

    IConfigurationElement[] getFilterReferences() {
        IConfigurationElement[] filterGroups = this.configurationElement.getChildren(ELEMENT_MARKER_FIELD_CONFIGURATION);
        if (this.generatorExtensions.isEmpty()) {
            return filterGroups;
        }
        Iterator extensions = this.generatorExtensions.iterator();
        ArrayList<IConfigurationElement> extendedElements = new ArrayList<IConfigurationElement>();
        while (extensions.hasNext()) {
            IConfigurationElement extension = (IConfigurationElement)extensions.next();
            IConfigurationElement[] extensionFilters = extension.getChildren(ELEMENT_MARKER_FIELD_CONFIGURATION);
            int i = 0;
            while (i < extensionFilters.length) {
                extendedElements.add(extensionFilters[i]);
                ++i;
            }
        }
        if (extendedElements.size() > 0) {
            IConfigurationElement[] allGroups = new IConfigurationElement[filterGroups.length + extendedElements.size()];
            System.arraycopy(filterGroups, 0, allGroups, 0, filterGroups.length);
            Iterator extras = extendedElements.iterator();
            int index = filterGroups.length;
            while (extras.hasNext()) {
                allGroups[index] = (IConfigurationElement)extras.next();
            }
            return allGroups;
        }
        return filterGroups;
    }

    public String getId() {
        return this.configurationElement.getAttribute("id");
    }

    MarkerField[] getInitialVisible() {
        return this.initialVisible;
    }

    MarkerGroup getMarkerGroup(String groupName) {
        Iterator groups = this.getMarkerGroups().iterator();
        while (groups.hasNext()) {
            MarkerGroup group = (MarkerGroup)groups.next();
            if (!group.getId().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    Collection getMarkerGroups() {
        if (this.groups == null) {
            this.groups = new HashSet();
            this.addDefinedGroups(this.groups);
            if (this.getId().equals("org.eclipse.ui.ide.problemsGenerator")) {
                this.groups.addAll(MarkerSupportRegistry.getInstance().getMarkerGroups());
            }
        }
        return this.groups;
    }

    public Collection getMarkerTypes() {
        if (this.markerTypes == null) {
            this.markerTypes = new HashSet();
            IConfigurationElement[] markerTypeElements = this.configurationElement.getChildren("markerTypeReference");
            int i = 0;
            while (i < markerTypeElements.length) {
                IConfigurationElement configurationElement = markerTypeElements[i];
                String elementName = configurationElement.getAttribute("id");
                MarkerType[] types = MarkerTypesModel.getInstance().getType(elementName).getAllSubTypes();
                int j = 0;
                while (j < types.length) {
                    this.markerTypes.add(types[j]);
                    ++j;
                }
                this.markerTypes.add(MarkerTypesModel.getInstance().getType(elementName));
                ++i;
            }
            if (this.markerTypes.isEmpty()) {
                MarkerType[] types = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.problemmarker").getAllSubTypes();
                int i2 = 0;
                while (i2 < types.length) {
                    this.markerTypes.add(types[i2]);
                    ++i2;
                }
            }
        }
        return this.markerTypes;
    }

    String getName() {
        return this.configurationElement.getAttribute("name");
    }

    private IResource[] getProjects(IResource[] focusResources) {
        if (focusResources.length == 0) {
            return EMPTY_RESOURCE_ARRAY;
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        int idx = 0;
        while (idx < focusResources.length) {
            projects.add(focusResources[idx].getProject());
            ++idx;
        }
        if (projects.isEmpty()) {
            return EMPTY_RESOURCE_ARRAY;
        }
        return projects.toArray(new IResource[projects.size()]);
    }

    private IResource[] getResourcesInWorkingSet(IWorkingSet workingSet) {
        if (workingSet == null) {
            return new IResource[0];
        }
        if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty() && ((AggregateWorkingSet)workingSet).getComponents().length == 0) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IAdaptable[] elements = workingSet.getElements();
        ArrayList<IResource> result = new ArrayList<IResource>(elements.length);
        int idx = 0;
        while (idx < elements.length) {
            IResource next;
            IAdaptable iAdaptable = elements[idx];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((next = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                result.add(next);
            }
            ++idx;
        }
        return result.toArray(new IResource[result.size()]);
    }

    MarkerType getType(String typeId) {
        Map all = this.getTypesTable();
        if (all.containsKey(typeId)) {
            return (MarkerType)all.get(typeId);
        }
        return null;
    }

    private Map getTypesTable() {
        if (this.allTypesTable == null) {
            this.allTypesTable = new HashMap();
            Iterator allIterator = this.markerTypes.iterator();
            while (allIterator.hasNext()) {
                MarkerType next = (MarkerType)allIterator.next();
                this.allTypesTable.put(next.getId(), next);
            }
        }
        return this.allTypesTable;
    }

    public void initializeFromConfigurationElement(MarkerSupportRegistry registry) {
        IConfigurationElement[] elements = this.configurationElement.getChildren(MARKER_FIELD_REFERENCE);
        ArrayList<MarkerField> allFieldList = new ArrayList<MarkerField>();
        ArrayList<MarkerField> initialVisibleList = new ArrayList<MarkerField>();
        int i = 0;
        while (i < elements.length) {
            MarkerField field = registry.getField(elements[i].getAttribute("id"));
            if (field != null) {
                allFieldList.add(field);
                if (!MarkerSupportInternalUtilities.VALUE_FALSE.equals(elements[i].getAttribute(ATTRIBUTE_VISIBLE))) {
                    initialVisibleList.add(field);
                }
            }
            ++i;
        }
        this.allFields = new MarkerField[allFieldList.size()];
        allFieldList.toArray(this.allFields);
        this.initialVisible = new MarkerField[initialVisibleList.size()];
        initialVisibleList.toArray(this.initialVisible);
    }

    public void removeExtension(IConfigurationElement element) {
        this.generatorExtensions.remove(element);
    }
}

