/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerGroupingEntry;

class MarkerSortUtil {
    MarkerSortUtil() {
    }

    public static void sortStatingKElement(MarkerEntry[] entries, Comparator comparator, int from, int to, int k) {
        int fromK = from + k - 1;
        if (entries.length == 0 || from < 0 || from >= to || fromK < from || fromK > to || to > entries.length - 1 || to < 0) {
            return;
        }
        Arrays.sort(entries, from, to, comparator);
        int i = from;
        while (i <= to) {
            entries[i].clearCache();
            ++i;
        }
    }

    public static void sortStatingKElement(MarkerEntry[] entries, Comparator comparator, int k) {
        MarkerSortUtil.sortStatingKElement(entries, comparator, 0, entries.length - 1, k);
    }

    public static Map groupMarkerEnteries(MarkerEntry[] entries, MarkerGroup group, int k) {
        ArrayList<MarkerEntry> list;
        TreeMap<MarkerGroupingEntry, Serializable> map = new TreeMap<MarkerGroupingEntry, Serializable>(group.getEntriesComparator());
        int i = 0;
        while (i <= k) {
            IMarker marker = entries[i].getMarker();
            if (marker != null && marker.exists()) {
                try {
                    MarkerGroupingEntry groupingEntry = group.findGroupValue(marker.getType(), marker);
                    list = (List)map.get(groupingEntry);
                    if (list == null) {
                        list = new ArrayList<MarkerEntry>();
                        map.put(groupingEntry, list);
                    }
                    list.add(entries[i]);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        Iterator keys = map.keySet().iterator();
        int i2 = 0;
        while (keys.hasNext()) {
            Object key = keys.next();
            list = (ArrayList<MarkerEntry>)map.get(key);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MarkerEntry entry = (MarkerEntry)iterator.next();
                entries[i2++] = entry;
            }
            map.put((MarkerGroupingEntry)key, new Integer(i2 - 1));
        }
        return map;
    }
}

